import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisableFastLaunchRequest, DisableFastLaunchResult } from "../models/models_5";
export interface DisableFastLaunchCommandInput extends DisableFastLaunchRequest {
}
export interface DisableFastLaunchCommandOutput extends DisableFastLaunchResult, __MetadataBearer {
}
/**
 * <p>Discontinue faster launching for a Windows AMI, and clean up existing pre-provisioned snapshots.
 * 			When you disable faster launching, the AMI uses the standard launch process for each
 * 			instance. All pre-provisioned snapshots must be removed before you can enable faster launching again.</p>
 *          <note>
 *             <p>To change these settings, you must own the AMI.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisableFastLaunchCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisableFastLaunchCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DisableFastLaunchCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DisableFastLaunchCommandInput} for command's `input` shape.
 * @see {@link DisableFastLaunchCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DisableFastLaunchCommand extends $Command<DisableFastLaunchCommandInput, DisableFastLaunchCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DisableFastLaunchCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DisableFastLaunchCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DisableFastLaunchCommandInput, DisableFastLaunchCommandOutput>;
    private serialize;
    private deserialize;
}
