import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DisableAwsNetworkPerformanceMetricSubscriptionRequest, DisableAwsNetworkPerformanceMetricSubscriptionResult } from "../models/models_5";
export interface DisableAwsNetworkPerformanceMetricSubscriptionCommandInput extends DisableAwsNetworkPerformanceMetricSubscriptionRequest {
}
export interface DisableAwsNetworkPerformanceMetricSubscriptionCommandOutput extends DisableAwsNetworkPerformanceMetricSubscriptionResult, __MetadataBearer {
}
/**
 * <p>Disables Infrastructure Performance metric subscriptions.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DisableAwsNetworkPerformanceMetricSubscriptionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DisableAwsNetworkPerformanceMetricSubscriptionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DisableAwsNetworkPerformanceMetricSubscriptionCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DisableAwsNetworkPerformanceMetricSubscriptionCommandInput} for command's `input` shape.
 * @see {@link DisableAwsNetworkPerformanceMetricSubscriptionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DisableAwsNetworkPerformanceMetricSubscriptionCommand extends $Command<DisableAwsNetworkPerformanceMetricSubscriptionCommandInput, DisableAwsNetworkPerformanceMetricSubscriptionCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DisableAwsNetworkPerformanceMetricSubscriptionCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DisableAwsNetworkPerformanceMetricSubscriptionCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DisableAwsNetworkPerformanceMetricSubscriptionCommandInput, DisableAwsNetworkPerformanceMetricSubscriptionCommandOutput>;
    private serialize;
    private deserialize;
}
