import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeCapacityReservationFleetsRequest, DescribeCapacityReservationFleetsResult } from "../models/models_3";
export interface DescribeCapacityReservationFleetsCommandInput extends DescribeCapacityReservationFleetsRequest {
}
export interface DescribeCapacityReservationFleetsCommandOutput extends DescribeCapacityReservationFleetsResult, __MetadataBearer {
}
/**
 * <p>Describes one or more Capacity Reservation Fleets.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeCapacityReservationFleetsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeCapacityReservationFleetsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DescribeCapacityReservationFleetsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DescribeCapacityReservationFleetsCommandInput} for command's `input` shape.
 * @see {@link DescribeCapacityReservationFleetsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DescribeCapacityReservationFleetsCommand extends $Command<DescribeCapacityReservationFleetsCommandInput, DescribeCapacityReservationFleetsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeCapacityReservationFleetsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DescribeCapacityReservationFleetsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeCapacityReservationFleetsCommandInput, DescribeCapacityReservationFleetsCommandOutput>;
    private serialize;
    private deserialize;
}
