import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DescribeAwsNetworkPerformanceMetricSubscriptionsRequest, DescribeAwsNetworkPerformanceMetricSubscriptionsResult } from "../models/models_3";
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput extends DescribeAwsNetworkPerformanceMetricSubscriptionsRequest {
}
export interface DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput extends DescribeAwsNetworkPerformanceMetricSubscriptionsResult, __MetadataBearer {
}
/**
 * <p>Describes the current Infrastructure Performance metric subscriptions.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DescribeAwsNetworkPerformanceMetricSubscriptionsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DescribeAwsNetworkPerformanceMetricSubscriptionsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DescribeAwsNetworkPerformanceMetricSubscriptionsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput} for command's `input` shape.
 * @see {@link DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DescribeAwsNetworkPerformanceMetricSubscriptionsCommand extends $Command<DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput, DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DescribeAwsNetworkPerformanceMetricSubscriptionsCommandInput, DescribeAwsNetworkPerformanceMetricSubscriptionsCommandOutput>;
    private serialize;
    private deserialize;
}
