import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult } from "../models/models_2";
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput extends DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
}
export interface DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput extends DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult, __MetadataBearer {
}
/**
 * <p>
 *       Deletes a local gateway route table virtual interface group association.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput} for command's `input` shape.
 * @see {@link DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand extends $Command<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput>;
    private serialize;
    private deserialize;
}
