import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteIpamPoolRequest, DeleteIpamPoolResult } from "../models/models_2";
export interface DeleteIpamPoolCommandInput extends DeleteIpamPoolRequest {
}
export interface DeleteIpamPoolCommandOutput extends DeleteIpamPoolResult, __MetadataBearer {
}
/**
 * <p>Delete an IPAM pool.</p>
 *          <note>
 *             <p>You cannot delete an IPAM pool if there are allocations in it or CIDRs provisioned to it. To release
 *          allocations, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ReleaseIpamPoolAllocation.html">ReleaseIpamPoolAllocation</a>. To deprovision pool
 *          CIDRs, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DeprovisionIpamPoolCidr.html">DeprovisionIpamPoolCidr</a>.</p>
 *          </note>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/delete-pool-ipam.html">Delete a pool</a> in the <i>Amazon VPC IPAM User Guide</i>.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteIpamPoolCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteIpamPoolCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteIpamPoolCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteIpamPoolCommandInput} for command's `input` shape.
 * @see {@link DeleteIpamPoolCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteIpamPoolCommand extends $Command<DeleteIpamPoolCommandInput, DeleteIpamPoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteIpamPoolCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: DeleteIpamPoolCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteIpamPoolCommandInput, DeleteIpamPoolCommandOutput>;
    private serialize;
    private deserialize;
}
