import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateVerifiedAccessTrustProviderRequest, CreateVerifiedAccessTrustProviderResult } from "../models/models_2";
export interface CreateVerifiedAccessTrustProviderCommandInput extends CreateVerifiedAccessTrustProviderRequest {
}
export interface CreateVerifiedAccessTrustProviderCommandOutput extends CreateVerifiedAccessTrustProviderResult, __MetadataBearer {
}
/**
 * <p>A trust provider is a third-party entity that creates, maintains, and manages identity
 *          information for users and devices. When an application request is made, the identity
 *          information sent by the trust provider will be evaluated by Amazon Web Services Verified Access, before allowing or
 *          denying the application request.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateVerifiedAccessTrustProviderCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateVerifiedAccessTrustProviderCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateVerifiedAccessTrustProviderCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateVerifiedAccessTrustProviderCommandInput} for command's `input` shape.
 * @see {@link CreateVerifiedAccessTrustProviderCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateVerifiedAccessTrustProviderCommand extends $Command<CreateVerifiedAccessTrustProviderCommandInput, CreateVerifiedAccessTrustProviderCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateVerifiedAccessTrustProviderCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateVerifiedAccessTrustProviderCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateVerifiedAccessTrustProviderCommandInput, CreateVerifiedAccessTrustProviderCommandOutput>;
    private serialize;
    private deserialize;
}
