import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateVerifiedAccessInstanceRequest, CreateVerifiedAccessInstanceResult } from "../models/models_2";
export interface CreateVerifiedAccessInstanceCommandInput extends CreateVerifiedAccessInstanceRequest {
}
export interface CreateVerifiedAccessInstanceCommandOutput extends CreateVerifiedAccessInstanceResult, __MetadataBearer {
}
/**
 * <p>An Amazon Web Services Verified Access instance is a regional entity that evaluates application requests and grants
 *          access only when your security requirements are met.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateVerifiedAccessInstanceCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateVerifiedAccessInstanceCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateVerifiedAccessInstanceCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateVerifiedAccessInstanceCommandInput} for command's `input` shape.
 * @see {@link CreateVerifiedAccessInstanceCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateVerifiedAccessInstanceCommand extends $Command<CreateVerifiedAccessInstanceCommandInput, CreateVerifiedAccessInstanceCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateVerifiedAccessInstanceCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateVerifiedAccessInstanceCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateVerifiedAccessInstanceCommandInput, CreateVerifiedAccessInstanceCommandOutput>;
    private serialize;
    private deserialize;
}
