import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateTransitGatewayRouteTableAnnouncementRequest, CreateTransitGatewayRouteTableAnnouncementResult } from "../models/models_2";
export interface CreateTransitGatewayRouteTableAnnouncementCommandInput extends CreateTransitGatewayRouteTableAnnouncementRequest {
}
export interface CreateTransitGatewayRouteTableAnnouncementCommandOutput extends CreateTransitGatewayRouteTableAnnouncementResult, __MetadataBearer {
}
/**
 * <p>Advertises a new transit gateway route table.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateTransitGatewayRouteTableAnnouncementCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateTransitGatewayRouteTableAnnouncementCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateTransitGatewayRouteTableAnnouncementCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateTransitGatewayRouteTableAnnouncementCommandInput} for command's `input` shape.
 * @see {@link CreateTransitGatewayRouteTableAnnouncementCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateTransitGatewayRouteTableAnnouncementCommand extends $Command<CreateTransitGatewayRouteTableAnnouncementCommandInput, CreateTransitGatewayRouteTableAnnouncementCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateTransitGatewayRouteTableAnnouncementCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateTransitGatewayRouteTableAnnouncementCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateTransitGatewayRouteTableAnnouncementCommandInput, CreateTransitGatewayRouteTableAnnouncementCommandOutput>;
    private serialize;
    private deserialize;
}
