import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult } from "../models/models_1";
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput extends CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest {
}
export interface CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput extends CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult, __MetadataBearer {
}
/**
 * <p>
 *       Creates a local gateway route table virtual interface group association.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput} for command's `input` shape.
 * @see {@link CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand extends $Command<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandInput, CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandOutput>;
    private serialize;
    private deserialize;
}
