import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateIpamScopeRequest, CreateIpamScopeResult } from "../models/models_1";
export interface CreateIpamScopeCommandInput extends CreateIpamScopeRequest {
}
export interface CreateIpamScopeCommandOutput extends CreateIpamScopeResult, __MetadataBearer {
}
/**
 * <p>Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/add-scope-ipam.html">Add a scope</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateIpamScopeCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateIpamScopeCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateIpamScopeCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateIpamScopeCommandInput} for command's `input` shape.
 * @see {@link CreateIpamScopeCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateIpamScopeCommand extends $Command<CreateIpamScopeCommandInput, CreateIpamScopeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateIpamScopeCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateIpamScopeCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateIpamScopeCommandInput, CreateIpamScopeCommandOutput>;
    private serialize;
    private deserialize;
}
