import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateIpamRequest, CreateIpamResult } from "../models/models_1";
export interface CreateIpamCommandInput extends CreateIpamRequest {
}
export interface CreateIpamCommandOutput extends CreateIpamResult, __MetadataBearer {
}
/**
 * <p>Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use
 *          to automate your IP address management workflows including assigning, tracking,
 *          troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts
 *          throughout your Amazon Web Services Organization.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/ipam/create-ipam.html">Create an IPAM</a> in the <i>Amazon VPC IPAM User Guide</i>.
 *       </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateIpamCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateIpamCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateIpamCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateIpamCommandInput} for command's `input` shape.
 * @see {@link CreateIpamCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateIpamCommand extends $Command<CreateIpamCommandInput, CreateIpamCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateIpamCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateIpamCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateIpamCommandInput, CreateIpamCommandOutput>;
    private serialize;
    private deserialize;
}
