import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateCoipPoolRequest, CreateCoipPoolResult } from "../models/models_1";
export interface CreateCoipPoolCommandInput extends CreateCoipPoolRequest {
}
export interface CreateCoipPoolCommandOutput extends CreateCoipPoolResult, __MetadataBearer {
}
/**
 * <p> Creates a pool of customer-owned IP (CoIP) addresses. </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateCoipPoolCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateCoipPoolCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateCoipPoolCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateCoipPoolCommandInput} for command's `input` shape.
 * @see {@link CreateCoipPoolCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateCoipPoolCommand extends $Command<CreateCoipPoolCommandInput, CreateCoipPoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateCoipPoolCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CreateCoipPoolCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateCoipPoolCommandInput, CreateCoipPoolCommandOutput>;
    private serialize;
    private deserialize;
}
