import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CancelImageLaunchPermissionRequest, CancelImageLaunchPermissionResult } from "../models/models_0";
export interface CancelImageLaunchPermissionCommandInput extends CancelImageLaunchPermissionRequest {
}
export interface CancelImageLaunchPermissionCommandOutput extends CancelImageLaunchPermissionResult, __MetadataBearer {
}
/**
 * <p>Removes your Amazon Web Services account from the launch permissions for the specified AMI. For more
 *       information, see <a href="https://docs.aws.amazon.com/">Cancel having an AMI shared with your Amazon Web Services account</a>
 *       in the <i>Amazon EC2 User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CancelImageLaunchPermissionCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CancelImageLaunchPermissionCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CancelImageLaunchPermissionCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CancelImageLaunchPermissionCommandInput} for command's `input` shape.
 * @see {@link CancelImageLaunchPermissionCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CancelImageLaunchPermissionCommand extends $Command<CancelImageLaunchPermissionCommandInput, CancelImageLaunchPermissionCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CancelImageLaunchPermissionCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: CancelImageLaunchPermissionCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CancelImageLaunchPermissionCommandInput, CancelImageLaunchPermissionCommandOutput>;
    private serialize;
    private deserialize;
}
