import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AcceptAddressTransferRequest, AcceptAddressTransferResult } from "../models/models_0";
export interface AcceptAddressTransferCommandInput extends AcceptAddressTransferRequest {
}
export interface AcceptAddressTransferCommandOutput extends AcceptAddressTransferResult, __MetadataBearer {
}
/**
 * <p>Accepts an Elastic IP address transfer. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-eips.html#using-instance-addressing-eips-transfer-accept">Accept a transferred Elastic IP address</a> in the <i>Amazon Virtual Private Cloud User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, AcceptAddressTransferCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, AcceptAddressTransferCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new AcceptAddressTransferCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link AcceptAddressTransferCommandInput} for command's `input` shape.
 * @see {@link AcceptAddressTransferCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class AcceptAddressTransferCommand extends $Command<AcceptAddressTransferCommandInput, AcceptAddressTransferCommandOutput, EC2ClientResolvedConfig> {
    readonly input: AcceptAddressTransferCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: AcceptAddressTransferCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AcceptAddressTransferCommandInput, AcceptAddressTransferCommandOutput>;
    private serialize;
    private deserialize;
}
