import { HttpRequest as __HttpRequest } from "@aws-sdk/protocol-http";
import { expectNonNull as __expectNonNull, expectString as __expectString, extendedEncodeURIComponent as __extendedEncodeURIComponent, getArrayIfSingleItem as __getArrayIfSingleItem, getValueFromTextNode as __getValueFromTextNode, parseBoolean as __parseBoolean, parseRfc3339DateTime as __parseRfc3339DateTime, serializeFloat as __serializeFloat, strictParseFloat as __strictParseFloat, strictParseInt32 as __strictParseInt32, strictParseLong as __strictParseLong, throwDefaultError, } from "@aws-sdk/smithy-client";
import { XMLParser } from "fast-xml-parser";
import { v4 as generateIdempotencyToken } from "uuid";
import { EC2ServiceException as __BaseException } from "../models/EC2ServiceException";
export const serializeAws_ec2AcceptAddressTransferCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AcceptAddressTransferRequest(input, context),
        Action: "AcceptAddressTransfer",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AcceptReservedInstancesExchangeQuoteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AcceptReservedInstancesExchangeQuoteRequest(input, context),
        Action: "AcceptReservedInstancesExchangeQuote",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsRequest(input, context),
        Action: "AcceptTransitGatewayMulticastDomainAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AcceptTransitGatewayPeeringAttachmentRequest(input, context),
        Action: "AcceptTransitGatewayPeeringAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AcceptTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AcceptTransitGatewayVpcAttachmentRequest(input, context),
        Action: "AcceptTransitGatewayVpcAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AcceptVpcEndpointConnectionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AcceptVpcEndpointConnectionsRequest(input, context),
        Action: "AcceptVpcEndpointConnections",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AcceptVpcPeeringConnectionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AcceptVpcPeeringConnectionRequest(input, context),
        Action: "AcceptVpcPeeringConnection",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AdvertiseByoipCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AdvertiseByoipCidrRequest(input, context),
        Action: "AdvertiseByoipCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AllocateAddressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AllocateAddressRequest(input, context),
        Action: "AllocateAddress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AllocateHostsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AllocateHostsRequest(input, context),
        Action: "AllocateHosts",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AllocateIpamPoolCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AllocateIpamPoolCidrRequest(input, context),
        Action: "AllocateIpamPoolCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkRequest(input, context),
        Action: "ApplySecurityGroupsToClientVpnTargetNetwork",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssignIpv6AddressesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssignIpv6AddressesRequest(input, context),
        Action: "AssignIpv6Addresses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssignPrivateIpAddressesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssignPrivateIpAddressesRequest(input, context),
        Action: "AssignPrivateIpAddresses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateAddressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateAddressRequest(input, context),
        Action: "AssociateAddress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateClientVpnTargetNetworkCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateClientVpnTargetNetworkRequest(input, context),
        Action: "AssociateClientVpnTargetNetwork",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateDhcpOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateDhcpOptionsRequest(input, context),
        Action: "AssociateDhcpOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateEnclaveCertificateIamRoleCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateEnclaveCertificateIamRoleRequest(input, context),
        Action: "AssociateEnclaveCertificateIamRole",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateIamInstanceProfileCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateIamInstanceProfileRequest(input, context),
        Action: "AssociateIamInstanceProfile",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateInstanceEventWindowCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateInstanceEventWindowRequest(input, context),
        Action: "AssociateInstanceEventWindow",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateRouteTableRequest(input, context),
        Action: "AssociateRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateSubnetCidrBlockCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateSubnetCidrBlockRequest(input, context),
        Action: "AssociateSubnetCidrBlock",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateTransitGatewayMulticastDomainRequest(input, context),
        Action: "AssociateTransitGatewayMulticastDomain",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateTransitGatewayPolicyTableRequest(input, context),
        Action: "AssociateTransitGatewayPolicyTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateTransitGatewayRouteTableRequest(input, context),
        Action: "AssociateTransitGatewayRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateTrunkInterfaceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateTrunkInterfaceRequest(input, context),
        Action: "AssociateTrunkInterface",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AssociateVpcCidrBlockCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AssociateVpcCidrBlockRequest(input, context),
        Action: "AssociateVpcCidrBlock",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AttachClassicLinkVpcCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AttachClassicLinkVpcRequest(input, context),
        Action: "AttachClassicLinkVpc",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AttachInternetGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AttachInternetGatewayRequest(input, context),
        Action: "AttachInternetGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AttachNetworkInterfaceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AttachNetworkInterfaceRequest(input, context),
        Action: "AttachNetworkInterface",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AttachVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AttachVerifiedAccessTrustProviderRequest(input, context),
        Action: "AttachVerifiedAccessTrustProvider",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AttachVolumeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AttachVolumeRequest(input, context),
        Action: "AttachVolume",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AttachVpnGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AttachVpnGatewayRequest(input, context),
        Action: "AttachVpnGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AuthorizeClientVpnIngressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AuthorizeClientVpnIngressRequest(input, context),
        Action: "AuthorizeClientVpnIngress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AuthorizeSecurityGroupEgressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AuthorizeSecurityGroupEgressRequest(input, context),
        Action: "AuthorizeSecurityGroupEgress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2AuthorizeSecurityGroupIngressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2AuthorizeSecurityGroupIngressRequest(input, context),
        Action: "AuthorizeSecurityGroupIngress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2BundleInstanceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2BundleInstanceRequest(input, context),
        Action: "BundleInstance",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelBundleTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelBundleTaskRequest(input, context),
        Action: "CancelBundleTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelCapacityReservationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelCapacityReservationRequest(input, context),
        Action: "CancelCapacityReservation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelCapacityReservationFleetsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelCapacityReservationFleetsRequest(input, context),
        Action: "CancelCapacityReservationFleets",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelConversionTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelConversionRequest(input, context),
        Action: "CancelConversionTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelExportTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelExportTaskRequest(input, context),
        Action: "CancelExportTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelImageLaunchPermissionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelImageLaunchPermissionRequest(input, context),
        Action: "CancelImageLaunchPermission",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelImportTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelImportTaskRequest(input, context),
        Action: "CancelImportTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelReservedInstancesListingCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelReservedInstancesListingRequest(input, context),
        Action: "CancelReservedInstancesListing",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelSpotFleetRequestsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelSpotFleetRequestsRequest(input, context),
        Action: "CancelSpotFleetRequests",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CancelSpotInstanceRequestsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CancelSpotInstanceRequestsRequest(input, context),
        Action: "CancelSpotInstanceRequests",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ConfirmProductInstanceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ConfirmProductInstanceRequest(input, context),
        Action: "ConfirmProductInstance",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CopyFpgaImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CopyFpgaImageRequest(input, context),
        Action: "CopyFpgaImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CopyImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CopyImageRequest(input, context),
        Action: "CopyImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CopySnapshotCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CopySnapshotRequest(input, context),
        Action: "CopySnapshot",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateCapacityReservationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateCapacityReservationRequest(input, context),
        Action: "CreateCapacityReservation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateCapacityReservationFleetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateCapacityReservationFleetRequest(input, context),
        Action: "CreateCapacityReservationFleet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateCarrierGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateCarrierGatewayRequest(input, context),
        Action: "CreateCarrierGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateClientVpnEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateClientVpnEndpointRequest(input, context),
        Action: "CreateClientVpnEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateClientVpnRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateClientVpnRouteRequest(input, context),
        Action: "CreateClientVpnRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateCoipCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateCoipCidrRequest(input, context),
        Action: "CreateCoipCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateCoipPoolCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateCoipPoolRequest(input, context),
        Action: "CreateCoipPool",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateCustomerGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateCustomerGatewayRequest(input, context),
        Action: "CreateCustomerGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateDefaultSubnetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateDefaultSubnetRequest(input, context),
        Action: "CreateDefaultSubnet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateDefaultVpcCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateDefaultVpcRequest(input, context),
        Action: "CreateDefaultVpc",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateDhcpOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateDhcpOptionsRequest(input, context),
        Action: "CreateDhcpOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateEgressOnlyInternetGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateEgressOnlyInternetGatewayRequest(input, context),
        Action: "CreateEgressOnlyInternetGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateFleetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateFleetRequest(input, context),
        Action: "CreateFleet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateFlowLogsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateFlowLogsRequest(input, context),
        Action: "CreateFlowLogs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateFpgaImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateFpgaImageRequest(input, context),
        Action: "CreateFpgaImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateImageRequest(input, context),
        Action: "CreateImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateInstanceEventWindowCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateInstanceEventWindowRequest(input, context),
        Action: "CreateInstanceEventWindow",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateInstanceExportTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateInstanceExportTaskRequest(input, context),
        Action: "CreateInstanceExportTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateInternetGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateInternetGatewayRequest(input, context),
        Action: "CreateInternetGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateIpamCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateIpamRequest(input, context),
        Action: "CreateIpam",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateIpamPoolCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateIpamPoolRequest(input, context),
        Action: "CreateIpamPool",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateIpamScopeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateIpamScopeRequest(input, context),
        Action: "CreateIpamScope",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateKeyPairCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateKeyPairRequest(input, context),
        Action: "CreateKeyPair",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateLaunchTemplateCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateLaunchTemplateRequest(input, context),
        Action: "CreateLaunchTemplate",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateLaunchTemplateVersionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateLaunchTemplateVersionRequest(input, context),
        Action: "CreateLaunchTemplateVersion",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateLocalGatewayRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateLocalGatewayRouteRequest(input, context),
        Action: "CreateLocalGatewayRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateLocalGatewayRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateLocalGatewayRouteTableRequest(input, context),
        Action: "CreateLocalGatewayRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input, context),
        Action: "CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationRequest(input, context),
        Action: "CreateLocalGatewayRouteTableVpcAssociation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateManagedPrefixListCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateManagedPrefixListRequest(input, context),
        Action: "CreateManagedPrefixList",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateNatGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateNatGatewayRequest(input, context),
        Action: "CreateNatGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateNetworkAclCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateNetworkAclRequest(input, context),
        Action: "CreateNetworkAcl",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateNetworkAclEntryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateNetworkAclEntryRequest(input, context),
        Action: "CreateNetworkAclEntry",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateNetworkInsightsAccessScopeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateNetworkInsightsAccessScopeRequest(input, context),
        Action: "CreateNetworkInsightsAccessScope",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateNetworkInsightsPathCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateNetworkInsightsPathRequest(input, context),
        Action: "CreateNetworkInsightsPath",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateNetworkInterfaceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateNetworkInterfaceRequest(input, context),
        Action: "CreateNetworkInterface",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateNetworkInterfacePermissionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateNetworkInterfacePermissionRequest(input, context),
        Action: "CreateNetworkInterfacePermission",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreatePlacementGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreatePlacementGroupRequest(input, context),
        Action: "CreatePlacementGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreatePublicIpv4PoolCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreatePublicIpv4PoolRequest(input, context),
        Action: "CreatePublicIpv4Pool",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateReplaceRootVolumeTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateReplaceRootVolumeTaskRequest(input, context),
        Action: "CreateReplaceRootVolumeTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateReservedInstancesListingCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateReservedInstancesListingRequest(input, context),
        Action: "CreateReservedInstancesListing",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateRestoreImageTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateRestoreImageTaskRequest(input, context),
        Action: "CreateRestoreImageTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateRouteRequest(input, context),
        Action: "CreateRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateRouteTableRequest(input, context),
        Action: "CreateRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateSecurityGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateSecurityGroupRequest(input, context),
        Action: "CreateSecurityGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateSnapshotCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateSnapshotRequest(input, context),
        Action: "CreateSnapshot",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateSnapshotsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateSnapshotsRequest(input, context),
        Action: "CreateSnapshots",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateSpotDatafeedSubscriptionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateSpotDatafeedSubscriptionRequest(input, context),
        Action: "CreateSpotDatafeedSubscription",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateStoreImageTaskCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateStoreImageTaskRequest(input, context),
        Action: "CreateStoreImageTask",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateSubnetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateSubnetRequest(input, context),
        Action: "CreateSubnet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateSubnetCidrReservationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateSubnetCidrReservationRequest(input, context),
        Action: "CreateSubnetCidrReservation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTagsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTagsRequest(input, context),
        Action: "CreateTags",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTrafficMirrorFilterCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTrafficMirrorFilterRequest(input, context),
        Action: "CreateTrafficMirrorFilter",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTrafficMirrorFilterRuleCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTrafficMirrorFilterRuleRequest(input, context),
        Action: "CreateTrafficMirrorFilterRule",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTrafficMirrorSessionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTrafficMirrorSessionRequest(input, context),
        Action: "CreateTrafficMirrorSession",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTrafficMirrorTargetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTrafficMirrorTargetRequest(input, context),
        Action: "CreateTrafficMirrorTarget",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayRequest(input, context),
        Action: "CreateTransitGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayConnectCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayConnectRequest(input, context),
        Action: "CreateTransitGatewayConnect",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayConnectPeerCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayConnectPeerRequest(input, context),
        Action: "CreateTransitGatewayConnectPeer",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayMulticastDomainRequest(input, context),
        Action: "CreateTransitGatewayMulticastDomain",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayPeeringAttachmentRequest(input, context),
        Action: "CreateTransitGatewayPeeringAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayPolicyTableRequest(input, context),
        Action: "CreateTransitGatewayPolicyTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayPrefixListReferenceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayPrefixListReferenceRequest(input, context),
        Action: "CreateTransitGatewayPrefixListReference",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayRouteRequest(input, context),
        Action: "CreateTransitGatewayRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayRouteTableRequest(input, context),
        Action: "CreateTransitGatewayRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayRouteTableAnnouncementCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayRouteTableAnnouncementRequest(input, context),
        Action: "CreateTransitGatewayRouteTableAnnouncement",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateTransitGatewayVpcAttachmentRequest(input, context),
        Action: "CreateTransitGatewayVpcAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVerifiedAccessEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVerifiedAccessEndpointRequest(input, context),
        Action: "CreateVerifiedAccessEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVerifiedAccessGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVerifiedAccessGroupRequest(input, context),
        Action: "CreateVerifiedAccessGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVerifiedAccessInstanceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVerifiedAccessInstanceRequest(input, context),
        Action: "CreateVerifiedAccessInstance",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVerifiedAccessTrustProviderRequest(input, context),
        Action: "CreateVerifiedAccessTrustProvider",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVolumeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVolumeRequest(input, context),
        Action: "CreateVolume",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpcCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpcRequest(input, context),
        Action: "CreateVpc",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpcEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpcEndpointRequest(input, context),
        Action: "CreateVpcEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpcEndpointConnectionNotificationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpcEndpointConnectionNotificationRequest(input, context),
        Action: "CreateVpcEndpointConnectionNotification",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpcEndpointServiceConfigurationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpcEndpointServiceConfigurationRequest(input, context),
        Action: "CreateVpcEndpointServiceConfiguration",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpcPeeringConnectionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpcPeeringConnectionRequest(input, context),
        Action: "CreateVpcPeeringConnection",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpnConnectionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpnConnectionRequest(input, context),
        Action: "CreateVpnConnection",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpnConnectionRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpnConnectionRouteRequest(input, context),
        Action: "CreateVpnConnectionRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2CreateVpnGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2CreateVpnGatewayRequest(input, context),
        Action: "CreateVpnGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteCarrierGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteCarrierGatewayRequest(input, context),
        Action: "DeleteCarrierGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteClientVpnEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteClientVpnEndpointRequest(input, context),
        Action: "DeleteClientVpnEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteClientVpnRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteClientVpnRouteRequest(input, context),
        Action: "DeleteClientVpnRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteCoipCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteCoipCidrRequest(input, context),
        Action: "DeleteCoipCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteCoipPoolCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteCoipPoolRequest(input, context),
        Action: "DeleteCoipPool",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteCustomerGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteCustomerGatewayRequest(input, context),
        Action: "DeleteCustomerGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteDhcpOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteDhcpOptionsRequest(input, context),
        Action: "DeleteDhcpOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteEgressOnlyInternetGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteEgressOnlyInternetGatewayRequest(input, context),
        Action: "DeleteEgressOnlyInternetGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteFleetsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteFleetsRequest(input, context),
        Action: "DeleteFleets",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteFlowLogsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteFlowLogsRequest(input, context),
        Action: "DeleteFlowLogs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteFpgaImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteFpgaImageRequest(input, context),
        Action: "DeleteFpgaImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteInstanceEventWindowCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteInstanceEventWindowRequest(input, context),
        Action: "DeleteInstanceEventWindow",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteInternetGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteInternetGatewayRequest(input, context),
        Action: "DeleteInternetGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteIpamCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteIpamRequest(input, context),
        Action: "DeleteIpam",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteIpamPoolCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteIpamPoolRequest(input, context),
        Action: "DeleteIpamPool",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteIpamScopeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteIpamScopeRequest(input, context),
        Action: "DeleteIpamScope",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteKeyPairCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteKeyPairRequest(input, context),
        Action: "DeleteKeyPair",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteLaunchTemplateCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteLaunchTemplateRequest(input, context),
        Action: "DeleteLaunchTemplate",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteLaunchTemplateVersionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteLaunchTemplateVersionsRequest(input, context),
        Action: "DeleteLaunchTemplateVersions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteLocalGatewayRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteLocalGatewayRouteRequest(input, context),
        Action: "DeleteLocalGatewayRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteLocalGatewayRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteLocalGatewayRouteTableRequest(input, context),
        Action: "DeleteLocalGatewayRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(input, context),
        Action: "DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteLocalGatewayRouteTableVpcAssociationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteLocalGatewayRouteTableVpcAssociationRequest(input, context),
        Action: "DeleteLocalGatewayRouteTableVpcAssociation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteManagedPrefixListCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteManagedPrefixListRequest(input, context),
        Action: "DeleteManagedPrefixList",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNatGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNatGatewayRequest(input, context),
        Action: "DeleteNatGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkAclCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkAclRequest(input, context),
        Action: "DeleteNetworkAcl",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkAclEntryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkAclEntryRequest(input, context),
        Action: "DeleteNetworkAclEntry",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkInsightsAccessScopeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkInsightsAccessScopeRequest(input, context),
        Action: "DeleteNetworkInsightsAccessScope",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisRequest(input, context),
        Action: "DeleteNetworkInsightsAccessScopeAnalysis",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkInsightsAnalysisCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkInsightsAnalysisRequest(input, context),
        Action: "DeleteNetworkInsightsAnalysis",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkInsightsPathCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkInsightsPathRequest(input, context),
        Action: "DeleteNetworkInsightsPath",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkInterfaceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkInterfaceRequest(input, context),
        Action: "DeleteNetworkInterface",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteNetworkInterfacePermissionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteNetworkInterfacePermissionRequest(input, context),
        Action: "DeleteNetworkInterfacePermission",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeletePlacementGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeletePlacementGroupRequest(input, context),
        Action: "DeletePlacementGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeletePublicIpv4PoolCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeletePublicIpv4PoolRequest(input, context),
        Action: "DeletePublicIpv4Pool",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteQueuedReservedInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteQueuedReservedInstancesRequest(input, context),
        Action: "DeleteQueuedReservedInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteRouteRequest(input, context),
        Action: "DeleteRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteRouteTableRequest(input, context),
        Action: "DeleteRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteSecurityGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteSecurityGroupRequest(input, context),
        Action: "DeleteSecurityGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteSnapshotCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteSnapshotRequest(input, context),
        Action: "DeleteSnapshot",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteSpotDatafeedSubscriptionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteSpotDatafeedSubscriptionRequest(input, context),
        Action: "DeleteSpotDatafeedSubscription",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteSubnetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteSubnetRequest(input, context),
        Action: "DeleteSubnet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteSubnetCidrReservationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteSubnetCidrReservationRequest(input, context),
        Action: "DeleteSubnetCidrReservation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTagsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTagsRequest(input, context),
        Action: "DeleteTags",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTrafficMirrorFilterCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTrafficMirrorFilterRequest(input, context),
        Action: "DeleteTrafficMirrorFilter",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTrafficMirrorFilterRuleCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTrafficMirrorFilterRuleRequest(input, context),
        Action: "DeleteTrafficMirrorFilterRule",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTrafficMirrorSessionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTrafficMirrorSessionRequest(input, context),
        Action: "DeleteTrafficMirrorSession",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTrafficMirrorTargetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTrafficMirrorTargetRequest(input, context),
        Action: "DeleteTrafficMirrorTarget",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayRequest(input, context),
        Action: "DeleteTransitGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayConnectCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayConnectRequest(input, context),
        Action: "DeleteTransitGatewayConnect",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayConnectPeerCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayConnectPeerRequest(input, context),
        Action: "DeleteTransitGatewayConnectPeer",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayMulticastDomainRequest(input, context),
        Action: "DeleteTransitGatewayMulticastDomain",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayPeeringAttachmentRequest(input, context),
        Action: "DeleteTransitGatewayPeeringAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayPolicyTableRequest(input, context),
        Action: "DeleteTransitGatewayPolicyTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayPrefixListReferenceRequest(input, context),
        Action: "DeleteTransitGatewayPrefixListReference",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayRouteRequest(input, context),
        Action: "DeleteTransitGatewayRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayRouteTableRequest(input, context),
        Action: "DeleteTransitGatewayRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayRouteTableAnnouncementCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayRouteTableAnnouncementRequest(input, context),
        Action: "DeleteTransitGatewayRouteTableAnnouncement",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteTransitGatewayVpcAttachmentRequest(input, context),
        Action: "DeleteTransitGatewayVpcAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVerifiedAccessEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVerifiedAccessEndpointRequest(input, context),
        Action: "DeleteVerifiedAccessEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVerifiedAccessGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVerifiedAccessGroupRequest(input, context),
        Action: "DeleteVerifiedAccessGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVerifiedAccessInstanceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVerifiedAccessInstanceRequest(input, context),
        Action: "DeleteVerifiedAccessInstance",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVerifiedAccessTrustProviderRequest(input, context),
        Action: "DeleteVerifiedAccessTrustProvider",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVolumeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVolumeRequest(input, context),
        Action: "DeleteVolume",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpcCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpcRequest(input, context),
        Action: "DeleteVpc",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpcEndpointConnectionNotificationsRequest(input, context),
        Action: "DeleteVpcEndpointConnectionNotifications",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpcEndpointsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpcEndpointsRequest(input, context),
        Action: "DeleteVpcEndpoints",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpcEndpointServiceConfigurationsRequest(input, context),
        Action: "DeleteVpcEndpointServiceConfigurations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpcPeeringConnectionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpcPeeringConnectionRequest(input, context),
        Action: "DeleteVpcPeeringConnection",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpnConnectionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpnConnectionRequest(input, context),
        Action: "DeleteVpnConnection",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpnConnectionRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpnConnectionRouteRequest(input, context),
        Action: "DeleteVpnConnectionRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeleteVpnGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeleteVpnGatewayRequest(input, context),
        Action: "DeleteVpnGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeprovisionByoipCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeprovisionByoipCidrRequest(input, context),
        Action: "DeprovisionByoipCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeprovisionIpamPoolCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeprovisionIpamPoolCidrRequest(input, context),
        Action: "DeprovisionIpamPoolCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeprovisionPublicIpv4PoolCidrRequest(input, context),
        Action: "DeprovisionPublicIpv4PoolCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeregisterImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeregisterImageRequest(input, context),
        Action: "DeregisterImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeregisterInstanceEventNotificationAttributesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeregisterInstanceEventNotificationAttributesRequest(input, context),
        Action: "DeregisterInstanceEventNotificationAttributes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersRequest(input, context),
        Action: "DeregisterTransitGatewayMulticastGroupMembers",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesRequest(input, context),
        Action: "DeregisterTransitGatewayMulticastGroupSources",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeAccountAttributesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeAccountAttributesRequest(input, context),
        Action: "DescribeAccountAttributes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeAddressesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeAddressesRequest(input, context),
        Action: "DescribeAddresses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeAddressesAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeAddressesAttributeRequest(input, context),
        Action: "DescribeAddressesAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeAddressTransfersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeAddressTransfersRequest(input, context),
        Action: "DescribeAddressTransfers",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeAggregateIdFormatCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeAggregateIdFormatRequest(input, context),
        Action: "DescribeAggregateIdFormat",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeAvailabilityZonesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeAvailabilityZonesRequest(input, context),
        Action: "DescribeAvailabilityZones",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeAwsNetworkPerformanceMetricSubscriptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeAwsNetworkPerformanceMetricSubscriptionsRequest(input, context),
        Action: "DescribeAwsNetworkPerformanceMetricSubscriptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeBundleTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeBundleTasksRequest(input, context),
        Action: "DescribeBundleTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeByoipCidrsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeByoipCidrsRequest(input, context),
        Action: "DescribeByoipCidrs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeCapacityReservationFleetsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeCapacityReservationFleetsRequest(input, context),
        Action: "DescribeCapacityReservationFleets",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeCapacityReservationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeCapacityReservationsRequest(input, context),
        Action: "DescribeCapacityReservations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeCarrierGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeCarrierGatewaysRequest(input, context),
        Action: "DescribeCarrierGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeClassicLinkInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeClassicLinkInstancesRequest(input, context),
        Action: "DescribeClassicLinkInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeClientVpnAuthorizationRulesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeClientVpnAuthorizationRulesRequest(input, context),
        Action: "DescribeClientVpnAuthorizationRules",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeClientVpnConnectionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeClientVpnConnectionsRequest(input, context),
        Action: "DescribeClientVpnConnections",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeClientVpnEndpointsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeClientVpnEndpointsRequest(input, context),
        Action: "DescribeClientVpnEndpoints",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeClientVpnRoutesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeClientVpnRoutesRequest(input, context),
        Action: "DescribeClientVpnRoutes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeClientVpnTargetNetworksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeClientVpnTargetNetworksRequest(input, context),
        Action: "DescribeClientVpnTargetNetworks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeCoipPoolsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeCoipPoolsRequest(input, context),
        Action: "DescribeCoipPools",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeConversionTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeConversionTasksRequest(input, context),
        Action: "DescribeConversionTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeCustomerGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeCustomerGatewaysRequest(input, context),
        Action: "DescribeCustomerGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeDhcpOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeDhcpOptionsRequest(input, context),
        Action: "DescribeDhcpOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeEgressOnlyInternetGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeEgressOnlyInternetGatewaysRequest(input, context),
        Action: "DescribeEgressOnlyInternetGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeElasticGpusCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeElasticGpusRequest(input, context),
        Action: "DescribeElasticGpus",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeExportImageTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeExportImageTasksRequest(input, context),
        Action: "DescribeExportImageTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeExportTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeExportTasksRequest(input, context),
        Action: "DescribeExportTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFastLaunchImagesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFastLaunchImagesRequest(input, context),
        Action: "DescribeFastLaunchImages",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFastSnapshotRestoresCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFastSnapshotRestoresRequest(input, context),
        Action: "DescribeFastSnapshotRestores",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFleetHistoryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFleetHistoryRequest(input, context),
        Action: "DescribeFleetHistory",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFleetInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFleetInstancesRequest(input, context),
        Action: "DescribeFleetInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFleetsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFleetsRequest(input, context),
        Action: "DescribeFleets",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFlowLogsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFlowLogsRequest(input, context),
        Action: "DescribeFlowLogs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFpgaImageAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFpgaImageAttributeRequest(input, context),
        Action: "DescribeFpgaImageAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeFpgaImagesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeFpgaImagesRequest(input, context),
        Action: "DescribeFpgaImages",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeHostReservationOfferingsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeHostReservationOfferingsRequest(input, context),
        Action: "DescribeHostReservationOfferings",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeHostReservationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeHostReservationsRequest(input, context),
        Action: "DescribeHostReservations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeHostsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeHostsRequest(input, context),
        Action: "DescribeHosts",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeIamInstanceProfileAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeIamInstanceProfileAssociationsRequest(input, context),
        Action: "DescribeIamInstanceProfileAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeIdentityIdFormatCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeIdentityIdFormatRequest(input, context),
        Action: "DescribeIdentityIdFormat",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeIdFormatCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeIdFormatRequest(input, context),
        Action: "DescribeIdFormat",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeImageAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeImageAttributeRequest(input, context),
        Action: "DescribeImageAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeImagesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeImagesRequest(input, context),
        Action: "DescribeImages",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeImportImageTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeImportImageTasksRequest(input, context),
        Action: "DescribeImportImageTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeImportSnapshotTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeImportSnapshotTasksRequest(input, context),
        Action: "DescribeImportSnapshotTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstanceAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstanceAttributeRequest(input, context),
        Action: "DescribeInstanceAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstanceCreditSpecificationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstanceCreditSpecificationsRequest(input, context),
        Action: "DescribeInstanceCreditSpecifications",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstanceEventNotificationAttributesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstanceEventNotificationAttributesRequest(input, context),
        Action: "DescribeInstanceEventNotificationAttributes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstanceEventWindowsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstanceEventWindowsRequest(input, context),
        Action: "DescribeInstanceEventWindows",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstancesRequest(input, context),
        Action: "DescribeInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstanceStatusCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstanceStatusRequest(input, context),
        Action: "DescribeInstanceStatus",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstanceTypeOfferingsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstanceTypeOfferingsRequest(input, context),
        Action: "DescribeInstanceTypeOfferings",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInstanceTypesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInstanceTypesRequest(input, context),
        Action: "DescribeInstanceTypes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeInternetGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeInternetGatewaysRequest(input, context),
        Action: "DescribeInternetGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeIpamPoolsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeIpamPoolsRequest(input, context),
        Action: "DescribeIpamPools",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeIpamsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeIpamsRequest(input, context),
        Action: "DescribeIpams",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeIpamScopesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeIpamScopesRequest(input, context),
        Action: "DescribeIpamScopes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeIpv6PoolsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeIpv6PoolsRequest(input, context),
        Action: "DescribeIpv6Pools",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeKeyPairsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeKeyPairsRequest(input, context),
        Action: "DescribeKeyPairs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLaunchTemplatesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLaunchTemplatesRequest(input, context),
        Action: "DescribeLaunchTemplates",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLaunchTemplateVersionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLaunchTemplateVersionsRequest(input, context),
        Action: "DescribeLaunchTemplateVersions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLocalGatewayRouteTablesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLocalGatewayRouteTablesRequest(input, context),
        Action: "DescribeLocalGatewayRouteTables",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest(input, context),
        Action: "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsRequest(input, context),
        Action: "DescribeLocalGatewayRouteTableVpcAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLocalGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLocalGatewaysRequest(input, context),
        Action: "DescribeLocalGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsRequest(input, context),
        Action: "DescribeLocalGatewayVirtualInterfaceGroups",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeLocalGatewayVirtualInterfacesRequest(input, context),
        Action: "DescribeLocalGatewayVirtualInterfaces",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeManagedPrefixListsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeManagedPrefixListsRequest(input, context),
        Action: "DescribeManagedPrefixLists",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeMovingAddressesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeMovingAddressesRequest(input, context),
        Action: "DescribeMovingAddresses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNatGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNatGatewaysRequest(input, context),
        Action: "DescribeNatGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkAclsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkAclsRequest(input, context),
        Action: "DescribeNetworkAcls",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesRequest(input, context),
        Action: "DescribeNetworkInsightsAccessScopeAnalyses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkInsightsAccessScopesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkInsightsAccessScopesRequest(input, context),
        Action: "DescribeNetworkInsightsAccessScopes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkInsightsAnalysesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkInsightsAnalysesRequest(input, context),
        Action: "DescribeNetworkInsightsAnalyses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkInsightsPathsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkInsightsPathsRequest(input, context),
        Action: "DescribeNetworkInsightsPaths",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkInterfaceAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkInterfaceAttributeRequest(input, context),
        Action: "DescribeNetworkInterfaceAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkInterfacePermissionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkInterfacePermissionsRequest(input, context),
        Action: "DescribeNetworkInterfacePermissions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeNetworkInterfacesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeNetworkInterfacesRequest(input, context),
        Action: "DescribeNetworkInterfaces",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribePlacementGroupsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribePlacementGroupsRequest(input, context),
        Action: "DescribePlacementGroups",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribePrefixListsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribePrefixListsRequest(input, context),
        Action: "DescribePrefixLists",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribePrincipalIdFormatCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribePrincipalIdFormatRequest(input, context),
        Action: "DescribePrincipalIdFormat",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribePublicIpv4PoolsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribePublicIpv4PoolsRequest(input, context),
        Action: "DescribePublicIpv4Pools",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeRegionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeRegionsRequest(input, context),
        Action: "DescribeRegions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeReplaceRootVolumeTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeReplaceRootVolumeTasksRequest(input, context),
        Action: "DescribeReplaceRootVolumeTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeReservedInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeReservedInstancesRequest(input, context),
        Action: "DescribeReservedInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeReservedInstancesListingsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeReservedInstancesListingsRequest(input, context),
        Action: "DescribeReservedInstancesListings",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeReservedInstancesModificationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeReservedInstancesModificationsRequest(input, context),
        Action: "DescribeReservedInstancesModifications",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeReservedInstancesOfferingsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeReservedInstancesOfferingsRequest(input, context),
        Action: "DescribeReservedInstancesOfferings",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeRouteTablesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeRouteTablesRequest(input, context),
        Action: "DescribeRouteTables",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeScheduledInstanceAvailabilityCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeScheduledInstanceAvailabilityRequest(input, context),
        Action: "DescribeScheduledInstanceAvailability",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeScheduledInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeScheduledInstancesRequest(input, context),
        Action: "DescribeScheduledInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSecurityGroupReferencesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSecurityGroupReferencesRequest(input, context),
        Action: "DescribeSecurityGroupReferences",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSecurityGroupRulesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSecurityGroupRulesRequest(input, context),
        Action: "DescribeSecurityGroupRules",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSecurityGroupsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSecurityGroupsRequest(input, context),
        Action: "DescribeSecurityGroups",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSnapshotAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSnapshotAttributeRequest(input, context),
        Action: "DescribeSnapshotAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSnapshotsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSnapshotsRequest(input, context),
        Action: "DescribeSnapshots",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSnapshotTierStatusCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSnapshotTierStatusRequest(input, context),
        Action: "DescribeSnapshotTierStatus",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSpotDatafeedSubscriptionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSpotDatafeedSubscriptionRequest(input, context),
        Action: "DescribeSpotDatafeedSubscription",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSpotFleetInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSpotFleetInstancesRequest(input, context),
        Action: "DescribeSpotFleetInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSpotFleetRequestHistoryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSpotFleetRequestHistoryRequest(input, context),
        Action: "DescribeSpotFleetRequestHistory",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSpotFleetRequestsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSpotFleetRequestsRequest(input, context),
        Action: "DescribeSpotFleetRequests",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSpotInstanceRequestsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSpotInstanceRequestsRequest(input, context),
        Action: "DescribeSpotInstanceRequests",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSpotPriceHistoryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSpotPriceHistoryRequest(input, context),
        Action: "DescribeSpotPriceHistory",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeStaleSecurityGroupsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeStaleSecurityGroupsRequest(input, context),
        Action: "DescribeStaleSecurityGroups",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeStoreImageTasksCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeStoreImageTasksRequest(input, context),
        Action: "DescribeStoreImageTasks",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeSubnetsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeSubnetsRequest(input, context),
        Action: "DescribeSubnets",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTagsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTagsRequest(input, context),
        Action: "DescribeTags",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTrafficMirrorFiltersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTrafficMirrorFiltersRequest(input, context),
        Action: "DescribeTrafficMirrorFilters",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTrafficMirrorSessionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTrafficMirrorSessionsRequest(input, context),
        Action: "DescribeTrafficMirrorSessions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTrafficMirrorTargetsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTrafficMirrorTargetsRequest(input, context),
        Action: "DescribeTrafficMirrorTargets",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayAttachmentsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayAttachmentsRequest(input, context),
        Action: "DescribeTransitGatewayAttachments",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayConnectPeersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayConnectPeersRequest(input, context),
        Action: "DescribeTransitGatewayConnectPeers",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayConnectsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayConnectsRequest(input, context),
        Action: "DescribeTransitGatewayConnects",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayMulticastDomainsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayMulticastDomainsRequest(input, context),
        Action: "DescribeTransitGatewayMulticastDomains",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayPeeringAttachmentsRequest(input, context),
        Action: "DescribeTransitGatewayPeeringAttachments",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayPolicyTablesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayPolicyTablesRequest(input, context),
        Action: "DescribeTransitGatewayPolicyTables",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayRouteTableAnnouncementsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayRouteTableAnnouncementsRequest(input, context),
        Action: "DescribeTransitGatewayRouteTableAnnouncements",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayRouteTablesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayRouteTablesRequest(input, context),
        Action: "DescribeTransitGatewayRouteTables",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewaysRequest(input, context),
        Action: "DescribeTransitGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTransitGatewayVpcAttachmentsRequest(input, context),
        Action: "DescribeTransitGatewayVpcAttachments",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeTrunkInterfaceAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeTrunkInterfaceAssociationsRequest(input, context),
        Action: "DescribeTrunkInterfaceAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVerifiedAccessEndpointsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVerifiedAccessEndpointsRequest(input, context),
        Action: "DescribeVerifiedAccessEndpoints",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVerifiedAccessGroupsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVerifiedAccessGroupsRequest(input, context),
        Action: "DescribeVerifiedAccessGroups",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVerifiedAccessInstanceLoggingConfigurationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVerifiedAccessInstanceLoggingConfigurationsRequest(input, context),
        Action: "DescribeVerifiedAccessInstanceLoggingConfigurations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVerifiedAccessInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVerifiedAccessInstancesRequest(input, context),
        Action: "DescribeVerifiedAccessInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVerifiedAccessTrustProvidersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVerifiedAccessTrustProvidersRequest(input, context),
        Action: "DescribeVerifiedAccessTrustProviders",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVolumeAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVolumeAttributeRequest(input, context),
        Action: "DescribeVolumeAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVolumesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVolumesRequest(input, context),
        Action: "DescribeVolumes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVolumesModificationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVolumesModificationsRequest(input, context),
        Action: "DescribeVolumesModifications",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVolumeStatusCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVolumeStatusRequest(input, context),
        Action: "DescribeVolumeStatus",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcAttributeRequest(input, context),
        Action: "DescribeVpcAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcClassicLinkCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcClassicLinkRequest(input, context),
        Action: "DescribeVpcClassicLink",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcClassicLinkDnsSupportCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcClassicLinkDnsSupportRequest(input, context),
        Action: "DescribeVpcClassicLinkDnsSupport",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcEndpointConnectionNotificationsRequest(input, context),
        Action: "DescribeVpcEndpointConnectionNotifications",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcEndpointConnectionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcEndpointConnectionsRequest(input, context),
        Action: "DescribeVpcEndpointConnections",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcEndpointsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcEndpointsRequest(input, context),
        Action: "DescribeVpcEndpoints",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcEndpointServiceConfigurationsRequest(input, context),
        Action: "DescribeVpcEndpointServiceConfigurations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcEndpointServicePermissionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcEndpointServicePermissionsRequest(input, context),
        Action: "DescribeVpcEndpointServicePermissions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcEndpointServicesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcEndpointServicesRequest(input, context),
        Action: "DescribeVpcEndpointServices",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcPeeringConnectionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcPeeringConnectionsRequest(input, context),
        Action: "DescribeVpcPeeringConnections",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpcsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpcsRequest(input, context),
        Action: "DescribeVpcs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpnConnectionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpnConnectionsRequest(input, context),
        Action: "DescribeVpnConnections",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DescribeVpnGatewaysCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DescribeVpnGatewaysRequest(input, context),
        Action: "DescribeVpnGateways",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DetachClassicLinkVpcCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DetachClassicLinkVpcRequest(input, context),
        Action: "DetachClassicLinkVpc",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DetachInternetGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DetachInternetGatewayRequest(input, context),
        Action: "DetachInternetGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DetachNetworkInterfaceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DetachNetworkInterfaceRequest(input, context),
        Action: "DetachNetworkInterface",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DetachVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DetachVerifiedAccessTrustProviderRequest(input, context),
        Action: "DetachVerifiedAccessTrustProvider",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DetachVolumeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DetachVolumeRequest(input, context),
        Action: "DetachVolume",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DetachVpnGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DetachVpnGatewayRequest(input, context),
        Action: "DetachVpnGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableAddressTransferCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableAddressTransferRequest(input, context),
        Action: "DisableAddressTransfer",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableAwsNetworkPerformanceMetricSubscriptionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableAwsNetworkPerformanceMetricSubscriptionRequest(input, context),
        Action: "DisableAwsNetworkPerformanceMetricSubscription",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableEbsEncryptionByDefaultCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableEbsEncryptionByDefaultRequest(input, context),
        Action: "DisableEbsEncryptionByDefault",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableFastLaunchCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableFastLaunchRequest(input, context),
        Action: "DisableFastLaunch",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableFastSnapshotRestoresCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableFastSnapshotRestoresRequest(input, context),
        Action: "DisableFastSnapshotRestores",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableImageDeprecationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableImageDeprecationRequest(input, context),
        Action: "DisableImageDeprecation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableIpamOrganizationAdminAccountCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableIpamOrganizationAdminAccountRequest(input, context),
        Action: "DisableIpamOrganizationAdminAccount",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableSerialConsoleAccessCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableSerialConsoleAccessRequest(input, context),
        Action: "DisableSerialConsoleAccess",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableTransitGatewayRouteTablePropagationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableTransitGatewayRouteTablePropagationRequest(input, context),
        Action: "DisableTransitGatewayRouteTablePropagation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableVgwRoutePropagationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableVgwRoutePropagationRequest(input, context),
        Action: "DisableVgwRoutePropagation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableVpcClassicLinkCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableVpcClassicLinkRequest(input, context),
        Action: "DisableVpcClassicLink",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisableVpcClassicLinkDnsSupportCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisableVpcClassicLinkDnsSupportRequest(input, context),
        Action: "DisableVpcClassicLinkDnsSupport",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateAddressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateAddressRequest(input, context),
        Action: "DisassociateAddress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateClientVpnTargetNetworkCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateClientVpnTargetNetworkRequest(input, context),
        Action: "DisassociateClientVpnTargetNetwork",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateEnclaveCertificateIamRoleCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateEnclaveCertificateIamRoleRequest(input, context),
        Action: "DisassociateEnclaveCertificateIamRole",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateIamInstanceProfileCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateIamInstanceProfileRequest(input, context),
        Action: "DisassociateIamInstanceProfile",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateInstanceEventWindowCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateInstanceEventWindowRequest(input, context),
        Action: "DisassociateInstanceEventWindow",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateRouteTableRequest(input, context),
        Action: "DisassociateRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateSubnetCidrBlockCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateSubnetCidrBlockRequest(input, context),
        Action: "DisassociateSubnetCidrBlock",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateTransitGatewayMulticastDomainCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateTransitGatewayMulticastDomainRequest(input, context),
        Action: "DisassociateTransitGatewayMulticastDomain",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateTransitGatewayPolicyTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateTransitGatewayPolicyTableRequest(input, context),
        Action: "DisassociateTransitGatewayPolicyTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateTransitGatewayRouteTableCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateTransitGatewayRouteTableRequest(input, context),
        Action: "DisassociateTransitGatewayRouteTable",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateTrunkInterfaceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateTrunkInterfaceRequest(input, context),
        Action: "DisassociateTrunkInterface",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2DisassociateVpcCidrBlockCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2DisassociateVpcCidrBlockRequest(input, context),
        Action: "DisassociateVpcCidrBlock",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableAddressTransferCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableAddressTransferRequest(input, context),
        Action: "EnableAddressTransfer",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableAwsNetworkPerformanceMetricSubscriptionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableAwsNetworkPerformanceMetricSubscriptionRequest(input, context),
        Action: "EnableAwsNetworkPerformanceMetricSubscription",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableEbsEncryptionByDefaultCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableEbsEncryptionByDefaultRequest(input, context),
        Action: "EnableEbsEncryptionByDefault",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableFastLaunchCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableFastLaunchRequest(input, context),
        Action: "EnableFastLaunch",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableFastSnapshotRestoresCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableFastSnapshotRestoresRequest(input, context),
        Action: "EnableFastSnapshotRestores",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableImageDeprecationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableImageDeprecationRequest(input, context),
        Action: "EnableImageDeprecation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableIpamOrganizationAdminAccountCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableIpamOrganizationAdminAccountRequest(input, context),
        Action: "EnableIpamOrganizationAdminAccount",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableReachabilityAnalyzerOrganizationSharingCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableReachabilityAnalyzerOrganizationSharingRequest(input, context),
        Action: "EnableReachabilityAnalyzerOrganizationSharing",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableSerialConsoleAccessCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableSerialConsoleAccessRequest(input, context),
        Action: "EnableSerialConsoleAccess",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableTransitGatewayRouteTablePropagationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableTransitGatewayRouteTablePropagationRequest(input, context),
        Action: "EnableTransitGatewayRouteTablePropagation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableVgwRoutePropagationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableVgwRoutePropagationRequest(input, context),
        Action: "EnableVgwRoutePropagation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableVolumeIOCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableVolumeIORequest(input, context),
        Action: "EnableVolumeIO",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableVpcClassicLinkCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableVpcClassicLinkRequest(input, context),
        Action: "EnableVpcClassicLink",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2EnableVpcClassicLinkDnsSupportCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2EnableVpcClassicLinkDnsSupportRequest(input, context),
        Action: "EnableVpcClassicLinkDnsSupport",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ExportClientVpnClientCertificateRevocationListCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ExportClientVpnClientCertificateRevocationListRequest(input, context),
        Action: "ExportClientVpnClientCertificateRevocationList",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ExportClientVpnClientConfigurationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ExportClientVpnClientConfigurationRequest(input, context),
        Action: "ExportClientVpnClientConfiguration",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ExportImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ExportImageRequest(input, context),
        Action: "ExportImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ExportTransitGatewayRoutesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ExportTransitGatewayRoutesRequest(input, context),
        Action: "ExportTransitGatewayRoutes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetAssociatedEnclaveCertificateIamRolesRequest(input, context),
        Action: "GetAssociatedEnclaveCertificateIamRoles",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetAssociatedIpv6PoolCidrsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetAssociatedIpv6PoolCidrsRequest(input, context),
        Action: "GetAssociatedIpv6PoolCidrs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetAwsNetworkPerformanceDataCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetAwsNetworkPerformanceDataRequest(input, context),
        Action: "GetAwsNetworkPerformanceData",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetCapacityReservationUsageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetCapacityReservationUsageRequest(input, context),
        Action: "GetCapacityReservationUsage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetCoipPoolUsageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetCoipPoolUsageRequest(input, context),
        Action: "GetCoipPoolUsage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetConsoleOutputCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetConsoleOutputRequest(input, context),
        Action: "GetConsoleOutput",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetConsoleScreenshotCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetConsoleScreenshotRequest(input, context),
        Action: "GetConsoleScreenshot",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetDefaultCreditSpecificationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetDefaultCreditSpecificationRequest(input, context),
        Action: "GetDefaultCreditSpecification",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetEbsDefaultKmsKeyIdCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetEbsDefaultKmsKeyIdRequest(input, context),
        Action: "GetEbsDefaultKmsKeyId",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetEbsEncryptionByDefaultCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetEbsEncryptionByDefaultRequest(input, context),
        Action: "GetEbsEncryptionByDefault",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetFlowLogsIntegrationTemplateCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetFlowLogsIntegrationTemplateRequest(input, context),
        Action: "GetFlowLogsIntegrationTemplate",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetGroupsForCapacityReservationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetGroupsForCapacityReservationRequest(input, context),
        Action: "GetGroupsForCapacityReservation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetHostReservationPurchasePreviewCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetHostReservationPurchasePreviewRequest(input, context),
        Action: "GetHostReservationPurchasePreview",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetInstanceTypesFromInstanceRequirementsRequest(input, context),
        Action: "GetInstanceTypesFromInstanceRequirements",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetInstanceUefiDataCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetInstanceUefiDataRequest(input, context),
        Action: "GetInstanceUefiData",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetIpamAddressHistoryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetIpamAddressHistoryRequest(input, context),
        Action: "GetIpamAddressHistory",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetIpamPoolAllocationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetIpamPoolAllocationsRequest(input, context),
        Action: "GetIpamPoolAllocations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetIpamPoolCidrsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetIpamPoolCidrsRequest(input, context),
        Action: "GetIpamPoolCidrs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetIpamResourceCidrsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetIpamResourceCidrsRequest(input, context),
        Action: "GetIpamResourceCidrs",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetLaunchTemplateDataCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetLaunchTemplateDataRequest(input, context),
        Action: "GetLaunchTemplateData",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetManagedPrefixListAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetManagedPrefixListAssociationsRequest(input, context),
        Action: "GetManagedPrefixListAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetManagedPrefixListEntriesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetManagedPrefixListEntriesRequest(input, context),
        Action: "GetManagedPrefixListEntries",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsRequest(input, context),
        Action: "GetNetworkInsightsAccessScopeAnalysisFindings",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetNetworkInsightsAccessScopeContentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetNetworkInsightsAccessScopeContentRequest(input, context),
        Action: "GetNetworkInsightsAccessScopeContent",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetPasswordDataCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetPasswordDataRequest(input, context),
        Action: "GetPasswordData",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetReservedInstancesExchangeQuoteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetReservedInstancesExchangeQuoteRequest(input, context),
        Action: "GetReservedInstancesExchangeQuote",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetSerialConsoleAccessStatusCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetSerialConsoleAccessStatusRequest(input, context),
        Action: "GetSerialConsoleAccessStatus",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetSpotPlacementScoresCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetSpotPlacementScoresRequest(input, context),
        Action: "GetSpotPlacementScores",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetSubnetCidrReservationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetSubnetCidrReservationsRequest(input, context),
        Action: "GetSubnetCidrReservations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetTransitGatewayAttachmentPropagationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetTransitGatewayAttachmentPropagationsRequest(input, context),
        Action: "GetTransitGatewayAttachmentPropagations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetTransitGatewayMulticastDomainAssociationsRequest(input, context),
        Action: "GetTransitGatewayMulticastDomainAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetTransitGatewayPolicyTableAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetTransitGatewayPolicyTableAssociationsRequest(input, context),
        Action: "GetTransitGatewayPolicyTableAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetTransitGatewayPolicyTableEntriesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetTransitGatewayPolicyTableEntriesRequest(input, context),
        Action: "GetTransitGatewayPolicyTableEntries",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetTransitGatewayPrefixListReferencesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetTransitGatewayPrefixListReferencesRequest(input, context),
        Action: "GetTransitGatewayPrefixListReferences",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetTransitGatewayRouteTableAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetTransitGatewayRouteTableAssociationsRequest(input, context),
        Action: "GetTransitGatewayRouteTableAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetTransitGatewayRouteTablePropagationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetTransitGatewayRouteTablePropagationsRequest(input, context),
        Action: "GetTransitGatewayRouteTablePropagations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetVerifiedAccessEndpointPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetVerifiedAccessEndpointPolicyRequest(input, context),
        Action: "GetVerifiedAccessEndpointPolicy",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetVerifiedAccessGroupPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetVerifiedAccessGroupPolicyRequest(input, context),
        Action: "GetVerifiedAccessGroupPolicy",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetVpnConnectionDeviceSampleConfigurationRequest(input, context),
        Action: "GetVpnConnectionDeviceSampleConfiguration",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2GetVpnConnectionDeviceTypesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2GetVpnConnectionDeviceTypesRequest(input, context),
        Action: "GetVpnConnectionDeviceTypes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ImportClientVpnClientCertificateRevocationListCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ImportClientVpnClientCertificateRevocationListRequest(input, context),
        Action: "ImportClientVpnClientCertificateRevocationList",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ImportImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ImportImageRequest(input, context),
        Action: "ImportImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ImportInstanceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ImportInstanceRequest(input, context),
        Action: "ImportInstance",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ImportKeyPairCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ImportKeyPairRequest(input, context),
        Action: "ImportKeyPair",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ImportSnapshotCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ImportSnapshotRequest(input, context),
        Action: "ImportSnapshot",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ImportVolumeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ImportVolumeRequest(input, context),
        Action: "ImportVolume",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ListImagesInRecycleBinCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ListImagesInRecycleBinRequest(input, context),
        Action: "ListImagesInRecycleBin",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ListSnapshotsInRecycleBinCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ListSnapshotsInRecycleBinRequest(input, context),
        Action: "ListSnapshotsInRecycleBin",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyAddressAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyAddressAttributeRequest(input, context),
        Action: "ModifyAddressAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyAvailabilityZoneGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyAvailabilityZoneGroupRequest(input, context),
        Action: "ModifyAvailabilityZoneGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyCapacityReservationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyCapacityReservationRequest(input, context),
        Action: "ModifyCapacityReservation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyCapacityReservationFleetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyCapacityReservationFleetRequest(input, context),
        Action: "ModifyCapacityReservationFleet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyClientVpnEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyClientVpnEndpointRequest(input, context),
        Action: "ModifyClientVpnEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyDefaultCreditSpecificationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyDefaultCreditSpecificationRequest(input, context),
        Action: "ModifyDefaultCreditSpecification",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyEbsDefaultKmsKeyIdCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyEbsDefaultKmsKeyIdRequest(input, context),
        Action: "ModifyEbsDefaultKmsKeyId",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyFleetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyFleetRequest(input, context),
        Action: "ModifyFleet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyFpgaImageAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyFpgaImageAttributeRequest(input, context),
        Action: "ModifyFpgaImageAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyHostsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyHostsRequest(input, context),
        Action: "ModifyHosts",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyIdentityIdFormatCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyIdentityIdFormatRequest(input, context),
        Action: "ModifyIdentityIdFormat",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyIdFormatCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyIdFormatRequest(input, context),
        Action: "ModifyIdFormat",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyImageAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyImageAttributeRequest(input, context),
        Action: "ModifyImageAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstanceAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstanceAttributeRequest(input, context),
        Action: "ModifyInstanceAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstanceCapacityReservationAttributesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstanceCapacityReservationAttributesRequest(input, context),
        Action: "ModifyInstanceCapacityReservationAttributes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstanceCreditSpecificationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstanceCreditSpecificationRequest(input, context),
        Action: "ModifyInstanceCreditSpecification",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstanceEventStartTimeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstanceEventStartTimeRequest(input, context),
        Action: "ModifyInstanceEventStartTime",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstanceEventWindowCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstanceEventWindowRequest(input, context),
        Action: "ModifyInstanceEventWindow",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstanceMaintenanceOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstanceMaintenanceOptionsRequest(input, context),
        Action: "ModifyInstanceMaintenanceOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstanceMetadataOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstanceMetadataOptionsRequest(input, context),
        Action: "ModifyInstanceMetadataOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyInstancePlacementCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyInstancePlacementRequest(input, context),
        Action: "ModifyInstancePlacement",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyIpamCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyIpamRequest(input, context),
        Action: "ModifyIpam",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyIpamPoolCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyIpamPoolRequest(input, context),
        Action: "ModifyIpamPool",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyIpamResourceCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyIpamResourceCidrRequest(input, context),
        Action: "ModifyIpamResourceCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyIpamScopeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyIpamScopeRequest(input, context),
        Action: "ModifyIpamScope",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyLaunchTemplateCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyLaunchTemplateRequest(input, context),
        Action: "ModifyLaunchTemplate",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyLocalGatewayRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyLocalGatewayRouteRequest(input, context),
        Action: "ModifyLocalGatewayRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyManagedPrefixListCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyManagedPrefixListRequest(input, context),
        Action: "ModifyManagedPrefixList",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyNetworkInterfaceAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyNetworkInterfaceAttributeRequest(input, context),
        Action: "ModifyNetworkInterfaceAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyPrivateDnsNameOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyPrivateDnsNameOptionsRequest(input, context),
        Action: "ModifyPrivateDnsNameOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyReservedInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyReservedInstancesRequest(input, context),
        Action: "ModifyReservedInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifySecurityGroupRulesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifySecurityGroupRulesRequest(input, context),
        Action: "ModifySecurityGroupRules",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifySnapshotAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifySnapshotAttributeRequest(input, context),
        Action: "ModifySnapshotAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifySnapshotTierCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifySnapshotTierRequest(input, context),
        Action: "ModifySnapshotTier",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifySpotFleetRequestCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifySpotFleetRequestRequest(input, context),
        Action: "ModifySpotFleetRequest",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifySubnetAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifySubnetAttributeRequest(input, context),
        Action: "ModifySubnetAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyTrafficMirrorFilterNetworkServicesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyTrafficMirrorFilterNetworkServicesRequest(input, context),
        Action: "ModifyTrafficMirrorFilterNetworkServices",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyTrafficMirrorFilterRuleCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyTrafficMirrorFilterRuleRequest(input, context),
        Action: "ModifyTrafficMirrorFilterRule",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyTrafficMirrorSessionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyTrafficMirrorSessionRequest(input, context),
        Action: "ModifyTrafficMirrorSession",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyTransitGatewayCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyTransitGatewayRequest(input, context),
        Action: "ModifyTransitGateway",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyTransitGatewayPrefixListReferenceRequest(input, context),
        Action: "ModifyTransitGatewayPrefixListReference",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyTransitGatewayVpcAttachmentRequest(input, context),
        Action: "ModifyTransitGatewayVpcAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVerifiedAccessEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVerifiedAccessEndpointRequest(input, context),
        Action: "ModifyVerifiedAccessEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVerifiedAccessEndpointPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVerifiedAccessEndpointPolicyRequest(input, context),
        Action: "ModifyVerifiedAccessEndpointPolicy",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVerifiedAccessGroupCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVerifiedAccessGroupRequest(input, context),
        Action: "ModifyVerifiedAccessGroup",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVerifiedAccessGroupPolicyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVerifiedAccessGroupPolicyRequest(input, context),
        Action: "ModifyVerifiedAccessGroupPolicy",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVerifiedAccessInstanceCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVerifiedAccessInstanceRequest(input, context),
        Action: "ModifyVerifiedAccessInstance",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVerifiedAccessInstanceLoggingConfigurationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVerifiedAccessInstanceLoggingConfigurationRequest(input, context),
        Action: "ModifyVerifiedAccessInstanceLoggingConfiguration",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVerifiedAccessTrustProviderCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVerifiedAccessTrustProviderRequest(input, context),
        Action: "ModifyVerifiedAccessTrustProvider",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVolumeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVolumeRequest(input, context),
        Action: "ModifyVolume",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVolumeAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVolumeAttributeRequest(input, context),
        Action: "ModifyVolumeAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcAttributeRequest(input, context),
        Action: "ModifyVpcAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcEndpointCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcEndpointRequest(input, context),
        Action: "ModifyVpcEndpoint",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcEndpointConnectionNotificationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcEndpointConnectionNotificationRequest(input, context),
        Action: "ModifyVpcEndpointConnectionNotification",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcEndpointServiceConfigurationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcEndpointServiceConfigurationRequest(input, context),
        Action: "ModifyVpcEndpointServiceConfiguration",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcEndpointServicePayerResponsibilityCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcEndpointServicePayerResponsibilityRequest(input, context),
        Action: "ModifyVpcEndpointServicePayerResponsibility",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcEndpointServicePermissionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcEndpointServicePermissionsRequest(input, context),
        Action: "ModifyVpcEndpointServicePermissions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcPeeringConnectionOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcPeeringConnectionOptionsRequest(input, context),
        Action: "ModifyVpcPeeringConnectionOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpcTenancyCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpcTenancyRequest(input, context),
        Action: "ModifyVpcTenancy",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpnConnectionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpnConnectionRequest(input, context),
        Action: "ModifyVpnConnection",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpnConnectionOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpnConnectionOptionsRequest(input, context),
        Action: "ModifyVpnConnectionOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpnTunnelCertificateCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpnTunnelCertificateRequest(input, context),
        Action: "ModifyVpnTunnelCertificate",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ModifyVpnTunnelOptionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ModifyVpnTunnelOptionsRequest(input, context),
        Action: "ModifyVpnTunnelOptions",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2MonitorInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2MonitorInstancesRequest(input, context),
        Action: "MonitorInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2MoveAddressToVpcCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2MoveAddressToVpcRequest(input, context),
        Action: "MoveAddressToVpc",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2MoveByoipCidrToIpamCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2MoveByoipCidrToIpamRequest(input, context),
        Action: "MoveByoipCidrToIpam",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ProvisionByoipCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ProvisionByoipCidrRequest(input, context),
        Action: "ProvisionByoipCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ProvisionIpamPoolCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ProvisionIpamPoolCidrRequest(input, context),
        Action: "ProvisionIpamPoolCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ProvisionPublicIpv4PoolCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ProvisionPublicIpv4PoolCidrRequest(input, context),
        Action: "ProvisionPublicIpv4PoolCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2PurchaseHostReservationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2PurchaseHostReservationRequest(input, context),
        Action: "PurchaseHostReservation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2PurchaseReservedInstancesOfferingCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2PurchaseReservedInstancesOfferingRequest(input, context),
        Action: "PurchaseReservedInstancesOffering",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2PurchaseScheduledInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2PurchaseScheduledInstancesRequest(input, context),
        Action: "PurchaseScheduledInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RebootInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RebootInstancesRequest(input, context),
        Action: "RebootInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RegisterImageCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RegisterImageRequest(input, context),
        Action: "RegisterImage",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RegisterInstanceEventNotificationAttributesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RegisterInstanceEventNotificationAttributesRequest(input, context),
        Action: "RegisterInstanceEventNotificationAttributes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RegisterTransitGatewayMulticastGroupMembersRequest(input, context),
        Action: "RegisterTransitGatewayMulticastGroupMembers",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesRequest(input, context),
        Action: "RegisterTransitGatewayMulticastGroupSources",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsRequest(input, context),
        Action: "RejectTransitGatewayMulticastDomainAssociations",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RejectTransitGatewayPeeringAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RejectTransitGatewayPeeringAttachmentRequest(input, context),
        Action: "RejectTransitGatewayPeeringAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RejectTransitGatewayVpcAttachmentCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RejectTransitGatewayVpcAttachmentRequest(input, context),
        Action: "RejectTransitGatewayVpcAttachment",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RejectVpcEndpointConnectionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RejectVpcEndpointConnectionsRequest(input, context),
        Action: "RejectVpcEndpointConnections",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RejectVpcPeeringConnectionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RejectVpcPeeringConnectionRequest(input, context),
        Action: "RejectVpcPeeringConnection",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReleaseAddressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReleaseAddressRequest(input, context),
        Action: "ReleaseAddress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReleaseHostsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReleaseHostsRequest(input, context),
        Action: "ReleaseHosts",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReleaseIpamPoolAllocationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReleaseIpamPoolAllocationRequest(input, context),
        Action: "ReleaseIpamPoolAllocation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReplaceIamInstanceProfileAssociationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReplaceIamInstanceProfileAssociationRequest(input, context),
        Action: "ReplaceIamInstanceProfileAssociation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReplaceNetworkAclAssociationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReplaceNetworkAclAssociationRequest(input, context),
        Action: "ReplaceNetworkAclAssociation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReplaceNetworkAclEntryCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReplaceNetworkAclEntryRequest(input, context),
        Action: "ReplaceNetworkAclEntry",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReplaceRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReplaceRouteRequest(input, context),
        Action: "ReplaceRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReplaceRouteTableAssociationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReplaceRouteTableAssociationRequest(input, context),
        Action: "ReplaceRouteTableAssociation",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReplaceTransitGatewayRouteCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReplaceTransitGatewayRouteRequest(input, context),
        Action: "ReplaceTransitGatewayRoute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ReportInstanceStatusCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ReportInstanceStatusRequest(input, context),
        Action: "ReportInstanceStatus",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RequestSpotFleetCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RequestSpotFleetRequest(input, context),
        Action: "RequestSpotFleet",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RequestSpotInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RequestSpotInstancesRequest(input, context),
        Action: "RequestSpotInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ResetAddressAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ResetAddressAttributeRequest(input, context),
        Action: "ResetAddressAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ResetEbsDefaultKmsKeyIdCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ResetEbsDefaultKmsKeyIdRequest(input, context),
        Action: "ResetEbsDefaultKmsKeyId",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ResetFpgaImageAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ResetFpgaImageAttributeRequest(input, context),
        Action: "ResetFpgaImageAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ResetImageAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ResetImageAttributeRequest(input, context),
        Action: "ResetImageAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ResetInstanceAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ResetInstanceAttributeRequest(input, context),
        Action: "ResetInstanceAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ResetNetworkInterfaceAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ResetNetworkInterfaceAttributeRequest(input, context),
        Action: "ResetNetworkInterfaceAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2ResetSnapshotAttributeCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2ResetSnapshotAttributeRequest(input, context),
        Action: "ResetSnapshotAttribute",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RestoreAddressToClassicCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RestoreAddressToClassicRequest(input, context),
        Action: "RestoreAddressToClassic",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RestoreImageFromRecycleBinCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RestoreImageFromRecycleBinRequest(input, context),
        Action: "RestoreImageFromRecycleBin",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RestoreManagedPrefixListVersionCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RestoreManagedPrefixListVersionRequest(input, context),
        Action: "RestoreManagedPrefixListVersion",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RestoreSnapshotFromRecycleBinCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RestoreSnapshotFromRecycleBinRequest(input, context),
        Action: "RestoreSnapshotFromRecycleBin",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RestoreSnapshotTierCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RestoreSnapshotTierRequest(input, context),
        Action: "RestoreSnapshotTier",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RevokeClientVpnIngressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RevokeClientVpnIngressRequest(input, context),
        Action: "RevokeClientVpnIngress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RevokeSecurityGroupEgressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RevokeSecurityGroupEgressRequest(input, context),
        Action: "RevokeSecurityGroupEgress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RevokeSecurityGroupIngressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RevokeSecurityGroupIngressRequest(input, context),
        Action: "RevokeSecurityGroupIngress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RunInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RunInstancesRequest(input, context),
        Action: "RunInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2RunScheduledInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2RunScheduledInstancesRequest(input, context),
        Action: "RunScheduledInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2SearchLocalGatewayRoutesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2SearchLocalGatewayRoutesRequest(input, context),
        Action: "SearchLocalGatewayRoutes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2SearchTransitGatewayMulticastGroupsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2SearchTransitGatewayMulticastGroupsRequest(input, context),
        Action: "SearchTransitGatewayMulticastGroups",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2SearchTransitGatewayRoutesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2SearchTransitGatewayRoutesRequest(input, context),
        Action: "SearchTransitGatewayRoutes",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2SendDiagnosticInterruptCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2SendDiagnosticInterruptRequest(input, context),
        Action: "SendDiagnosticInterrupt",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2StartInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2StartInstancesRequest(input, context),
        Action: "StartInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2StartNetworkInsightsAccessScopeAnalysisRequest(input, context),
        Action: "StartNetworkInsightsAccessScopeAnalysis",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2StartNetworkInsightsAnalysisCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2StartNetworkInsightsAnalysisRequest(input, context),
        Action: "StartNetworkInsightsAnalysis",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2StartVpcEndpointServicePrivateDnsVerificationCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2StartVpcEndpointServicePrivateDnsVerificationRequest(input, context),
        Action: "StartVpcEndpointServicePrivateDnsVerification",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2StopInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2StopInstancesRequest(input, context),
        Action: "StopInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2TerminateClientVpnConnectionsCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2TerminateClientVpnConnectionsRequest(input, context),
        Action: "TerminateClientVpnConnections",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2TerminateInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2TerminateInstancesRequest(input, context),
        Action: "TerminateInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2UnassignIpv6AddressesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2UnassignIpv6AddressesRequest(input, context),
        Action: "UnassignIpv6Addresses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2UnassignPrivateIpAddressesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2UnassignPrivateIpAddressesRequest(input, context),
        Action: "UnassignPrivateIpAddresses",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2UnmonitorInstancesCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2UnmonitorInstancesRequest(input, context),
        Action: "UnmonitorInstances",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressRequest(input, context),
        Action: "UpdateSecurityGroupRuleDescriptionsEgress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressRequest(input, context),
        Action: "UpdateSecurityGroupRuleDescriptionsIngress",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const serializeAws_ec2WithdrawByoipCidrCommand = async (input, context) => {
    const headers = {
        "content-type": "application/x-www-form-urlencoded",
    };
    let body;
    body = buildFormUrlencodedString({
        ...serializeAws_ec2WithdrawByoipCidrRequest(input, context),
        Action: "WithdrawByoipCidr",
        Version: "2016-11-15",
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const deserializeAws_ec2AcceptAddressTransferCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AcceptAddressTransferCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AcceptAddressTransferResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AcceptAddressTransferCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AcceptReservedInstancesExchangeQuoteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AcceptReservedInstancesExchangeQuoteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AcceptReservedInstancesExchangeQuoteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AcceptReservedInstancesExchangeQuoteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AcceptTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AcceptTransitGatewayPeeringAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AcceptTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AcceptTransitGatewayVpcAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AcceptTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AcceptTransitGatewayVpcAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AcceptVpcEndpointConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AcceptVpcEndpointConnectionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AcceptVpcEndpointConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AcceptVpcEndpointConnectionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AcceptVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AcceptVpcPeeringConnectionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AcceptVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AcceptVpcPeeringConnectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AdvertiseByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AdvertiseByoipCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AdvertiseByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AdvertiseByoipCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AllocateAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AllocateAddressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AllocateAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AllocateAddressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AllocateHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AllocateHostsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AllocateHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AllocateHostsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AllocateIpamPoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AllocateIpamPoolCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AllocateIpamPoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AllocateIpamPoolCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssignIpv6AddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssignIpv6AddressesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssignIpv6AddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssignIpv6AddressesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssignPrivateIpAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssignPrivateIpAddressesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssignPrivateIpAddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssignPrivateIpAddressesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateAddressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateAddressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateAddressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateClientVpnTargetNetworkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateClientVpnTargetNetworkCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateClientVpnTargetNetworkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateClientVpnTargetNetworkCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateDhcpOptionsCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateDhcpOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateEnclaveCertificateIamRoleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateEnclaveCertificateIamRoleCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateEnclaveCertificateIamRoleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateEnclaveCertificateIamRoleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateIamInstanceProfileCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateIamInstanceProfileCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateIamInstanceProfileResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateIamInstanceProfileCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateInstanceEventWindowCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateInstanceEventWindowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateSubnetCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateSubnetCidrBlockCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateSubnetCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateSubnetCidrBlockCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateTransitGatewayMulticastDomainCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateTransitGatewayMulticastDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateTransitGatewayPolicyTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateTransitGatewayPolicyTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateTransitGatewayRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateTransitGatewayRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateTrunkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateTrunkInterfaceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateTrunkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateTrunkInterfaceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AssociateVpcCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AssociateVpcCidrBlockCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AssociateVpcCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AssociateVpcCidrBlockCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AttachClassicLinkVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AttachClassicLinkVpcCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AttachClassicLinkVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AttachClassicLinkVpcCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AttachInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AttachInternetGatewayCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AttachInternetGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AttachNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AttachNetworkInterfaceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AttachNetworkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AttachNetworkInterfaceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AttachVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AttachVerifiedAccessTrustProviderCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AttachVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AttachVerifiedAccessTrustProviderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AttachVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AttachVolumeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2VolumeAttachment(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AttachVolumeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AttachVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AttachVpnGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AttachVpnGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AttachVpnGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AuthorizeClientVpnIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AuthorizeClientVpnIngressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AuthorizeClientVpnIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AuthorizeClientVpnIngressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AuthorizeSecurityGroupEgressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AuthorizeSecurityGroupEgressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AuthorizeSecurityGroupEgressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AuthorizeSecurityGroupEgressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2AuthorizeSecurityGroupIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2AuthorizeSecurityGroupIngressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2AuthorizeSecurityGroupIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2AuthorizeSecurityGroupIngressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2BundleInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2BundleInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2BundleInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2BundleInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelBundleTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelBundleTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelBundleTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelBundleTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelCapacityReservationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelCapacityReservationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelCapacityReservationFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelCapacityReservationFleetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelCapacityReservationFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelCapacityReservationFleetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelConversionTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelConversionTaskCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelConversionTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelExportTaskCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelExportTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelImageLaunchPermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelImageLaunchPermissionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelImageLaunchPermissionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelImageLaunchPermissionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelImportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelImportTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelImportTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelImportTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelReservedInstancesListingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelReservedInstancesListingCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelReservedInstancesListingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelReservedInstancesListingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelSpotFleetRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelSpotFleetRequestsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelSpotFleetRequestsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelSpotFleetRequestsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CancelSpotInstanceRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CancelSpotInstanceRequestsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CancelSpotInstanceRequestsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CancelSpotInstanceRequestsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ConfirmProductInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ConfirmProductInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ConfirmProductInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ConfirmProductInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CopyFpgaImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CopyFpgaImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CopyFpgaImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CopyFpgaImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CopyImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CopyImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CopyImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CopyImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CopySnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CopySnapshotCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CopySnapshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CopySnapshotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateCapacityReservationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateCapacityReservationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateCapacityReservationFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateCapacityReservationFleetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateCapacityReservationFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateCapacityReservationFleetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateCarrierGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateCarrierGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateCarrierGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateCarrierGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateClientVpnEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateClientVpnEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateClientVpnEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateClientVpnEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateClientVpnRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateClientVpnRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateClientVpnRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateClientVpnRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateCoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateCoipCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateCoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateCoipCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateCoipPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateCoipPoolCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateCoipPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateCoipPoolCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateCustomerGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateCustomerGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateCustomerGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateCustomerGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateDefaultSubnetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateDefaultSubnetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateDefaultSubnetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateDefaultSubnetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateDefaultVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateDefaultVpcCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateDefaultVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateDefaultVpcCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateDhcpOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateDhcpOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateDhcpOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateEgressOnlyInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateEgressOnlyInternetGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateEgressOnlyInternetGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateEgressOnlyInternetGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateFleetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateFleetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateFlowLogsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateFlowLogsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateFlowLogsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateFlowLogsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateFpgaImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateFpgaImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateFpgaImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateFpgaImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateInstanceEventWindowCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateInstanceEventWindowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateInstanceExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateInstanceExportTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateInstanceExportTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateInstanceExportTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateInternetGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateInternetGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateInternetGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateIpamCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateIpamCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateIpamPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateIpamPoolCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateIpamPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateIpamPoolCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateIpamScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateIpamScopeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateIpamScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateIpamScopeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateKeyPairCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateKeyPairCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2KeyPair(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateKeyPairCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateLaunchTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateLaunchTemplateCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateLaunchTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateLaunchTemplateCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateLaunchTemplateVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateLaunchTemplateVersionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateLaunchTemplateVersionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateLaunchTemplateVersionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateLocalGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateLocalGatewayRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateLocalGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateLocalGatewayRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateLocalGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateLocalGatewayRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateLocalGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateLocalGatewayRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateManagedPrefixListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateManagedPrefixListCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateManagedPrefixListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateManagedPrefixListCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateNatGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateNatGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateNatGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateNatGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateNetworkAclCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateNetworkAclCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateNetworkAclResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateNetworkAclCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateNetworkAclEntryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateNetworkAclEntryCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateNetworkAclEntryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateNetworkInsightsAccessScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateNetworkInsightsAccessScopeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateNetworkInsightsAccessScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateNetworkInsightsAccessScopeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateNetworkInsightsPathCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateNetworkInsightsPathCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateNetworkInsightsPathResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateNetworkInsightsPathCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateNetworkInterfaceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateNetworkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateNetworkInterfaceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateNetworkInterfacePermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateNetworkInterfacePermissionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateNetworkInterfacePermissionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateNetworkInterfacePermissionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreatePlacementGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreatePlacementGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreatePlacementGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreatePlacementGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreatePublicIpv4PoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreatePublicIpv4PoolCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreatePublicIpv4PoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreatePublicIpv4PoolCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateReplaceRootVolumeTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateReplaceRootVolumeTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateReplaceRootVolumeTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateReplaceRootVolumeTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateReservedInstancesListingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateReservedInstancesListingCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateReservedInstancesListingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateReservedInstancesListingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateRestoreImageTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateRestoreImageTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateRestoreImageTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateRestoreImageTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateSecurityGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateSecurityGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateSecurityGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateSecurityGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateSnapshotCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2Snapshot(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateSnapshotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateSnapshotsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateSnapshotsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateSnapshotsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateSnapshotsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateSpotDatafeedSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateSpotDatafeedSubscriptionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateSpotDatafeedSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateSpotDatafeedSubscriptionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateStoreImageTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateStoreImageTaskCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateStoreImageTaskResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateStoreImageTaskCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateSubnetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateSubnetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateSubnetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateSubnetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateSubnetCidrReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateSubnetCidrReservationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateSubnetCidrReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateSubnetCidrReservationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTagsCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTagsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTrafficMirrorFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTrafficMirrorFilterCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTrafficMirrorFilterResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTrafficMirrorFilterCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTrafficMirrorFilterRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTrafficMirrorFilterRuleCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTrafficMirrorFilterRuleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTrafficMirrorFilterRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTrafficMirrorSessionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTrafficMirrorSessionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTrafficMirrorSessionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTrafficMirrorSessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTrafficMirrorTargetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTrafficMirrorTargetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTrafficMirrorTargetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTrafficMirrorTargetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayConnectCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayConnectCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayConnectResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayConnectCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayConnectPeerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayConnectPeerCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayConnectPeerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayConnectPeerCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayMulticastDomainCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayMulticastDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayPeeringAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayPeeringAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayPolicyTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayPolicyTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayPrefixListReferenceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayPrefixListReferenceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayPrefixListReferenceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayPrefixListReferenceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayRouteTableAnnouncementCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayRouteTableAnnouncementCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayRouteTableAnnouncementResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayRouteTableAnnouncementCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateTransitGatewayVpcAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateTransitGatewayVpcAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVerifiedAccessEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVerifiedAccessEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVerifiedAccessEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVerifiedAccessEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVerifiedAccessGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVerifiedAccessGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVerifiedAccessGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVerifiedAccessGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVerifiedAccessInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVerifiedAccessInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVerifiedAccessInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVerifiedAccessInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVerifiedAccessTrustProviderCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVerifiedAccessTrustProviderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVolumeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2Volume(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVolumeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpcCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpcCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpcEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpcEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVpcEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpcEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpcEndpointConnectionNotificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpcEndpointConnectionNotificationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVpcEndpointConnectionNotificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpcEndpointConnectionNotificationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpcEndpointServiceConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpcEndpointServiceConfigurationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVpcEndpointServiceConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpcEndpointServiceConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpcPeeringConnectionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpcPeeringConnectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpnConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpnConnectionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVpnConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpnConnectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpnConnectionRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpnConnectionRouteCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpnConnectionRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2CreateVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2CreateVpnGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2CreateVpnGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2CreateVpnGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteCarrierGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteCarrierGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteCarrierGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteCarrierGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteClientVpnEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteClientVpnEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteClientVpnEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteClientVpnEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteClientVpnRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteClientVpnRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteClientVpnRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteClientVpnRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteCoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteCoipCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteCoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteCoipCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteCoipPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteCoipPoolCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteCoipPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteCoipPoolCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteCustomerGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteCustomerGatewayCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteCustomerGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteDhcpOptionsCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteDhcpOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteEgressOnlyInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteEgressOnlyInternetGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteEgressOnlyInternetGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteEgressOnlyInternetGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteFleetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteFleetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteFlowLogsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteFlowLogsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteFlowLogsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteFlowLogsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteFpgaImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteFpgaImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteFpgaImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteFpgaImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteInstanceEventWindowCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteInstanceEventWindowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteInternetGatewayCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteInternetGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteIpamCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteIpamCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteIpamPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteIpamPoolCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteIpamPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteIpamPoolCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteIpamScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteIpamScopeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteIpamScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteIpamScopeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteKeyPairCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteKeyPairCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteKeyPairCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteLaunchTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteLaunchTemplateCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteLaunchTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteLaunchTemplateCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteLaunchTemplateVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteLaunchTemplateVersionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteLaunchTemplateVersionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteLaunchTemplateVersionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteLocalGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteLocalGatewayRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteLocalGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteLocalGatewayRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteLocalGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteLocalGatewayRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteLocalGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteLocalGatewayRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteLocalGatewayRouteTableVpcAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteLocalGatewayRouteTableVpcAssociationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteLocalGatewayRouteTableVpcAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteLocalGatewayRouteTableVpcAssociationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteManagedPrefixListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteManagedPrefixListCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteManagedPrefixListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteManagedPrefixListCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNatGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNatGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteNatGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNatGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkAclCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkAclCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkAclCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkAclEntryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkAclEntryCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkAclEntryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkInsightsAccessScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkInsightsAccessScopeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteNetworkInsightsAccessScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkInsightsAccessScopeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkInsightsAccessScopeAnalysisCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkInsightsAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkInsightsAnalysisCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteNetworkInsightsAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkInsightsAnalysisCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkInsightsPathCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkInsightsPathCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteNetworkInsightsPathResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkInsightsPathCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkInterfaceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkInterfaceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteNetworkInterfacePermissionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteNetworkInterfacePermissionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteNetworkInterfacePermissionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteNetworkInterfacePermissionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeletePlacementGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeletePlacementGroupCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeletePlacementGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeletePublicIpv4PoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeletePublicIpv4PoolCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeletePublicIpv4PoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeletePublicIpv4PoolCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteQueuedReservedInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteQueuedReservedInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteQueuedReservedInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteQueuedReservedInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteRouteCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteRouteTableCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteSecurityGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteSecurityGroupCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteSecurityGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteSnapshotCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteSnapshotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteSpotDatafeedSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteSpotDatafeedSubscriptionCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteSpotDatafeedSubscriptionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteSubnetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteSubnetCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteSubnetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteSubnetCidrReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteSubnetCidrReservationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteSubnetCidrReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteSubnetCidrReservationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTagsCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTagsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTrafficMirrorFilterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTrafficMirrorFilterCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTrafficMirrorFilterResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTrafficMirrorFilterCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTrafficMirrorFilterRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTrafficMirrorFilterRuleCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTrafficMirrorFilterRuleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTrafficMirrorFilterRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTrafficMirrorSessionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTrafficMirrorSessionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTrafficMirrorSessionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTrafficMirrorSessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTrafficMirrorTargetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTrafficMirrorTargetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTrafficMirrorTargetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTrafficMirrorTargetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayConnectCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayConnectCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayConnectResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayConnectCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayConnectPeerCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayConnectPeerCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayConnectPeerResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayConnectPeerCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayMulticastDomainCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayMulticastDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayPeeringAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayPolicyTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayPolicyTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayPrefixListReferenceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayPrefixListReferenceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayRouteTableAnnouncementCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayRouteTableAnnouncementCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayRouteTableAnnouncementResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayRouteTableAnnouncementCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteTransitGatewayVpcAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteTransitGatewayVpcAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVerifiedAccessEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVerifiedAccessEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVerifiedAccessEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVerifiedAccessEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVerifiedAccessGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVerifiedAccessGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVerifiedAccessGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVerifiedAccessGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVerifiedAccessInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVerifiedAccessInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVerifiedAccessInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVerifiedAccessInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVerifiedAccessTrustProviderCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVerifiedAccessTrustProviderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVolumeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVolumeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpcCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpcCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVpcEndpointConnectionNotificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpcEndpointConnectionNotificationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpcEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpcEndpointsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVpcEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpcEndpointsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVpcEndpointServiceConfigurationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpcEndpointServiceConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpcPeeringConnectionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeleteVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpcPeeringConnectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpnConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpnConnectionCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpnConnectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpnConnectionRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpnConnectionRouteCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpnConnectionRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeleteVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeleteVpnGatewayCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeleteVpnGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeprovisionByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeprovisionByoipCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeprovisionByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeprovisionByoipCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeprovisionIpamPoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeprovisionIpamPoolCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeprovisionIpamPoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeprovisionIpamPoolCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeprovisionPublicIpv4PoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeprovisionPublicIpv4PoolCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeprovisionPublicIpv4PoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeprovisionPublicIpv4PoolCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeregisterImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeregisterImageCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeregisterImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeregisterInstanceEventNotificationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeregisterInstanceEventNotificationAttributesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeregisterInstanceEventNotificationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeregisterInstanceEventNotificationAttributesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeregisterTransitGatewayMulticastGroupMembersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DeregisterTransitGatewayMulticastGroupSourcesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeAccountAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeAccountAttributesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeAccountAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeAccountAttributesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeAddressesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeAddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeAddressesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeAddressesAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeAddressesAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeAddressesAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeAddressesAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeAddressTransfersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeAddressTransfersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeAddressTransfersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeAddressTransfersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeAggregateIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeAggregateIdFormatCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeAggregateIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeAggregateIdFormatCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeAvailabilityZonesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeAvailabilityZonesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeAvailabilityZonesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeAvailabilityZonesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeAwsNetworkPerformanceMetricSubscriptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeAwsNetworkPerformanceMetricSubscriptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeAwsNetworkPerformanceMetricSubscriptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeAwsNetworkPerformanceMetricSubscriptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeBundleTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeBundleTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeBundleTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeBundleTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeByoipCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeByoipCidrsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeByoipCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeByoipCidrsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeCapacityReservationFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeCapacityReservationFleetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeCapacityReservationFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeCapacityReservationFleetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeCapacityReservationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeCapacityReservationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeCapacityReservationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeCapacityReservationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeCarrierGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeCarrierGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeCarrierGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeCarrierGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeClassicLinkInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeClassicLinkInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeClassicLinkInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeClassicLinkInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeClientVpnAuthorizationRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeClientVpnAuthorizationRulesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeClientVpnAuthorizationRulesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeClientVpnAuthorizationRulesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeClientVpnConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeClientVpnConnectionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeClientVpnConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeClientVpnConnectionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeClientVpnEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeClientVpnEndpointsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeClientVpnEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeClientVpnEndpointsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeClientVpnRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeClientVpnRoutesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeClientVpnRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeClientVpnRoutesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeClientVpnTargetNetworksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeClientVpnTargetNetworksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeClientVpnTargetNetworksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeClientVpnTargetNetworksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeCoipPoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeCoipPoolsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeCoipPoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeCoipPoolsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeConversionTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeConversionTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeConversionTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeConversionTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeCustomerGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeCustomerGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeCustomerGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeCustomerGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeDhcpOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeDhcpOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeDhcpOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeDhcpOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeEgressOnlyInternetGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeEgressOnlyInternetGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeEgressOnlyInternetGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeEgressOnlyInternetGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeElasticGpusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeElasticGpusCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeElasticGpusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeElasticGpusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeExportImageTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeExportImageTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeExportImageTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeExportImageTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeExportTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeExportTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeExportTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeExportTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFastLaunchImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFastLaunchImagesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFastLaunchImagesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFastLaunchImagesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFastSnapshotRestoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFastSnapshotRestoresCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFastSnapshotRestoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFastSnapshotRestoresCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFleetHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFleetHistoryCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFleetHistoryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFleetHistoryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFleetInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFleetInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFleetInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFleetInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFleetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFleetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFleetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFleetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFlowLogsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFlowLogsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFlowLogsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFlowLogsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFpgaImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFpgaImageAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFpgaImageAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFpgaImageAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeFpgaImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeFpgaImagesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeFpgaImagesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeFpgaImagesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeHostReservationOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeHostReservationOfferingsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeHostReservationOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeHostReservationOfferingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeHostReservationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeHostReservationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeHostReservationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeHostReservationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeHostsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeHostsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeIamInstanceProfileAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeIamInstanceProfileAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeIamInstanceProfileAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeIamInstanceProfileAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeIdentityIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeIdentityIdFormatCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeIdentityIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeIdentityIdFormatCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeIdFormatCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeIdFormatCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeImageAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ImageAttribute(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeImageAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeImagesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeImagesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeImagesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeImagesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeImportImageTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeImportImageTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeImportImageTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeImportImageTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeImportSnapshotTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeImportSnapshotTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeImportSnapshotTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeImportSnapshotTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstanceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstanceAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2InstanceAttribute(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstanceAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstanceCreditSpecificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstanceCreditSpecificationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInstanceCreditSpecificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstanceCreditSpecificationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstanceEventNotificationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstanceEventNotificationAttributesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInstanceEventNotificationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstanceEventNotificationAttributesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstanceEventWindowsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstanceEventWindowsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInstanceEventWindowsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstanceEventWindowsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstanceStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstanceStatusCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInstanceStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstanceStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstanceTypeOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstanceTypeOfferingsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInstanceTypeOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstanceTypeOfferingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInstanceTypesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInstanceTypesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInstanceTypesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInstanceTypesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeInternetGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeInternetGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeInternetGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeInternetGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeIpamPoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeIpamPoolsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeIpamPoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeIpamPoolsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeIpamsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeIpamsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeIpamsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeIpamsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeIpamScopesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeIpamScopesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeIpamScopesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeIpamScopesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeIpv6PoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeIpv6PoolsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeIpv6PoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeIpv6PoolsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeKeyPairsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeKeyPairsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeKeyPairsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeKeyPairsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLaunchTemplatesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLaunchTemplatesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLaunchTemplatesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLaunchTemplatesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLaunchTemplateVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLaunchTemplateVersionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLaunchTemplateVersionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLaunchTemplateVersionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLocalGatewayRouteTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLocalGatewayRouteTablesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLocalGatewayRouteTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLocalGatewayRouteTablesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLocalGatewayRouteTableVpcAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLocalGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLocalGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLocalGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLocalGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLocalGatewayVirtualInterfaceGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeLocalGatewayVirtualInterfacesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeLocalGatewayVirtualInterfacesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeManagedPrefixListsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeManagedPrefixListsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeManagedPrefixListsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeManagedPrefixListsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeMovingAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeMovingAddressesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeMovingAddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeMovingAddressesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNatGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNatGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNatGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNatGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkAclsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkAclsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkAclsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkAclsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkInsightsAccessScopeAnalysesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkInsightsAccessScopesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkInsightsAccessScopesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkInsightsAccessScopesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkInsightsAccessScopesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkInsightsAnalysesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkInsightsAnalysesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkInsightsAnalysesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkInsightsAnalysesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkInsightsPathsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkInsightsPathsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkInsightsPathsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkInsightsPathsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkInterfaceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkInterfaceAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkInterfaceAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkInterfaceAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkInterfacePermissionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkInterfacePermissionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkInterfacePermissionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkInterfacePermissionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeNetworkInterfacesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeNetworkInterfacesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeNetworkInterfacesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeNetworkInterfacesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribePlacementGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribePlacementGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribePlacementGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribePlacementGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribePrefixListsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribePrefixListsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribePrefixListsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribePrefixListsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribePrincipalIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribePrincipalIdFormatCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribePrincipalIdFormatResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribePrincipalIdFormatCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribePublicIpv4PoolsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribePublicIpv4PoolsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribePublicIpv4PoolsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribePublicIpv4PoolsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeRegionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeRegionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeRegionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeRegionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeReplaceRootVolumeTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeReplaceRootVolumeTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeReplaceRootVolumeTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeReplaceRootVolumeTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeReservedInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeReservedInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeReservedInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeReservedInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeReservedInstancesListingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeReservedInstancesListingsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeReservedInstancesListingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeReservedInstancesListingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeReservedInstancesModificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeReservedInstancesModificationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeReservedInstancesModificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeReservedInstancesModificationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeReservedInstancesOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeReservedInstancesOfferingsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeReservedInstancesOfferingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeReservedInstancesOfferingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeRouteTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeRouteTablesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeRouteTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeRouteTablesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeScheduledInstanceAvailabilityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeScheduledInstanceAvailabilityCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeScheduledInstanceAvailabilityResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeScheduledInstanceAvailabilityCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeScheduledInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeScheduledInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeScheduledInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeScheduledInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSecurityGroupReferencesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSecurityGroupReferencesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSecurityGroupReferencesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSecurityGroupReferencesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSecurityGroupRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSecurityGroupRulesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSecurityGroupRulesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSecurityGroupRulesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSecurityGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSecurityGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSecurityGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSecurityGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSnapshotAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSnapshotAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSnapshotAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSnapshotsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSnapshotsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSnapshotsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSnapshotsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSnapshotTierStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSnapshotTierStatusCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSnapshotTierStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSnapshotTierStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSpotDatafeedSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSpotDatafeedSubscriptionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSpotDatafeedSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSpotDatafeedSubscriptionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSpotFleetInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSpotFleetInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSpotFleetInstancesResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSpotFleetInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSpotFleetRequestHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSpotFleetRequestHistoryCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSpotFleetRequestHistoryResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSpotFleetRequestHistoryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSpotFleetRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSpotFleetRequestsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSpotFleetRequestsResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSpotFleetRequestsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSpotInstanceRequestsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSpotInstanceRequestsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSpotInstanceRequestsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSpotInstanceRequestsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSpotPriceHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSpotPriceHistoryCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSpotPriceHistoryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSpotPriceHistoryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeStaleSecurityGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeStaleSecurityGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeStaleSecurityGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeStaleSecurityGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeStoreImageTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeStoreImageTasksCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeStoreImageTasksResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeStoreImageTasksCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeSubnetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeSubnetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeSubnetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeSubnetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTagsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTagsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTagsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTagsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTrafficMirrorFiltersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTrafficMirrorFiltersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTrafficMirrorFiltersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTrafficMirrorFiltersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTrafficMirrorSessionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTrafficMirrorSessionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTrafficMirrorSessionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTrafficMirrorSessionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTrafficMirrorTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTrafficMirrorTargetsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTrafficMirrorTargetsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTrafficMirrorTargetsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayAttachmentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayAttachmentsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayAttachmentsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayAttachmentsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayConnectPeersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayConnectPeersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayConnectPeersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayConnectPeersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayConnectsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayConnectsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayConnectsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayConnectsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayMulticastDomainsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayMulticastDomainsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayMulticastDomainsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayMulticastDomainsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayPeeringAttachmentsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayPeeringAttachmentsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayPolicyTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayPolicyTablesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayPolicyTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayPolicyTablesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayRouteTableAnnouncementsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayRouteTableAnnouncementsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayRouteTableAnnouncementsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayRouteTableAnnouncementsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayRouteTablesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayRouteTablesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayRouteTablesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayRouteTablesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTransitGatewayVpcAttachmentsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTransitGatewayVpcAttachmentsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeTrunkInterfaceAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeTrunkInterfaceAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeTrunkInterfaceAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeTrunkInterfaceAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVerifiedAccessEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVerifiedAccessEndpointsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVerifiedAccessEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVerifiedAccessEndpointsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVerifiedAccessGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVerifiedAccessGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVerifiedAccessGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVerifiedAccessGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVerifiedAccessInstanceLoggingConfigurationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVerifiedAccessInstanceLoggingConfigurationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVerifiedAccessInstanceLoggingConfigurationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVerifiedAccessInstanceLoggingConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVerifiedAccessInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVerifiedAccessInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVerifiedAccessInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVerifiedAccessInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVerifiedAccessTrustProvidersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVerifiedAccessTrustProvidersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVerifiedAccessTrustProvidersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVerifiedAccessTrustProvidersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVolumeAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVolumeAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVolumeAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVolumeAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVolumesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVolumesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVolumesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVolumesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVolumesModificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVolumesModificationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVolumesModificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVolumesModificationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVolumeStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVolumeStatusCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVolumeStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVolumeStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcClassicLinkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcClassicLinkCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcClassicLinkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcClassicLinkCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcClassicLinkDnsSupportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcClassicLinkDnsSupportCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcClassicLinkDnsSupportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcClassicLinkDnsSupportCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcEndpointConnectionNotificationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcEndpointConnectionNotificationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcEndpointConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcEndpointConnectionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcEndpointConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcEndpointConnectionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcEndpointsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcEndpointsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcEndpointsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcEndpointServiceConfigurationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcEndpointServiceConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcEndpointServicePermissionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcEndpointServicePermissionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcEndpointServicePermissionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcEndpointServicePermissionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcEndpointServicesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcEndpointServicesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcEndpointServicesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcEndpointServicesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcPeeringConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcPeeringConnectionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcPeeringConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcPeeringConnectionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpcsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpcsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpcsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpcsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpnConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpnConnectionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpnConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpnConnectionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DescribeVpnGatewaysCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DescribeVpnGatewaysCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DescribeVpnGatewaysResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DescribeVpnGatewaysCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DetachClassicLinkVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DetachClassicLinkVpcCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DetachClassicLinkVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DetachClassicLinkVpcCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DetachInternetGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DetachInternetGatewayCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DetachInternetGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DetachNetworkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DetachNetworkInterfaceCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DetachNetworkInterfaceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DetachVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DetachVerifiedAccessTrustProviderCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DetachVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DetachVerifiedAccessTrustProviderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DetachVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DetachVolumeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2VolumeAttachment(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DetachVolumeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DetachVpnGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DetachVpnGatewayCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DetachVpnGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableAddressTransferCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableAddressTransferCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableAddressTransferResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableAddressTransferCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableAwsNetworkPerformanceMetricSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableAwsNetworkPerformanceMetricSubscriptionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableAwsNetworkPerformanceMetricSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableAwsNetworkPerformanceMetricSubscriptionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableEbsEncryptionByDefaultCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableEbsEncryptionByDefaultCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableEbsEncryptionByDefaultResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableEbsEncryptionByDefaultCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableFastLaunchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableFastLaunchCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableFastLaunchResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableFastLaunchCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableFastSnapshotRestoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableFastSnapshotRestoresCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableFastSnapshotRestoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableFastSnapshotRestoresCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableImageDeprecationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableImageDeprecationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableImageDeprecationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableImageDeprecationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableIpamOrganizationAdminAccountCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableIpamOrganizationAdminAccountCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableIpamOrganizationAdminAccountResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableIpamOrganizationAdminAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableSerialConsoleAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableSerialConsoleAccessCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableSerialConsoleAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableSerialConsoleAccessCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableTransitGatewayRouteTablePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableTransitGatewayRouteTablePropagationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableTransitGatewayRouteTablePropagationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableTransitGatewayRouteTablePropagationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableVgwRoutePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableVgwRoutePropagationCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableVgwRoutePropagationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableVpcClassicLinkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableVpcClassicLinkCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableVpcClassicLinkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableVpcClassicLinkCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisableVpcClassicLinkDnsSupportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisableVpcClassicLinkDnsSupportCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisableVpcClassicLinkDnsSupportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisableVpcClassicLinkDnsSupportCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateAddressCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateAddressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateClientVpnTargetNetworkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateClientVpnTargetNetworkCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateClientVpnTargetNetworkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateClientVpnTargetNetworkCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateEnclaveCertificateIamRoleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateEnclaveCertificateIamRoleCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateEnclaveCertificateIamRoleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateEnclaveCertificateIamRoleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateIamInstanceProfileCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateIamInstanceProfileCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateIamInstanceProfileResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateIamInstanceProfileCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateInstanceEventWindowCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateInstanceEventWindowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateRouteTableCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateSubnetCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateSubnetCidrBlockCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateSubnetCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateSubnetCidrBlockCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateTransitGatewayMulticastDomainCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateTransitGatewayMulticastDomainCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateTransitGatewayMulticastDomainResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateTransitGatewayMulticastDomainCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateTransitGatewayPolicyTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateTransitGatewayPolicyTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateTransitGatewayPolicyTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateTransitGatewayPolicyTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateTransitGatewayRouteTableCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateTransitGatewayRouteTableCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateTransitGatewayRouteTableResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateTransitGatewayRouteTableCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateTrunkInterfaceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateTrunkInterfaceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateTrunkInterfaceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateTrunkInterfaceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2DisassociateVpcCidrBlockCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2DisassociateVpcCidrBlockCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2DisassociateVpcCidrBlockResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2DisassociateVpcCidrBlockCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableAddressTransferCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableAddressTransferCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableAddressTransferResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableAddressTransferCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableAwsNetworkPerformanceMetricSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableAwsNetworkPerformanceMetricSubscriptionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableAwsNetworkPerformanceMetricSubscriptionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableAwsNetworkPerformanceMetricSubscriptionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableEbsEncryptionByDefaultCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableEbsEncryptionByDefaultCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableEbsEncryptionByDefaultResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableEbsEncryptionByDefaultCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableFastLaunchCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableFastLaunchCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableFastLaunchResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableFastLaunchCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableFastSnapshotRestoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableFastSnapshotRestoresCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableFastSnapshotRestoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableFastSnapshotRestoresCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableImageDeprecationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableImageDeprecationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableImageDeprecationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableImageDeprecationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableIpamOrganizationAdminAccountCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableIpamOrganizationAdminAccountCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableIpamOrganizationAdminAccountResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableIpamOrganizationAdminAccountCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableReachabilityAnalyzerOrganizationSharingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableReachabilityAnalyzerOrganizationSharingCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableReachabilityAnalyzerOrganizationSharingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableReachabilityAnalyzerOrganizationSharingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableSerialConsoleAccessCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableSerialConsoleAccessCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableSerialConsoleAccessResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableSerialConsoleAccessCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableTransitGatewayRouteTablePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableTransitGatewayRouteTablePropagationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableTransitGatewayRouteTablePropagationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableTransitGatewayRouteTablePropagationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableVgwRoutePropagationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableVgwRoutePropagationCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableVgwRoutePropagationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableVolumeIOCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableVolumeIOCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableVolumeIOCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableVpcClassicLinkCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableVpcClassicLinkCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableVpcClassicLinkResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableVpcClassicLinkCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2EnableVpcClassicLinkDnsSupportCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2EnableVpcClassicLinkDnsSupportCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2EnableVpcClassicLinkDnsSupportResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2EnableVpcClassicLinkDnsSupportCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ExportClientVpnClientCertificateRevocationListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ExportClientVpnClientCertificateRevocationListCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ExportClientVpnClientCertificateRevocationListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ExportClientVpnClientCertificateRevocationListCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ExportClientVpnClientConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ExportClientVpnClientConfigurationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ExportClientVpnClientConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ExportClientVpnClientConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ExportImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ExportImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ExportImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ExportImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ExportTransitGatewayRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ExportTransitGatewayRoutesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ExportTransitGatewayRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ExportTransitGatewayRoutesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetAssociatedEnclaveCertificateIamRolesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetAssociatedEnclaveCertificateIamRolesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetAssociatedIpv6PoolCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetAssociatedIpv6PoolCidrsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetAssociatedIpv6PoolCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetAssociatedIpv6PoolCidrsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetAwsNetworkPerformanceDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetAwsNetworkPerformanceDataCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetAwsNetworkPerformanceDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetAwsNetworkPerformanceDataCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetCapacityReservationUsageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetCapacityReservationUsageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetCapacityReservationUsageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetCapacityReservationUsageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetCoipPoolUsageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetCoipPoolUsageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetCoipPoolUsageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetCoipPoolUsageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetConsoleOutputCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetConsoleOutputCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetConsoleOutputResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetConsoleOutputCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetConsoleScreenshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetConsoleScreenshotCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetConsoleScreenshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetConsoleScreenshotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetDefaultCreditSpecificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetDefaultCreditSpecificationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetDefaultCreditSpecificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetDefaultCreditSpecificationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetEbsDefaultKmsKeyIdCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetEbsDefaultKmsKeyIdCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetEbsDefaultKmsKeyIdResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetEbsDefaultKmsKeyIdCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetEbsEncryptionByDefaultCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetEbsEncryptionByDefaultCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetEbsEncryptionByDefaultResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetEbsEncryptionByDefaultCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetFlowLogsIntegrationTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetFlowLogsIntegrationTemplateCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetFlowLogsIntegrationTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetFlowLogsIntegrationTemplateCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetGroupsForCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetGroupsForCapacityReservationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetGroupsForCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetGroupsForCapacityReservationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetHostReservationPurchasePreviewCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetHostReservationPurchasePreviewCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetHostReservationPurchasePreviewResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetHostReservationPurchasePreviewCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetInstanceTypesFromInstanceRequirementsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetInstanceTypesFromInstanceRequirementsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetInstanceUefiDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetInstanceUefiDataCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetInstanceUefiDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetInstanceUefiDataCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetIpamAddressHistoryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetIpamAddressHistoryCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetIpamAddressHistoryResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetIpamAddressHistoryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetIpamPoolAllocationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetIpamPoolAllocationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetIpamPoolAllocationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetIpamPoolAllocationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetIpamPoolCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetIpamPoolCidrsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetIpamPoolCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetIpamPoolCidrsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetIpamResourceCidrsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetIpamResourceCidrsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetIpamResourceCidrsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetIpamResourceCidrsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetLaunchTemplateDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetLaunchTemplateDataCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetLaunchTemplateDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetLaunchTemplateDataCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetManagedPrefixListAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetManagedPrefixListAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetManagedPrefixListAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetManagedPrefixListAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetManagedPrefixListEntriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetManagedPrefixListEntriesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetManagedPrefixListEntriesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetManagedPrefixListEntriesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetNetworkInsightsAccessScopeAnalysisFindingsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetNetworkInsightsAccessScopeContentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetNetworkInsightsAccessScopeContentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetNetworkInsightsAccessScopeContentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetNetworkInsightsAccessScopeContentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetPasswordDataCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetPasswordDataCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetPasswordDataResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetPasswordDataCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetReservedInstancesExchangeQuoteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetReservedInstancesExchangeQuoteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetReservedInstancesExchangeQuoteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetReservedInstancesExchangeQuoteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetSerialConsoleAccessStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetSerialConsoleAccessStatusCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetSerialConsoleAccessStatusResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetSerialConsoleAccessStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetSpotPlacementScoresCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetSpotPlacementScoresCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetSpotPlacementScoresResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetSpotPlacementScoresCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetSubnetCidrReservationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetSubnetCidrReservationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetSubnetCidrReservationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetSubnetCidrReservationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetTransitGatewayAttachmentPropagationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetTransitGatewayAttachmentPropagationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetTransitGatewayAttachmentPropagationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetTransitGatewayAttachmentPropagationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetTransitGatewayMulticastDomainAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetTransitGatewayMulticastDomainAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetTransitGatewayPolicyTableAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetTransitGatewayPolicyTableAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetTransitGatewayPolicyTableAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetTransitGatewayPolicyTableAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetTransitGatewayPolicyTableEntriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetTransitGatewayPolicyTableEntriesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetTransitGatewayPolicyTableEntriesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetTransitGatewayPolicyTableEntriesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetTransitGatewayPrefixListReferencesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetTransitGatewayPrefixListReferencesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetTransitGatewayPrefixListReferencesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetTransitGatewayPrefixListReferencesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetTransitGatewayRouteTableAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetTransitGatewayRouteTableAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetTransitGatewayRouteTableAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetTransitGatewayRouteTableAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetTransitGatewayRouteTablePropagationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetTransitGatewayRouteTablePropagationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetTransitGatewayRouteTablePropagationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetTransitGatewayRouteTablePropagationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetVerifiedAccessEndpointPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetVerifiedAccessEndpointPolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetVerifiedAccessEndpointPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetVerifiedAccessEndpointPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetVerifiedAccessGroupPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetVerifiedAccessGroupPolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetVerifiedAccessGroupPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetVerifiedAccessGroupPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetVpnConnectionDeviceSampleConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2GetVpnConnectionDeviceTypesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2GetVpnConnectionDeviceTypesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2GetVpnConnectionDeviceTypesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2GetVpnConnectionDeviceTypesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ImportClientVpnClientCertificateRevocationListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ImportClientVpnClientCertificateRevocationListCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ImportClientVpnClientCertificateRevocationListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ImportClientVpnClientCertificateRevocationListCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ImportImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ImportImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ImportImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ImportImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ImportInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ImportInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ImportInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ImportInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ImportKeyPairCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ImportKeyPairCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ImportKeyPairResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ImportKeyPairCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ImportSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ImportSnapshotCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ImportSnapshotResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ImportSnapshotCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ImportVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ImportVolumeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ImportVolumeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ImportVolumeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ListImagesInRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ListImagesInRecycleBinCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ListImagesInRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ListImagesInRecycleBinCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ListSnapshotsInRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ListSnapshotsInRecycleBinCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ListSnapshotsInRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ListSnapshotsInRecycleBinCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyAddressAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyAddressAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyAddressAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyAddressAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyAvailabilityZoneGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyAvailabilityZoneGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyAvailabilityZoneGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyAvailabilityZoneGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyCapacityReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyCapacityReservationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyCapacityReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyCapacityReservationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyCapacityReservationFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyCapacityReservationFleetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyCapacityReservationFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyCapacityReservationFleetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyClientVpnEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyClientVpnEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyClientVpnEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyClientVpnEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyDefaultCreditSpecificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyDefaultCreditSpecificationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyDefaultCreditSpecificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyDefaultCreditSpecificationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyEbsDefaultKmsKeyIdCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyEbsDefaultKmsKeyIdCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyEbsDefaultKmsKeyIdResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyEbsDefaultKmsKeyIdCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyFleetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyFleetResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyFleetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyFpgaImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyFpgaImageAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyFpgaImageAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyFpgaImageAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyHostsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyHostsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyIdentityIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyIdentityIdFormatCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyIdentityIdFormatCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyIdFormatCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyIdFormatCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyIdFormatCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyImageAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyImageAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstanceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstanceAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstanceAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstanceCapacityReservationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstanceCapacityReservationAttributesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyInstanceCapacityReservationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstanceCapacityReservationAttributesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstanceCreditSpecificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstanceCreditSpecificationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyInstanceCreditSpecificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstanceCreditSpecificationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstanceEventStartTimeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstanceEventStartTimeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyInstanceEventStartTimeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstanceEventStartTimeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstanceEventWindowCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstanceEventWindowCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyInstanceEventWindowResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstanceEventWindowCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstanceMaintenanceOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstanceMaintenanceOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyInstanceMaintenanceOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstanceMaintenanceOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstanceMetadataOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstanceMetadataOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyInstanceMetadataOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstanceMetadataOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyInstancePlacementCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyInstancePlacementCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyInstancePlacementResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyInstancePlacementCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyIpamCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyIpamCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyIpamPoolCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyIpamPoolCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyIpamPoolResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyIpamPoolCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyIpamResourceCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyIpamResourceCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyIpamResourceCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyIpamResourceCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyIpamScopeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyIpamScopeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyIpamScopeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyIpamScopeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyLaunchTemplateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyLaunchTemplateCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyLaunchTemplateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyLaunchTemplateCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyLocalGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyLocalGatewayRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyLocalGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyLocalGatewayRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyManagedPrefixListCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyManagedPrefixListCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyManagedPrefixListResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyManagedPrefixListCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyNetworkInterfaceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyNetworkInterfaceAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyNetworkInterfaceAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyPrivateDnsNameOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyPrivateDnsNameOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyPrivateDnsNameOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyPrivateDnsNameOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyReservedInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyReservedInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyReservedInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyReservedInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifySecurityGroupRulesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifySecurityGroupRulesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifySecurityGroupRulesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifySecurityGroupRulesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifySnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifySnapshotAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifySnapshotAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifySnapshotTierCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifySnapshotTierCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifySnapshotTierResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifySnapshotTierCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifySpotFleetRequestCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifySpotFleetRequestCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifySpotFleetRequestResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifySpotFleetRequestCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifySubnetAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifySubnetAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifySubnetAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyTrafficMirrorFilterNetworkServicesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyTrafficMirrorFilterNetworkServicesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyTrafficMirrorFilterNetworkServicesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyTrafficMirrorFilterNetworkServicesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyTrafficMirrorFilterRuleCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyTrafficMirrorFilterRuleCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyTrafficMirrorFilterRuleResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyTrafficMirrorFilterRuleCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyTrafficMirrorSessionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyTrafficMirrorSessionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyTrafficMirrorSessionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyTrafficMirrorSessionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyTransitGatewayCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyTransitGatewayCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyTransitGatewayResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyTransitGatewayCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyTransitGatewayPrefixListReferenceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyTransitGatewayPrefixListReferenceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyTransitGatewayVpcAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyTransitGatewayVpcAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVerifiedAccessEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVerifiedAccessEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVerifiedAccessEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVerifiedAccessEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVerifiedAccessEndpointPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVerifiedAccessEndpointPolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVerifiedAccessEndpointPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVerifiedAccessEndpointPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVerifiedAccessGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVerifiedAccessGroupCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVerifiedAccessGroupResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVerifiedAccessGroupCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVerifiedAccessGroupPolicyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVerifiedAccessGroupPolicyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVerifiedAccessGroupPolicyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVerifiedAccessGroupPolicyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVerifiedAccessInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVerifiedAccessInstanceCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVerifiedAccessInstanceResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVerifiedAccessInstanceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVerifiedAccessInstanceLoggingConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVerifiedAccessInstanceLoggingConfigurationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVerifiedAccessInstanceLoggingConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVerifiedAccessInstanceLoggingConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVerifiedAccessTrustProviderCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVerifiedAccessTrustProviderCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVerifiedAccessTrustProviderResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVerifiedAccessTrustProviderCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVolumeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVolumeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVolumeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVolumeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVolumeAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVolumeAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVolumeAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcEndpointCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpcEndpointResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcEndpointCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcEndpointConnectionNotificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcEndpointConnectionNotificationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpcEndpointConnectionNotificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcEndpointConnectionNotificationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcEndpointServiceConfigurationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcEndpointServiceConfigurationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpcEndpointServiceConfigurationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcEndpointServiceConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcEndpointServicePayerResponsibilityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcEndpointServicePayerResponsibilityCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpcEndpointServicePayerResponsibilityResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcEndpointServicePayerResponsibilityCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcEndpointServicePermissionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcEndpointServicePermissionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpcEndpointServicePermissionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcEndpointServicePermissionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcPeeringConnectionOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcPeeringConnectionOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpcPeeringConnectionOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcPeeringConnectionOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpcTenancyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpcTenancyCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpcTenancyResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpcTenancyCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpnConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpnConnectionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpnConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpnConnectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpnConnectionOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpnConnectionOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpnConnectionOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpnConnectionOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpnTunnelCertificateCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpnTunnelCertificateCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpnTunnelCertificateResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpnTunnelCertificateCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ModifyVpnTunnelOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ModifyVpnTunnelOptionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ModifyVpnTunnelOptionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ModifyVpnTunnelOptionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2MonitorInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2MonitorInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2MonitorInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2MonitorInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2MoveAddressToVpcCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2MoveAddressToVpcCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2MoveAddressToVpcResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2MoveAddressToVpcCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2MoveByoipCidrToIpamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2MoveByoipCidrToIpamCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2MoveByoipCidrToIpamResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2MoveByoipCidrToIpamCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ProvisionByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ProvisionByoipCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ProvisionByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ProvisionByoipCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ProvisionIpamPoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ProvisionIpamPoolCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ProvisionIpamPoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ProvisionIpamPoolCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ProvisionPublicIpv4PoolCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ProvisionPublicIpv4PoolCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ProvisionPublicIpv4PoolCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ProvisionPublicIpv4PoolCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2PurchaseHostReservationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2PurchaseHostReservationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2PurchaseHostReservationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2PurchaseHostReservationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2PurchaseReservedInstancesOfferingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2PurchaseReservedInstancesOfferingCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2PurchaseReservedInstancesOfferingResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2PurchaseReservedInstancesOfferingCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2PurchaseScheduledInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2PurchaseScheduledInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2PurchaseScheduledInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2PurchaseScheduledInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RebootInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RebootInstancesCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RebootInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RegisterImageCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RegisterImageCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RegisterImageResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RegisterImageCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RegisterInstanceEventNotificationAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RegisterInstanceEventNotificationAttributesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RegisterInstanceEventNotificationAttributesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RegisterInstanceEventNotificationAttributesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RegisterTransitGatewayMulticastGroupMembersResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RegisterTransitGatewayMulticastGroupSourcesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RejectTransitGatewayMulticastDomainAssociationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RejectTransitGatewayPeeringAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RejectTransitGatewayPeeringAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RejectTransitGatewayPeeringAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RejectTransitGatewayPeeringAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RejectTransitGatewayVpcAttachmentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RejectTransitGatewayVpcAttachmentCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RejectTransitGatewayVpcAttachmentResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RejectTransitGatewayVpcAttachmentCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RejectVpcEndpointConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RejectVpcEndpointConnectionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RejectVpcEndpointConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RejectVpcEndpointConnectionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RejectVpcPeeringConnectionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RejectVpcPeeringConnectionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RejectVpcPeeringConnectionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RejectVpcPeeringConnectionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReleaseAddressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReleaseAddressCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReleaseAddressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReleaseHostsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReleaseHostsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ReleaseHostsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReleaseHostsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReleaseIpamPoolAllocationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReleaseIpamPoolAllocationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ReleaseIpamPoolAllocationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReleaseIpamPoolAllocationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReplaceIamInstanceProfileAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReplaceIamInstanceProfileAssociationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ReplaceIamInstanceProfileAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReplaceIamInstanceProfileAssociationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReplaceNetworkAclAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReplaceNetworkAclAssociationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ReplaceNetworkAclAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReplaceNetworkAclAssociationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReplaceNetworkAclEntryCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReplaceNetworkAclEntryCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReplaceNetworkAclEntryCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReplaceRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReplaceRouteCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReplaceRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReplaceRouteTableAssociationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReplaceRouteTableAssociationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ReplaceRouteTableAssociationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReplaceRouteTableAssociationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReplaceTransitGatewayRouteCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReplaceTransitGatewayRouteCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ReplaceTransitGatewayRouteResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReplaceTransitGatewayRouteCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ReportInstanceStatusCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ReportInstanceStatusCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ReportInstanceStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RequestSpotFleetCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RequestSpotFleetCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RequestSpotFleetResponse(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RequestSpotFleetCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RequestSpotInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RequestSpotInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RequestSpotInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RequestSpotInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ResetAddressAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ResetAddressAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ResetAddressAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ResetAddressAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ResetEbsDefaultKmsKeyIdCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ResetEbsDefaultKmsKeyIdCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ResetEbsDefaultKmsKeyIdResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ResetEbsDefaultKmsKeyIdCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ResetFpgaImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ResetFpgaImageAttributeCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2ResetFpgaImageAttributeResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ResetFpgaImageAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ResetImageAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ResetImageAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ResetImageAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ResetInstanceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ResetInstanceAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ResetInstanceAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ResetNetworkInterfaceAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ResetNetworkInterfaceAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ResetNetworkInterfaceAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2ResetSnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2ResetSnapshotAttributeCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2ResetSnapshotAttributeCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RestoreAddressToClassicCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RestoreAddressToClassicCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RestoreAddressToClassicResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RestoreAddressToClassicCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RestoreImageFromRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RestoreImageFromRecycleBinCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RestoreImageFromRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RestoreImageFromRecycleBinCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RestoreManagedPrefixListVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RestoreManagedPrefixListVersionCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RestoreManagedPrefixListVersionResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RestoreManagedPrefixListVersionCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RestoreSnapshotFromRecycleBinCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RestoreSnapshotFromRecycleBinCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RestoreSnapshotFromRecycleBinResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RestoreSnapshotFromRecycleBinCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RestoreSnapshotTierCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RestoreSnapshotTierCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RestoreSnapshotTierResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RestoreSnapshotTierCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RevokeClientVpnIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RevokeClientVpnIngressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RevokeClientVpnIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RevokeClientVpnIngressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RevokeSecurityGroupEgressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RevokeSecurityGroupEgressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RevokeSecurityGroupEgressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RevokeSecurityGroupEgressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RevokeSecurityGroupIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RevokeSecurityGroupIngressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RevokeSecurityGroupIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RevokeSecurityGroupIngressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RunInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RunInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2Reservation(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RunInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2RunScheduledInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2RunScheduledInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2RunScheduledInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2RunScheduledInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2SearchLocalGatewayRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2SearchLocalGatewayRoutesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2SearchLocalGatewayRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2SearchLocalGatewayRoutesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2SearchTransitGatewayMulticastGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2SearchTransitGatewayMulticastGroupsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2SearchTransitGatewayMulticastGroupsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2SearchTransitGatewayMulticastGroupsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2SearchTransitGatewayRoutesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2SearchTransitGatewayRoutesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2SearchTransitGatewayRoutesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2SearchTransitGatewayRoutesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2SendDiagnosticInterruptCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2SendDiagnosticInterruptCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2SendDiagnosticInterruptCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2StartInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2StartInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2StartInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2StartInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2StartNetworkInsightsAccessScopeAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2StartNetworkInsightsAccessScopeAnalysisCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2StartNetworkInsightsAnalysisCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2StartNetworkInsightsAnalysisCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2StartNetworkInsightsAnalysisResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2StartNetworkInsightsAnalysisCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2StartVpcEndpointServicePrivateDnsVerificationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2StartVpcEndpointServicePrivateDnsVerificationCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2StartVpcEndpointServicePrivateDnsVerificationResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2StartVpcEndpointServicePrivateDnsVerificationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2StopInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2StopInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2StopInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2StopInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2TerminateClientVpnConnectionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2TerminateClientVpnConnectionsCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2TerminateClientVpnConnectionsResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2TerminateClientVpnConnectionsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2TerminateInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2TerminateInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2TerminateInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2TerminateInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2UnassignIpv6AddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2UnassignIpv6AddressesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2UnassignIpv6AddressesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2UnassignIpv6AddressesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2UnassignPrivateIpAddressesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2UnassignPrivateIpAddressesCommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2UnassignPrivateIpAddressesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2UnmonitorInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2UnmonitorInstancesCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2UnmonitorInstancesResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2UnmonitorInstancesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsEgressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
export const deserializeAws_ec2WithdrawByoipCidrCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return deserializeAws_ec2WithdrawByoipCidrCommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = deserializeAws_ec2WithdrawByoipCidrResult(data, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return Promise.resolve(response);
};
const deserializeAws_ec2WithdrawByoipCidrCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadEc2ErrorCode(output, parsedOutput.body);
    const parsedBody = parsedOutput.body;
    throwDefaultError({
        output,
        parsedBody: parsedBody.Errors.Error,
        exceptionCtor: __BaseException,
        errorCode,
    });
};
const serializeAws_ec2AcceleratorCount = (input, context) => {
    const entries = {};
    if (input.Min != null) {
        entries["Min"] = input.Min;
    }
    if (input.Max != null) {
        entries["Max"] = input.Max;
    }
    return entries;
};
const serializeAws_ec2AcceleratorCountRequest = (input, context) => {
    const entries = {};
    if (input.Min != null) {
        entries["Min"] = input.Min;
    }
    if (input.Max != null) {
        entries["Max"] = input.Max;
    }
    return entries;
};
const serializeAws_ec2AcceleratorManufacturerSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AcceleratorNameSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AcceleratorTotalMemoryMiB = (input, context) => {
    const entries = {};
    if (input.Min != null) {
        entries["Min"] = input.Min;
    }
    if (input.Max != null) {
        entries["Max"] = input.Max;
    }
    return entries;
};
const serializeAws_ec2AcceleratorTotalMemoryMiBRequest = (input, context) => {
    const entries = {};
    if (input.Min != null) {
        entries["Min"] = input.Min;
    }
    if (input.Max != null) {
        entries["Max"] = input.Max;
    }
    return entries;
};
const serializeAws_ec2AcceleratorTypeSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AcceptAddressTransferRequest = (input, context) => {
    const entries = {};
    if (input.Address != null) {
        entries["Address"] = input.Address;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AcceptReservedInstancesExchangeQuoteRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ReservedInstanceIds != null) {
        const memberEntries = serializeAws_ec2ReservedInstanceIdSet(input.ReservedInstanceIds, context);
        if (input.ReservedInstanceIds?.length === 0) {
            entries.ReservedInstanceId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ReservedInstanceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TargetConfigurations != null) {
        const memberEntries = serializeAws_ec2TargetConfigurationRequestSet(input.TargetConfigurations, context);
        if (input.TargetConfigurations?.length === 0) {
            entries.TargetConfiguration = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TargetConfiguration.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AcceptTransitGatewayMulticastDomainAssociationsRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayMulticastDomainId != null) {
        entries["TransitGatewayMulticastDomainId"] = input.TransitGatewayMulticastDomainId;
    }
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.SubnetIds != null) {
        const memberEntries = serializeAws_ec2ValueStringList(input.SubnetIds, context);
        if (input.SubnetIds?.length === 0) {
            entries.SubnetIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AcceptTransitGatewayPeeringAttachmentRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AcceptTransitGatewayVpcAttachmentRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AcceptVpcEndpointConnectionsRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ServiceId != null) {
        entries["ServiceId"] = input.ServiceId;
    }
    if (input.VpcEndpointIds != null) {
        const memberEntries = serializeAws_ec2VpcEndpointIdList(input.VpcEndpointIds, context);
        if (input.VpcEndpointIds?.length === 0) {
            entries.VpcEndpointId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcEndpointId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AcceptVpcPeeringConnectionRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.VpcPeeringConnectionId != null) {
        entries["VpcPeeringConnectionId"] = input.VpcPeeringConnectionId;
    }
    return entries;
};
const serializeAws_ec2AccessScopePathListRequest = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2AccessScopePathRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2AccessScopePathRequest = (input, context) => {
    const entries = {};
    if (input.Source != null) {
        const memberEntries = serializeAws_ec2PathStatementRequest(input.Source, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Source.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Destination != null) {
        const memberEntries = serializeAws_ec2PathStatementRequest(input.Destination, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Destination.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ThroughResources != null) {
        const memberEntries = serializeAws_ec2ThroughResourcesStatementRequestList(input.ThroughResources, context);
        if (input.ThroughResources?.length === 0) {
            entries.ThroughResource = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ThroughResource.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AccountAttributeNameStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AttributeName.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AddIpamOperatingRegion = (input, context) => {
    const entries = {};
    if (input.RegionName != null) {
        entries["RegionName"] = input.RegionName;
    }
    return entries;
};
const serializeAws_ec2AddIpamOperatingRegionSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2AddIpamOperatingRegion(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2AddPrefixListEntries = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2AddPrefixListEntry(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2AddPrefixListEntry = (input, context) => {
    const entries = {};
    if (input.Cidr != null) {
        entries["Cidr"] = input.Cidr;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    return entries;
};
const serializeAws_ec2AdvertiseByoipCidrRequest = (input, context) => {
    const entries = {};
    if (input.Cidr != null) {
        entries["Cidr"] = input.Cidr;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AllocateAddressRequest = (input, context) => {
    const entries = {};
    if (input.Domain != null) {
        entries["Domain"] = input.Domain;
    }
    if (input.Address != null) {
        entries["Address"] = input.Address;
    }
    if (input.PublicIpv4Pool != null) {
        entries["PublicIpv4Pool"] = input.PublicIpv4Pool;
    }
    if (input.NetworkBorderGroup != null) {
        entries["NetworkBorderGroup"] = input.NetworkBorderGroup;
    }
    if (input.CustomerOwnedIpv4Pool != null) {
        entries["CustomerOwnedIpv4Pool"] = input.CustomerOwnedIpv4Pool;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AllocateHostsRequest = (input, context) => {
    const entries = {};
    if (input.AutoPlacement != null) {
        entries["AutoPlacement"] = input.AutoPlacement;
    }
    if (input.AvailabilityZone != null) {
        entries["AvailabilityZone"] = input.AvailabilityZone;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.InstanceType != null) {
        entries["InstanceType"] = input.InstanceType;
    }
    if (input.InstanceFamily != null) {
        entries["InstanceFamily"] = input.InstanceFamily;
    }
    if (input.Quantity != null) {
        entries["Quantity"] = input.Quantity;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.HostRecovery != null) {
        entries["HostRecovery"] = input.HostRecovery;
    }
    if (input.OutpostArn != null) {
        entries["OutpostArn"] = input.OutpostArn;
    }
    return entries;
};
const serializeAws_ec2AllocateIpamPoolCidrRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.IpamPoolId != null) {
        entries["IpamPoolId"] = input.IpamPoolId;
    }
    if (input.Cidr != null) {
        entries["Cidr"] = input.Cidr;
    }
    if (input.NetmaskLength != null) {
        entries["NetmaskLength"] = input.NetmaskLength;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.PreviewNextCidr != null) {
        entries["PreviewNextCidr"] = input.PreviewNextCidr;
    }
    if (input.DisallowedCidrs != null) {
        const memberEntries = serializeAws_ec2IpamPoolAllocationDisallowedCidrs(input.DisallowedCidrs, context);
        if (input.DisallowedCidrs?.length === 0) {
            entries.DisallowedCidr = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DisallowedCidr.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AllocationIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AllocationId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AllocationIds = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AllowedInstanceTypeSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2ApplySecurityGroupsToClientVpnTargetNetworkRequest = (input, context) => {
    const entries = {};
    if (input.ClientVpnEndpointId != null) {
        entries["ClientVpnEndpointId"] = input.ClientVpnEndpointId;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.SecurityGroupIds != null) {
        const memberEntries = serializeAws_ec2ClientVpnSecurityGroupIdSet(input.SecurityGroupIds, context);
        if (input.SecurityGroupIds?.length === 0) {
            entries.SecurityGroupId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2ArchitectureTypeSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2ArnList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AssignIpv6AddressesRequest = (input, context) => {
    const entries = {};
    if (input.Ipv6AddressCount != null) {
        entries["Ipv6AddressCount"] = input.Ipv6AddressCount;
    }
    if (input.Ipv6Addresses != null) {
        const memberEntries = serializeAws_ec2Ipv6AddressList(input.Ipv6Addresses, context);
        if (input.Ipv6Addresses?.length === 0) {
            entries.Ipv6Addresses = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Addresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Ipv6PrefixCount != null) {
        entries["Ipv6PrefixCount"] = input.Ipv6PrefixCount;
    }
    if (input.Ipv6Prefixes != null) {
        const memberEntries = serializeAws_ec2IpPrefixList(input.Ipv6Prefixes, context);
        if (input.Ipv6Prefixes?.length === 0) {
            entries.Ipv6Prefix = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    return entries;
};
const serializeAws_ec2AssignPrivateIpAddressesRequest = (input, context) => {
    const entries = {};
    if (input.AllowReassignment != null) {
        entries["AllowReassignment"] = input.AllowReassignment;
    }
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.PrivateIpAddresses != null) {
        const memberEntries = serializeAws_ec2PrivateIpAddressStringList(input.PrivateIpAddresses, context);
        if (input.PrivateIpAddresses?.length === 0) {
            entries.PrivateIpAddress = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrivateIpAddress.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.SecondaryPrivateIpAddressCount != null) {
        entries["SecondaryPrivateIpAddressCount"] = input.SecondaryPrivateIpAddressCount;
    }
    if (input.Ipv4Prefixes != null) {
        const memberEntries = serializeAws_ec2IpPrefixList(input.Ipv4Prefixes, context);
        if (input.Ipv4Prefixes?.length === 0) {
            entries.Ipv4Prefix = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv4Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Ipv4PrefixCount != null) {
        entries["Ipv4PrefixCount"] = input.Ipv4PrefixCount;
    }
    return entries;
};
const serializeAws_ec2AssociateAddressRequest = (input, context) => {
    const entries = {};
    if (input.AllocationId != null) {
        entries["AllocationId"] = input.AllocationId;
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.PublicIp != null) {
        entries["PublicIp"] = input.PublicIp;
    }
    if (input.AllowReassociation != null) {
        entries["AllowReassociation"] = input.AllowReassociation;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.PrivateIpAddress != null) {
        entries["PrivateIpAddress"] = input.PrivateIpAddress;
    }
    return entries;
};
const serializeAws_ec2AssociateClientVpnTargetNetworkRequest = (input, context) => {
    const entries = {};
    if (input.ClientVpnEndpointId != null) {
        entries["ClientVpnEndpointId"] = input.ClientVpnEndpointId;
    }
    if (input.SubnetId != null) {
        entries["SubnetId"] = input.SubnetId;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AssociateDhcpOptionsRequest = (input, context) => {
    const entries = {};
    if (input.DhcpOptionsId != null) {
        entries["DhcpOptionsId"] = input.DhcpOptionsId;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AssociateEnclaveCertificateIamRoleRequest = (input, context) => {
    const entries = {};
    if (input.CertificateArn != null) {
        entries["CertificateArn"] = input.CertificateArn;
    }
    if (input.RoleArn != null) {
        entries["RoleArn"] = input.RoleArn;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AssociateIamInstanceProfileRequest = (input, context) => {
    const entries = {};
    if (input.IamInstanceProfile != null) {
        const memberEntries = serializeAws_ec2IamInstanceProfileSpecification(input.IamInstanceProfile, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IamInstanceProfile.${key}`;
            entries[loc] = value;
        });
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    return entries;
};
const serializeAws_ec2AssociateInstanceEventWindowRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.InstanceEventWindowId != null) {
        entries["InstanceEventWindowId"] = input.InstanceEventWindowId;
    }
    if (input.AssociationTarget != null) {
        const memberEntries = serializeAws_ec2InstanceEventWindowAssociationRequest(input.AssociationTarget, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AssociationTarget.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AssociateRouteTableRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.RouteTableId != null) {
        entries["RouteTableId"] = input.RouteTableId;
    }
    if (input.SubnetId != null) {
        entries["SubnetId"] = input.SubnetId;
    }
    if (input.GatewayId != null) {
        entries["GatewayId"] = input.GatewayId;
    }
    return entries;
};
const serializeAws_ec2AssociateSubnetCidrBlockRequest = (input, context) => {
    const entries = {};
    if (input.Ipv6CidrBlock != null) {
        entries["Ipv6CidrBlock"] = input.Ipv6CidrBlock;
    }
    if (input.SubnetId != null) {
        entries["SubnetId"] = input.SubnetId;
    }
    return entries;
};
const serializeAws_ec2AssociateTransitGatewayMulticastDomainRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayMulticastDomainId != null) {
        entries["TransitGatewayMulticastDomainId"] = input.TransitGatewayMulticastDomainId;
    }
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.SubnetIds != null) {
        const memberEntries = serializeAws_ec2TransitGatewaySubnetIdList(input.SubnetIds, context);
        if (input.SubnetIds?.length === 0) {
            entries.SubnetIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AssociateTransitGatewayPolicyTableRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayPolicyTableId != null) {
        entries["TransitGatewayPolicyTableId"] = input.TransitGatewayPolicyTableId;
    }
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AssociateTransitGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayRouteTableId != null) {
        entries["TransitGatewayRouteTableId"] = input.TransitGatewayRouteTableId;
    }
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AssociateTrunkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input.BranchInterfaceId != null) {
        entries["BranchInterfaceId"] = input.BranchInterfaceId;
    }
    if (input.TrunkInterfaceId != null) {
        entries["TrunkInterfaceId"] = input.TrunkInterfaceId;
    }
    if (input.VlanId != null) {
        entries["VlanId"] = input.VlanId;
    }
    if (input.GreKey != null) {
        entries["GreKey"] = input.GreKey;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AssociateVpcCidrBlockRequest = (input, context) => {
    const entries = {};
    if (input.AmazonProvidedIpv6CidrBlock != null) {
        entries["AmazonProvidedIpv6CidrBlock"] = input.AmazonProvidedIpv6CidrBlock;
    }
    if (input.CidrBlock != null) {
        entries["CidrBlock"] = input.CidrBlock;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.Ipv6CidrBlockNetworkBorderGroup != null) {
        entries["Ipv6CidrBlockNetworkBorderGroup"] = input.Ipv6CidrBlockNetworkBorderGroup;
    }
    if (input.Ipv6Pool != null) {
        entries["Ipv6Pool"] = input.Ipv6Pool;
    }
    if (input.Ipv6CidrBlock != null) {
        entries["Ipv6CidrBlock"] = input.Ipv6CidrBlock;
    }
    if (input.Ipv4IpamPoolId != null) {
        entries["Ipv4IpamPoolId"] = input.Ipv4IpamPoolId;
    }
    if (input.Ipv4NetmaskLength != null) {
        entries["Ipv4NetmaskLength"] = input.Ipv4NetmaskLength;
    }
    if (input.Ipv6IpamPoolId != null) {
        entries["Ipv6IpamPoolId"] = input.Ipv6IpamPoolId;
    }
    if (input.Ipv6NetmaskLength != null) {
        entries["Ipv6NetmaskLength"] = input.Ipv6NetmaskLength;
    }
    return entries;
};
const serializeAws_ec2AssociationIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AssociationId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2AthenaIntegration = (input, context) => {
    const entries = {};
    if (input.IntegrationResultS3DestinationArn != null) {
        entries["IntegrationResultS3DestinationArn"] = input.IntegrationResultS3DestinationArn;
    }
    if (input.PartitionLoadFrequency != null) {
        entries["PartitionLoadFrequency"] = input.PartitionLoadFrequency;
    }
    if (input.PartitionStartDate != null) {
        entries["PartitionStartDate"] = input.PartitionStartDate.toISOString().split(".")[0] + "Z";
    }
    if (input.PartitionEndDate != null) {
        entries["PartitionEndDate"] = input.PartitionEndDate.toISOString().split(".")[0] + "Z";
    }
    return entries;
};
const serializeAws_ec2AthenaIntegrationsSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2AthenaIntegration(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2AttachClassicLinkVpcRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Groups != null) {
        const memberEntries = serializeAws_ec2GroupIdStringList(input.Groups, context);
        if (input.Groups?.length === 0) {
            entries.SecurityGroupId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    return entries;
};
const serializeAws_ec2AttachInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.InternetGatewayId != null) {
        entries["InternetGatewayId"] = input.InternetGatewayId;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    return entries;
};
const serializeAws_ec2AttachNetworkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input.DeviceIndex != null) {
        entries["DeviceIndex"] = input.DeviceIndex;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.NetworkCardIndex != null) {
        entries["NetworkCardIndex"] = input.NetworkCardIndex;
    }
    if (input.EnaSrdSpecification != null) {
        const memberEntries = serializeAws_ec2EnaSrdSpecification(input.EnaSrdSpecification, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnaSrdSpecification.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AttachVerifiedAccessTrustProviderRequest = (input, context) => {
    const entries = {};
    if (input.VerifiedAccessInstanceId != null) {
        entries["VerifiedAccessInstanceId"] = input.VerifiedAccessInstanceId;
    }
    if (input.VerifiedAccessTrustProviderId != null) {
        entries["VerifiedAccessTrustProviderId"] = input.VerifiedAccessTrustProviderId;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AttachVolumeRequest = (input, context) => {
    const entries = {};
    if (input.Device != null) {
        entries["Device"] = input.Device;
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.VolumeId != null) {
        entries["VolumeId"] = input.VolumeId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AttachVpnGatewayRequest = (input, context) => {
    const entries = {};
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.VpnGatewayId != null) {
        entries["VpnGatewayId"] = input.VpnGatewayId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AttributeBooleanValue = (input, context) => {
    const entries = {};
    if (input.Value != null) {
        entries["Value"] = input.Value;
    }
    return entries;
};
const serializeAws_ec2AttributeValue = (input, context) => {
    const entries = {};
    if (input.Value != null) {
        entries["Value"] = input.Value;
    }
    return entries;
};
const serializeAws_ec2AuthorizeClientVpnIngressRequest = (input, context) => {
    const entries = {};
    if (input.ClientVpnEndpointId != null) {
        entries["ClientVpnEndpointId"] = input.ClientVpnEndpointId;
    }
    if (input.TargetNetworkCidr != null) {
        entries["TargetNetworkCidr"] = input.TargetNetworkCidr;
    }
    if (input.AccessGroupId != null) {
        entries["AccessGroupId"] = input.AccessGroupId;
    }
    if (input.AuthorizeAllGroups != null) {
        entries["AuthorizeAllGroups"] = input.AuthorizeAllGroups;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2AuthorizeSecurityGroupEgressRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.GroupId != null) {
        entries["GroupId"] = input.GroupId;
    }
    if (input.IpPermissions != null) {
        const memberEntries = serializeAws_ec2IpPermissionList(input.IpPermissions, context);
        if (input.IpPermissions?.length === 0) {
            entries.IpPermissions = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpPermissions.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.CidrIp != null) {
        entries["CidrIp"] = input.CidrIp;
    }
    if (input.FromPort != null) {
        entries["FromPort"] = input.FromPort;
    }
    if (input.IpProtocol != null) {
        entries["IpProtocol"] = input.IpProtocol;
    }
    if (input.ToPort != null) {
        entries["ToPort"] = input.ToPort;
    }
    if (input.SourceSecurityGroupName != null) {
        entries["SourceSecurityGroupName"] = input.SourceSecurityGroupName;
    }
    if (input.SourceSecurityGroupOwnerId != null) {
        entries["SourceSecurityGroupOwnerId"] = input.SourceSecurityGroupOwnerId;
    }
    return entries;
};
const serializeAws_ec2AuthorizeSecurityGroupIngressRequest = (input, context) => {
    const entries = {};
    if (input.CidrIp != null) {
        entries["CidrIp"] = input.CidrIp;
    }
    if (input.FromPort != null) {
        entries["FromPort"] = input.FromPort;
    }
    if (input.GroupId != null) {
        entries["GroupId"] = input.GroupId;
    }
    if (input.GroupName != null) {
        entries["GroupName"] = input.GroupName;
    }
    if (input.IpPermissions != null) {
        const memberEntries = serializeAws_ec2IpPermissionList(input.IpPermissions, context);
        if (input.IpPermissions?.length === 0) {
            entries.IpPermissions = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `IpPermissions.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.IpProtocol != null) {
        entries["IpProtocol"] = input.IpProtocol;
    }
    if (input.SourceSecurityGroupName != null) {
        entries["SourceSecurityGroupName"] = input.SourceSecurityGroupName;
    }
    if (input.SourceSecurityGroupOwnerId != null) {
        entries["SourceSecurityGroupOwnerId"] = input.SourceSecurityGroupOwnerId;
    }
    if (input.ToPort != null) {
        entries["ToPort"] = input.ToPort;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2AvailabilityZoneStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AvailabilityZone.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2BaselineEbsBandwidthMbps = (input, context) => {
    const entries = {};
    if (input.Min != null) {
        entries["Min"] = input.Min;
    }
    if (input.Max != null) {
        entries["Max"] = input.Max;
    }
    return entries;
};
const serializeAws_ec2BaselineEbsBandwidthMbpsRequest = (input, context) => {
    const entries = {};
    if (input.Min != null) {
        entries["Min"] = input.Min;
    }
    if (input.Max != null) {
        entries["Max"] = input.Max;
    }
    return entries;
};
const serializeAws_ec2BillingProductList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2BlobAttributeValue = (input, context) => {
    const entries = {};
    if (input.Value != null) {
        entries["Value"] = context.base64Encoder(input.Value);
    }
    return entries;
};
const serializeAws_ec2BlockDeviceMapping = (input, context) => {
    const entries = {};
    if (input.DeviceName != null) {
        entries["DeviceName"] = input.DeviceName;
    }
    if (input.VirtualName != null) {
        entries["VirtualName"] = input.VirtualName;
    }
    if (input.Ebs != null) {
        const memberEntries = serializeAws_ec2EbsBlockDevice(input.Ebs, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ebs.${key}`;
            entries[loc] = value;
        });
    }
    if (input.NoDevice != null) {
        entries["NoDevice"] = input.NoDevice;
    }
    return entries;
};
const serializeAws_ec2BlockDeviceMappingList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2BlockDeviceMapping(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2BlockDeviceMappingRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2BlockDeviceMapping(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`BlockDeviceMapping.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2BundleIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`BundleId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2BundleInstanceRequest = (input, context) => {
    const entries = {};
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.Storage != null) {
        const memberEntries = serializeAws_ec2Storage(input.Storage, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Storage.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CancelBundleTaskRequest = (input, context) => {
    const entries = {};
    if (input.BundleId != null) {
        entries["BundleId"] = input.BundleId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CancelCapacityReservationFleetsRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.CapacityReservationFleetIds != null) {
        const memberEntries = serializeAws_ec2CapacityReservationFleetIdSet(input.CapacityReservationFleetIds, context);
        if (input.CapacityReservationFleetIds?.length === 0) {
            entries.CapacityReservationFleetId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationFleetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CancelCapacityReservationRequest = (input, context) => {
    const entries = {};
    if (input.CapacityReservationId != null) {
        entries["CapacityReservationId"] = input.CapacityReservationId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CancelConversionRequest = (input, context) => {
    const entries = {};
    if (input.ConversionTaskId != null) {
        entries["ConversionTaskId"] = input.ConversionTaskId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ReasonMessage != null) {
        entries["ReasonMessage"] = input.ReasonMessage;
    }
    return entries;
};
const serializeAws_ec2CancelExportTaskRequest = (input, context) => {
    const entries = {};
    if (input.ExportTaskId != null) {
        entries["ExportTaskId"] = input.ExportTaskId;
    }
    return entries;
};
const serializeAws_ec2CancelImageLaunchPermissionRequest = (input, context) => {
    const entries = {};
    if (input.ImageId != null) {
        entries["ImageId"] = input.ImageId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CancelImportTaskRequest = (input, context) => {
    const entries = {};
    if (input.CancelReason != null) {
        entries["CancelReason"] = input.CancelReason;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ImportTaskId != null) {
        entries["ImportTaskId"] = input.ImportTaskId;
    }
    return entries;
};
const serializeAws_ec2CancelReservedInstancesListingRequest = (input, context) => {
    const entries = {};
    if (input.ReservedInstancesListingId != null) {
        entries["ReservedInstancesListingId"] = input.ReservedInstancesListingId;
    }
    return entries;
};
const serializeAws_ec2CancelSpotFleetRequestsRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.SpotFleetRequestIds != null) {
        const memberEntries = serializeAws_ec2SpotFleetRequestIdList(input.SpotFleetRequestIds, context);
        if (input.SpotFleetRequestIds?.length === 0) {
            entries.SpotFleetRequestId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotFleetRequestId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TerminateInstances != null) {
        entries["TerminateInstances"] = input.TerminateInstances;
    }
    return entries;
};
const serializeAws_ec2CancelSpotInstanceRequestsRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.SpotInstanceRequestIds != null) {
        const memberEntries = serializeAws_ec2SpotInstanceRequestIdList(input.SpotInstanceRequestIds, context);
        if (input.SpotInstanceRequestIds?.length === 0) {
            entries.SpotInstanceRequestId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotInstanceRequestId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CapacityReservationFleetIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2CapacityReservationIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2CapacityReservationOptionsRequest = (input, context) => {
    const entries = {};
    if (input.UsageStrategy != null) {
        entries["UsageStrategy"] = input.UsageStrategy;
    }
    return entries;
};
const serializeAws_ec2CapacityReservationSpecification = (input, context) => {
    const entries = {};
    if (input.CapacityReservationPreference != null) {
        entries["CapacityReservationPreference"] = input.CapacityReservationPreference;
    }
    if (input.CapacityReservationTarget != null) {
        const memberEntries = serializeAws_ec2CapacityReservationTarget(input.CapacityReservationTarget, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CapacityReservationTarget.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CapacityReservationTarget = (input, context) => {
    const entries = {};
    if (input.CapacityReservationId != null) {
        entries["CapacityReservationId"] = input.CapacityReservationId;
    }
    if (input.CapacityReservationResourceGroupArn != null) {
        entries["CapacityReservationResourceGroupArn"] = input.CapacityReservationResourceGroupArn;
    }
    return entries;
};
const serializeAws_ec2CarrierGatewayIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2CertificateAuthenticationRequest = (input, context) => {
    const entries = {};
    if (input.ClientRootCertificateChainArn != null) {
        entries["ClientRootCertificateChainArn"] = input.ClientRootCertificateChainArn;
    }
    return entries;
};
const serializeAws_ec2CidrAuthorizationContext = (input, context) => {
    const entries = {};
    if (input.Message != null) {
        entries["Message"] = input.Message;
    }
    if (input.Signature != null) {
        entries["Signature"] = input.Signature;
    }
    return entries;
};
const serializeAws_ec2ClassicLoadBalancer = (input, context) => {
    const entries = {};
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    return entries;
};
const serializeAws_ec2ClassicLoadBalancers = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2ClassicLoadBalancer(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2ClassicLoadBalancersConfig = (input, context) => {
    const entries = {};
    if (input.ClassicLoadBalancers != null) {
        const memberEntries = serializeAws_ec2ClassicLoadBalancers(input.ClassicLoadBalancers, context);
        if (input.ClassicLoadBalancers?.length === 0) {
            entries.ClassicLoadBalancers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClassicLoadBalancers.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2ClientConnectOptions = (input, context) => {
    const entries = {};
    if (input.Enabled != null) {
        entries["Enabled"] = input.Enabled;
    }
    if (input.LambdaFunctionArn != null) {
        entries["LambdaFunctionArn"] = input.LambdaFunctionArn;
    }
    return entries;
};
const serializeAws_ec2ClientData = (input, context) => {
    const entries = {};
    if (input.Comment != null) {
        entries["Comment"] = input.Comment;
    }
    if (input.UploadEnd != null) {
        entries["UploadEnd"] = input.UploadEnd.toISOString().split(".")[0] + "Z";
    }
    if (input.UploadSize != null) {
        entries["UploadSize"] = __serializeFloat(input.UploadSize);
    }
    if (input.UploadStart != null) {
        entries["UploadStart"] = input.UploadStart.toISOString().split(".")[0] + "Z";
    }
    return entries;
};
const serializeAws_ec2ClientLoginBannerOptions = (input, context) => {
    const entries = {};
    if (input.Enabled != null) {
        entries["Enabled"] = input.Enabled;
    }
    if (input.BannerText != null) {
        entries["BannerText"] = input.BannerText;
    }
    return entries;
};
const serializeAws_ec2ClientVpnAuthenticationRequest = (input, context) => {
    const entries = {};
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.ActiveDirectory != null) {
        const memberEntries = serializeAws_ec2DirectoryServiceAuthenticationRequest(input.ActiveDirectory, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ActiveDirectory.${key}`;
            entries[loc] = value;
        });
    }
    if (input.MutualAuthentication != null) {
        const memberEntries = serializeAws_ec2CertificateAuthenticationRequest(input.MutualAuthentication, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `MutualAuthentication.${key}`;
            entries[loc] = value;
        });
    }
    if (input.FederatedAuthentication != null) {
        const memberEntries = serializeAws_ec2FederatedAuthenticationRequest(input.FederatedAuthentication, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `FederatedAuthentication.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2ClientVpnAuthenticationRequestList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2ClientVpnAuthenticationRequest(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2ClientVpnEndpointIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2ClientVpnSecurityGroupIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2CloudWatchLogOptionsSpecification = (input, context) => {
    const entries = {};
    if (input.LogEnabled != null) {
        entries["LogEnabled"] = input.LogEnabled;
    }
    if (input.LogGroupArn != null) {
        entries["LogGroupArn"] = input.LogGroupArn;
    }
    if (input.LogOutputFormat != null) {
        entries["LogOutputFormat"] = input.LogOutputFormat;
    }
    return entries;
};
const serializeAws_ec2CoipPoolIdSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2ConfirmProductInstanceRequest = (input, context) => {
    const entries = {};
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.ProductCode != null) {
        entries["ProductCode"] = input.ProductCode;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2ConnectionLogOptions = (input, context) => {
    const entries = {};
    if (input.Enabled != null) {
        entries["Enabled"] = input.Enabled;
    }
    if (input.CloudwatchLogGroup != null) {
        entries["CloudwatchLogGroup"] = input.CloudwatchLogGroup;
    }
    if (input.CloudwatchLogStream != null) {
        entries["CloudwatchLogStream"] = input.CloudwatchLogStream;
    }
    return entries;
};
const serializeAws_ec2ConnectionNotificationIdsList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2ConversionIdStringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2CopyFpgaImageRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.SourceFpgaImageId != null) {
        entries["SourceFpgaImageId"] = input.SourceFpgaImageId;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.SourceRegion != null) {
        entries["SourceRegion"] = input.SourceRegion;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CopyImageRequest = (input, context) => {
    const entries = {};
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.Encrypted != null) {
        entries["Encrypted"] = input.Encrypted;
    }
    if (input.KmsKeyId != null) {
        entries["KmsKeyId"] = input.KmsKeyId;
    }
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.SourceImageId != null) {
        entries["SourceImageId"] = input.SourceImageId;
    }
    if (input.SourceRegion != null) {
        entries["SourceRegion"] = input.SourceRegion;
    }
    if (input.DestinationOutpostArn != null) {
        entries["DestinationOutpostArn"] = input.DestinationOutpostArn;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.CopyImageTags != null) {
        entries["CopyImageTags"] = input.CopyImageTags;
    }
    return entries;
};
const serializeAws_ec2CopySnapshotRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.DestinationOutpostArn != null) {
        entries["DestinationOutpostArn"] = input.DestinationOutpostArn;
    }
    if (input.DestinationRegion != null) {
        entries["DestinationRegion"] = input.DestinationRegion;
    }
    if (input.Encrypted != null) {
        entries["Encrypted"] = input.Encrypted;
    }
    if (input.KmsKeyId != null) {
        entries["KmsKeyId"] = input.KmsKeyId;
    }
    if (input.PresignedUrl != null) {
        entries["PresignedUrl"] = input.PresignedUrl;
    }
    if (input.SourceRegion != null) {
        entries["SourceRegion"] = input.SourceRegion;
    }
    if (input.SourceSnapshotId != null) {
        entries["SourceSnapshotId"] = input.SourceSnapshotId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CpuManufacturerSet = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2CpuOptionsRequest = (input, context) => {
    const entries = {};
    if (input.CoreCount != null) {
        entries["CoreCount"] = input.CoreCount;
    }
    if (input.ThreadsPerCore != null) {
        entries["ThreadsPerCore"] = input.ThreadsPerCore;
    }
    return entries;
};
const serializeAws_ec2CreateCapacityReservationFleetRequest = (input, context) => {
    const entries = {};
    if (input.AllocationStrategy != null) {
        entries["AllocationStrategy"] = input.AllocationStrategy;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.InstanceTypeSpecifications != null) {
        const memberEntries = serializeAws_ec2ReservationFleetInstanceSpecificationList(input.InstanceTypeSpecifications, context);
        if (input.InstanceTypeSpecifications?.length === 0) {
            entries.InstanceTypeSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceTypeSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Tenancy != null) {
        entries["Tenancy"] = input.Tenancy;
    }
    if (input.TotalTargetCapacity != null) {
        entries["TotalTargetCapacity"] = input.TotalTargetCapacity;
    }
    if (input.EndDate != null) {
        entries["EndDate"] = input.EndDate.toISOString().split(".")[0] + "Z";
    }
    if (input.InstanceMatchCriteria != null) {
        entries["InstanceMatchCriteria"] = input.InstanceMatchCriteria;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateCapacityReservationRequest = (input, context) => {
    const entries = {};
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.InstanceType != null) {
        entries["InstanceType"] = input.InstanceType;
    }
    if (input.InstancePlatform != null) {
        entries["InstancePlatform"] = input.InstancePlatform;
    }
    if (input.AvailabilityZone != null) {
        entries["AvailabilityZone"] = input.AvailabilityZone;
    }
    if (input.AvailabilityZoneId != null) {
        entries["AvailabilityZoneId"] = input.AvailabilityZoneId;
    }
    if (input.Tenancy != null) {
        entries["Tenancy"] = input.Tenancy;
    }
    if (input.InstanceCount != null) {
        entries["InstanceCount"] = input.InstanceCount;
    }
    if (input.EbsOptimized != null) {
        entries["EbsOptimized"] = input.EbsOptimized;
    }
    if (input.EphemeralStorage != null) {
        entries["EphemeralStorage"] = input.EphemeralStorage;
    }
    if (input.EndDate != null) {
        entries["EndDate"] = input.EndDate.toISOString().split(".")[0] + "Z";
    }
    if (input.EndDateType != null) {
        entries["EndDateType"] = input.EndDateType;
    }
    if (input.InstanceMatchCriteria != null) {
        entries["InstanceMatchCriteria"] = input.InstanceMatchCriteria;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecifications = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.OutpostArn != null) {
        entries["OutpostArn"] = input.OutpostArn;
    }
    if (input.PlacementGroupArn != null) {
        entries["PlacementGroupArn"] = input.PlacementGroupArn;
    }
    return entries;
};
const serializeAws_ec2CreateCarrierGatewayRequest = (input, context) => {
    const entries = {};
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateClientVpnEndpointRequest = (input, context) => {
    const entries = {};
    if (input.ClientCidrBlock != null) {
        entries["ClientCidrBlock"] = input.ClientCidrBlock;
    }
    if (input.ServerCertificateArn != null) {
        entries["ServerCertificateArn"] = input.ServerCertificateArn;
    }
    if (input.AuthenticationOptions != null) {
        const memberEntries = serializeAws_ec2ClientVpnAuthenticationRequestList(input.AuthenticationOptions, context);
        if (input.AuthenticationOptions?.length === 0) {
            entries.Authentication = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Authentication.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ConnectionLogOptions != null) {
        const memberEntries = serializeAws_ec2ConnectionLogOptions(input.ConnectionLogOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConnectionLogOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DnsServers != null) {
        const memberEntries = serializeAws_ec2ValueStringList(input.DnsServers, context);
        if (input.DnsServers?.length === 0) {
            entries.DnsServers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DnsServers.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TransportProtocol != null) {
        entries["TransportProtocol"] = input.TransportProtocol;
    }
    if (input.VpnPort != null) {
        entries["VpnPort"] = input.VpnPort;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.SplitTunnel != null) {
        entries["SplitTunnel"] = input.SplitTunnel;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.SecurityGroupIds != null) {
        const memberEntries = serializeAws_ec2ClientVpnSecurityGroupIdSet(input.SecurityGroupIds, context);
        if (input.SecurityGroupIds?.length === 0) {
            entries.SecurityGroupId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.SelfServicePortal != null) {
        entries["SelfServicePortal"] = input.SelfServicePortal;
    }
    if (input.ClientConnectOptions != null) {
        const memberEntries = serializeAws_ec2ClientConnectOptions(input.ClientConnectOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientConnectOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.SessionTimeoutHours != null) {
        entries["SessionTimeoutHours"] = input.SessionTimeoutHours;
    }
    if (input.ClientLoginBannerOptions != null) {
        const memberEntries = serializeAws_ec2ClientLoginBannerOptions(input.ClientLoginBannerOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ClientLoginBannerOptions.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateClientVpnRouteRequest = (input, context) => {
    const entries = {};
    if (input.ClientVpnEndpointId != null) {
        entries["ClientVpnEndpointId"] = input.ClientVpnEndpointId;
    }
    if (input.DestinationCidrBlock != null) {
        entries["DestinationCidrBlock"] = input.DestinationCidrBlock;
    }
    if (input.TargetVpcSubnetId != null) {
        entries["TargetVpcSubnetId"] = input.TargetVpcSubnetId;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateCoipCidrRequest = (input, context) => {
    const entries = {};
    if (input.Cidr != null) {
        entries["Cidr"] = input.Cidr;
    }
    if (input.CoipPoolId != null) {
        entries["CoipPoolId"] = input.CoipPoolId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateCoipPoolRequest = (input, context) => {
    const entries = {};
    if (input.LocalGatewayRouteTableId != null) {
        entries["LocalGatewayRouteTableId"] = input.LocalGatewayRouteTableId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateCustomerGatewayRequest = (input, context) => {
    const entries = {};
    if (input.BgpAsn != null) {
        entries["BgpAsn"] = input.BgpAsn;
    }
    if (input.PublicIp != null) {
        entries["PublicIp"] = input.PublicIp;
    }
    if (input.CertificateArn != null) {
        entries["CertificateArn"] = input.CertificateArn;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DeviceName != null) {
        entries["DeviceName"] = input.DeviceName;
    }
    if (input.IpAddress != null) {
        entries["IpAddress"] = input.IpAddress;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateDefaultSubnetRequest = (input, context) => {
    const entries = {};
    if (input.AvailabilityZone != null) {
        entries["AvailabilityZone"] = input.AvailabilityZone;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Ipv6Native != null) {
        entries["Ipv6Native"] = input.Ipv6Native;
    }
    return entries;
};
const serializeAws_ec2CreateDefaultVpcRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateDhcpOptionsRequest = (input, context) => {
    const entries = {};
    if (input.DhcpConfigurations != null) {
        const memberEntries = serializeAws_ec2NewDhcpConfigurationList(input.DhcpConfigurations, context);
        if (input.DhcpConfigurations?.length === 0) {
            entries.DhcpConfiguration = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DhcpConfiguration.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateEgressOnlyInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateFleetRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.SpotOptions != null) {
        const memberEntries = serializeAws_ec2SpotOptionsRequest(input.SpotOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SpotOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OnDemandOptions != null) {
        const memberEntries = serializeAws_ec2OnDemandOptionsRequest(input.OnDemandOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OnDemandOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.ExcessCapacityTerminationPolicy != null) {
        entries["ExcessCapacityTerminationPolicy"] = input.ExcessCapacityTerminationPolicy;
    }
    if (input.LaunchTemplateConfigs != null) {
        const memberEntries = serializeAws_ec2FleetLaunchTemplateConfigListRequest(input.LaunchTemplateConfigs, context);
        if (input.LaunchTemplateConfigs?.length === 0) {
            entries.LaunchTemplateConfigs = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateConfigs.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TargetCapacitySpecification != null) {
        const memberEntries = serializeAws_ec2TargetCapacitySpecificationRequest(input.TargetCapacitySpecification, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TargetCapacitySpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TerminateInstancesWithExpiration != null) {
        entries["TerminateInstancesWithExpiration"] = input.TerminateInstancesWithExpiration;
    }
    if (input.Type != null) {
        entries["Type"] = input.Type;
    }
    if (input.ValidFrom != null) {
        entries["ValidFrom"] = input.ValidFrom.toISOString().split(".")[0] + "Z";
    }
    if (input.ValidUntil != null) {
        entries["ValidUntil"] = input.ValidUntil.toISOString().split(".")[0] + "Z";
    }
    if (input.ReplaceUnhealthyInstances != null) {
        entries["ReplaceUnhealthyInstances"] = input.ReplaceUnhealthyInstances;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Context != null) {
        entries["Context"] = input.Context;
    }
    return entries;
};
const serializeAws_ec2CreateFlowLogsRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DeliverLogsPermissionArn != null) {
        entries["DeliverLogsPermissionArn"] = input.DeliverLogsPermissionArn;
    }
    if (input.DeliverCrossAccountRole != null) {
        entries["DeliverCrossAccountRole"] = input.DeliverCrossAccountRole;
    }
    if (input.LogGroupName != null) {
        entries["LogGroupName"] = input.LogGroupName;
    }
    if (input.ResourceIds != null) {
        const memberEntries = serializeAws_ec2FlowLogResourceIds(input.ResourceIds, context);
        if (input.ResourceIds?.length === 0) {
            entries.ResourceId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ResourceType != null) {
        entries["ResourceType"] = input.ResourceType;
    }
    if (input.TrafficType != null) {
        entries["TrafficType"] = input.TrafficType;
    }
    if (input.LogDestinationType != null) {
        entries["LogDestinationType"] = input.LogDestinationType;
    }
    if (input.LogDestination != null) {
        entries["LogDestination"] = input.LogDestination;
    }
    if (input.LogFormat != null) {
        entries["LogFormat"] = input.LogFormat;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.MaxAggregationInterval != null) {
        entries["MaxAggregationInterval"] = input.MaxAggregationInterval;
    }
    if (input.DestinationOptions != null) {
        const memberEntries = serializeAws_ec2DestinationOptionsRequest(input.DestinationOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DestinationOptions.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateFpgaImageRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.InputStorageLocation != null) {
        const memberEntries = serializeAws_ec2StorageLocation(input.InputStorageLocation, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InputStorageLocation.${key}`;
            entries[loc] = value;
        });
    }
    if (input.LogsStorageLocation != null) {
        const memberEntries = serializeAws_ec2StorageLocation(input.LogsStorageLocation, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LogsStorageLocation.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateImageRequest = (input, context) => {
    const entries = {};
    if (input.BlockDeviceMappings != null) {
        const memberEntries = serializeAws_ec2BlockDeviceMappingRequestList(input.BlockDeviceMappings, context);
        if (input.BlockDeviceMappings?.length === 0) {
            entries.BlockDeviceMapping = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `BlockDeviceMapping.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.NoReboot != null) {
        entries["NoReboot"] = input.NoReboot;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateInstanceEventWindowRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.TimeRanges != null) {
        const memberEntries = serializeAws_ec2InstanceEventWindowTimeRangeRequestSet(input.TimeRanges, context);
        if (input.TimeRanges?.length === 0) {
            entries.TimeRange = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TimeRange.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.CronExpression != null) {
        entries["CronExpression"] = input.CronExpression;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateInstanceExportTaskRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.ExportToS3Task != null) {
        const memberEntries = serializeAws_ec2ExportToS3TaskSpecification(input.ExportToS3Task, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExportToS3.${key}`;
            entries[loc] = value;
        });
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.TargetEnvironment != null) {
        entries["TargetEnvironment"] = input.TargetEnvironment;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateInternetGatewayRequest = (input, context) => {
    const entries = {};
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateIpamPoolRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.IpamScopeId != null) {
        entries["IpamScopeId"] = input.IpamScopeId;
    }
    if (input.Locale != null) {
        entries["Locale"] = input.Locale;
    }
    if (input.SourceIpamPoolId != null) {
        entries["SourceIpamPoolId"] = input.SourceIpamPoolId;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.AddressFamily != null) {
        entries["AddressFamily"] = input.AddressFamily;
    }
    if (input.AutoImport != null) {
        entries["AutoImport"] = input.AutoImport;
    }
    if (input.PubliclyAdvertisable != null) {
        entries["PubliclyAdvertisable"] = input.PubliclyAdvertisable;
    }
    if (input.AllocationMinNetmaskLength != null) {
        entries["AllocationMinNetmaskLength"] = input.AllocationMinNetmaskLength;
    }
    if (input.AllocationMaxNetmaskLength != null) {
        entries["AllocationMaxNetmaskLength"] = input.AllocationMaxNetmaskLength;
    }
    if (input.AllocationDefaultNetmaskLength != null) {
        entries["AllocationDefaultNetmaskLength"] = input.AllocationDefaultNetmaskLength;
    }
    if (input.AllocationResourceTags != null) {
        const memberEntries = serializeAws_ec2RequestIpamResourceTagList(input.AllocationResourceTags, context);
        if (input.AllocationResourceTags?.length === 0) {
            entries.AllocationResourceTag = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AllocationResourceTag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.AwsService != null) {
        entries["AwsService"] = input.AwsService;
    }
    return entries;
};
const serializeAws_ec2CreateIpamRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.OperatingRegions != null) {
        const memberEntries = serializeAws_ec2AddIpamOperatingRegionSet(input.OperatingRegions, context);
        if (input.OperatingRegions?.length === 0) {
            entries.OperatingRegion = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OperatingRegion.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateIpamScopeRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.IpamId != null) {
        entries["IpamId"] = input.IpamId;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateKeyPairRequest = (input, context) => {
    const entries = {};
    if (input.KeyName != null) {
        entries["KeyName"] = input.KeyName;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.KeyType != null) {
        entries["KeyType"] = input.KeyType;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.KeyFormat != null) {
        entries["KeyFormat"] = input.KeyFormat;
    }
    return entries;
};
const serializeAws_ec2CreateLaunchTemplateRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.LaunchTemplateName != null) {
        entries["LaunchTemplateName"] = input.LaunchTemplateName;
    }
    if (input.VersionDescription != null) {
        entries["VersionDescription"] = input.VersionDescription;
    }
    if (input.LaunchTemplateData != null) {
        const memberEntries = serializeAws_ec2RequestLaunchTemplateData(input.LaunchTemplateData, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateData.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateLaunchTemplateVersionRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.LaunchTemplateId != null) {
        entries["LaunchTemplateId"] = input.LaunchTemplateId;
    }
    if (input.LaunchTemplateName != null) {
        entries["LaunchTemplateName"] = input.LaunchTemplateName;
    }
    if (input.SourceVersion != null) {
        entries["SourceVersion"] = input.SourceVersion;
    }
    if (input.VersionDescription != null) {
        entries["VersionDescription"] = input.VersionDescription;
    }
    if (input.LaunchTemplateData != null) {
        const memberEntries = serializeAws_ec2RequestLaunchTemplateData(input.LaunchTemplateData, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LaunchTemplateData.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateLocalGatewayRouteRequest = (input, context) => {
    const entries = {};
    if (input.DestinationCidrBlock != null) {
        entries["DestinationCidrBlock"] = input.DestinationCidrBlock;
    }
    if (input.LocalGatewayRouteTableId != null) {
        entries["LocalGatewayRouteTableId"] = input.LocalGatewayRouteTableId;
    }
    if (input.LocalGatewayVirtualInterfaceGroupId != null) {
        entries["LocalGatewayVirtualInterfaceGroupId"] = input.LocalGatewayVirtualInterfaceGroupId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    return entries;
};
const serializeAws_ec2CreateLocalGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input.LocalGatewayId != null) {
        entries["LocalGatewayId"] = input.LocalGatewayId;
    }
    if (input.Mode != null) {
        entries["Mode"] = input.Mode;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest = (input, context) => {
    const entries = {};
    if (input.LocalGatewayRouteTableId != null) {
        entries["LocalGatewayRouteTableId"] = input.LocalGatewayRouteTableId;
    }
    if (input.LocalGatewayVirtualInterfaceGroupId != null) {
        entries["LocalGatewayVirtualInterfaceGroupId"] = input.LocalGatewayVirtualInterfaceGroupId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateLocalGatewayRouteTableVpcAssociationRequest = (input, context) => {
    const entries = {};
    if (input.LocalGatewayRouteTableId != null) {
        entries["LocalGatewayRouteTableId"] = input.LocalGatewayRouteTableId;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateManagedPrefixListRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.PrefixListName != null) {
        entries["PrefixListName"] = input.PrefixListName;
    }
    if (input.Entries != null) {
        const memberEntries = serializeAws_ec2AddPrefixListEntries(input.Entries, context);
        if (input.Entries?.length === 0) {
            entries.Entry = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Entry.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.MaxEntries != null) {
        entries["MaxEntries"] = input.MaxEntries;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.AddressFamily != null) {
        entries["AddressFamily"] = input.AddressFamily;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateNatGatewayRequest = (input, context) => {
    const entries = {};
    if (input.AllocationId != null) {
        entries["AllocationId"] = input.AllocationId;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.SubnetId != null) {
        entries["SubnetId"] = input.SubnetId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ConnectivityType != null) {
        entries["ConnectivityType"] = input.ConnectivityType;
    }
    if (input.PrivateIpAddress != null) {
        entries["PrivateIpAddress"] = input.PrivateIpAddress;
    }
    return entries;
};
const serializeAws_ec2CreateNetworkAclEntryRequest = (input, context) => {
    const entries = {};
    if (input.CidrBlock != null) {
        entries["CidrBlock"] = input.CidrBlock;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Egress != null) {
        entries["Egress"] = input.Egress;
    }
    if (input.IcmpTypeCode != null) {
        const memberEntries = serializeAws_ec2IcmpTypeCode(input.IcmpTypeCode, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Icmp.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Ipv6CidrBlock != null) {
        entries["Ipv6CidrBlock"] = input.Ipv6CidrBlock;
    }
    if (input.NetworkAclId != null) {
        entries["NetworkAclId"] = input.NetworkAclId;
    }
    if (input.PortRange != null) {
        const memberEntries = serializeAws_ec2PortRange(input.PortRange, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PortRange.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Protocol != null) {
        entries["Protocol"] = input.Protocol;
    }
    if (input.RuleAction != null) {
        entries["RuleAction"] = input.RuleAction;
    }
    if (input.RuleNumber != null) {
        entries["RuleNumber"] = input.RuleNumber;
    }
    return entries;
};
const serializeAws_ec2CreateNetworkAclRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateNetworkInsightsAccessScopeRequest = (input, context) => {
    const entries = {};
    if (input.MatchPaths != null) {
        const memberEntries = serializeAws_ec2AccessScopePathListRequest(input.MatchPaths, context);
        if (input.MatchPaths?.length === 0) {
            entries.MatchPath = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `MatchPath.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ExcludePaths != null) {
        const memberEntries = serializeAws_ec2AccessScopePathListRequest(input.ExcludePaths, context);
        if (input.ExcludePaths?.length === 0) {
            entries.ExcludePath = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExcludePath.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateNetworkInsightsPathRequest = (input, context) => {
    const entries = {};
    if (input.SourceIp != null) {
        entries["SourceIp"] = input.SourceIp;
    }
    if (input.DestinationIp != null) {
        entries["DestinationIp"] = input.DestinationIp;
    }
    if (input.Source != null) {
        entries["Source"] = input.Source;
    }
    if (input.Destination != null) {
        entries["Destination"] = input.Destination;
    }
    if (input.Protocol != null) {
        entries["Protocol"] = input.Protocol;
    }
    if (input.DestinationPort != null) {
        entries["DestinationPort"] = input.DestinationPort;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateNetworkInterfacePermissionRequest = (input, context) => {
    const entries = {};
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.AwsAccountId != null) {
        entries["AwsAccountId"] = input.AwsAccountId;
    }
    if (input.AwsService != null) {
        entries["AwsService"] = input.AwsService;
    }
    if (input.Permission != null) {
        entries["Permission"] = input.Permission;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateNetworkInterfaceRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Groups != null) {
        const memberEntries = serializeAws_ec2SecurityGroupIdStringList(input.Groups, context);
        if (input.Groups?.length === 0) {
            entries.SecurityGroupId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Ipv6AddressCount != null) {
        entries["Ipv6AddressCount"] = input.Ipv6AddressCount;
    }
    if (input.Ipv6Addresses != null) {
        const memberEntries = serializeAws_ec2InstanceIpv6AddressList(input.Ipv6Addresses, context);
        if (input.Ipv6Addresses?.length === 0) {
            entries.Ipv6Addresses = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Addresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.PrivateIpAddress != null) {
        entries["PrivateIpAddress"] = input.PrivateIpAddress;
    }
    if (input.PrivateIpAddresses != null) {
        const memberEntries = serializeAws_ec2PrivateIpAddressSpecificationList(input.PrivateIpAddresses, context);
        if (input.PrivateIpAddresses?.length === 0) {
            entries.PrivateIpAddresses = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PrivateIpAddresses.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.SecondaryPrivateIpAddressCount != null) {
        entries["SecondaryPrivateIpAddressCount"] = input.SecondaryPrivateIpAddressCount;
    }
    if (input.Ipv4Prefixes != null) {
        const memberEntries = serializeAws_ec2Ipv4PrefixList(input.Ipv4Prefixes, context);
        if (input.Ipv4Prefixes?.length === 0) {
            entries.Ipv4Prefix = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv4Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Ipv4PrefixCount != null) {
        entries["Ipv4PrefixCount"] = input.Ipv4PrefixCount;
    }
    if (input.Ipv6Prefixes != null) {
        const memberEntries = serializeAws_ec2Ipv6PrefixList(input.Ipv6Prefixes, context);
        if (input.Ipv6Prefixes?.length === 0) {
            entries.Ipv6Prefix = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Ipv6Prefix.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Ipv6PrefixCount != null) {
        entries["Ipv6PrefixCount"] = input.Ipv6PrefixCount;
    }
    if (input.InterfaceType != null) {
        entries["InterfaceType"] = input.InterfaceType;
    }
    if (input.SubnetId != null) {
        entries["SubnetId"] = input.SubnetId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreatePlacementGroupRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.GroupName != null) {
        entries["GroupName"] = input.GroupName;
    }
    if (input.Strategy != null) {
        entries["Strategy"] = input.Strategy;
    }
    if (input.PartitionCount != null) {
        entries["PartitionCount"] = input.PartitionCount;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.SpreadLevel != null) {
        entries["SpreadLevel"] = input.SpreadLevel;
    }
    return entries;
};
const serializeAws_ec2CreatePublicIpv4PoolRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateReplaceRootVolumeTaskRequest = (input, context) => {
    const entries = {};
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.SnapshotId != null) {
        entries["SnapshotId"] = input.SnapshotId;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ImageId != null) {
        entries["ImageId"] = input.ImageId;
    }
    if (input.DeleteReplacedRootVolume != null) {
        entries["DeleteReplacedRootVolume"] = input.DeleteReplacedRootVolume;
    }
    return entries;
};
const serializeAws_ec2CreateReservedInstancesListingRequest = (input, context) => {
    const entries = {};
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.InstanceCount != null) {
        entries["InstanceCount"] = input.InstanceCount;
    }
    if (input.PriceSchedules != null) {
        const memberEntries = serializeAws_ec2PriceScheduleSpecificationList(input.PriceSchedules, context);
        if (input.PriceSchedules?.length === 0) {
            entries.PriceSchedules = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `PriceSchedules.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ReservedInstancesId != null) {
        entries["ReservedInstancesId"] = input.ReservedInstancesId;
    }
    return entries;
};
const serializeAws_ec2CreateRestoreImageTaskRequest = (input, context) => {
    const entries = {};
    if (input.Bucket != null) {
        entries["Bucket"] = input.Bucket;
    }
    if (input.ObjectKey != null) {
        entries["ObjectKey"] = input.ObjectKey;
    }
    if (input.Name != null) {
        entries["Name"] = input.Name;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateRouteRequest = (input, context) => {
    const entries = {};
    if (input.DestinationCidrBlock != null) {
        entries["DestinationCidrBlock"] = input.DestinationCidrBlock;
    }
    if (input.DestinationIpv6CidrBlock != null) {
        entries["DestinationIpv6CidrBlock"] = input.DestinationIpv6CidrBlock;
    }
    if (input.DestinationPrefixListId != null) {
        entries["DestinationPrefixListId"] = input.DestinationPrefixListId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.VpcEndpointId != null) {
        entries["VpcEndpointId"] = input.VpcEndpointId;
    }
    if (input.EgressOnlyInternetGatewayId != null) {
        entries["EgressOnlyInternetGatewayId"] = input.EgressOnlyInternetGatewayId;
    }
    if (input.GatewayId != null) {
        entries["GatewayId"] = input.GatewayId;
    }
    if (input.InstanceId != null) {
        entries["InstanceId"] = input.InstanceId;
    }
    if (input.NatGatewayId != null) {
        entries["NatGatewayId"] = input.NatGatewayId;
    }
    if (input.TransitGatewayId != null) {
        entries["TransitGatewayId"] = input.TransitGatewayId;
    }
    if (input.LocalGatewayId != null) {
        entries["LocalGatewayId"] = input.LocalGatewayId;
    }
    if (input.CarrierGatewayId != null) {
        entries["CarrierGatewayId"] = input.CarrierGatewayId;
    }
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.RouteTableId != null) {
        entries["RouteTableId"] = input.RouteTableId;
    }
    if (input.VpcPeeringConnectionId != null) {
        entries["VpcPeeringConnectionId"] = input.VpcPeeringConnectionId;
    }
    if (input.CoreNetworkArn != null) {
        entries["CoreNetworkArn"] = input.CoreNetworkArn;
    }
    return entries;
};
const serializeAws_ec2CreateRouteTableRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateSecurityGroupRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["GroupDescription"] = input.Description;
    }
    if (input.GroupName != null) {
        entries["GroupName"] = input.GroupName;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateSnapshotRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.OutpostArn != null) {
        entries["OutpostArn"] = input.OutpostArn;
    }
    if (input.VolumeId != null) {
        entries["VolumeId"] = input.VolumeId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateSnapshotsRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.InstanceSpecification != null) {
        const memberEntries = serializeAws_ec2InstanceSpecification(input.InstanceSpecification, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InstanceSpecification.${key}`;
            entries[loc] = value;
        });
    }
    if (input.OutpostArn != null) {
        entries["OutpostArn"] = input.OutpostArn;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.CopyTagsFromSource != null) {
        entries["CopyTagsFromSource"] = input.CopyTagsFromSource;
    }
    return entries;
};
const serializeAws_ec2CreateSpotDatafeedSubscriptionRequest = (input, context) => {
    const entries = {};
    if (input.Bucket != null) {
        entries["Bucket"] = input.Bucket;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Prefix != null) {
        entries["Prefix"] = input.Prefix;
    }
    return entries;
};
const serializeAws_ec2CreateStoreImageTaskRequest = (input, context) => {
    const entries = {};
    if (input.ImageId != null) {
        entries["ImageId"] = input.ImageId;
    }
    if (input.Bucket != null) {
        entries["Bucket"] = input.Bucket;
    }
    if (input.S3ObjectTags != null) {
        const memberEntries = serializeAws_ec2S3ObjectTagList(input.S3ObjectTags, context);
        if (input.S3ObjectTags?.length === 0) {
            entries.S3ObjectTag = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `S3ObjectTag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateSubnetCidrReservationRequest = (input, context) => {
    const entries = {};
    if (input.SubnetId != null) {
        entries["SubnetId"] = input.SubnetId;
    }
    if (input.Cidr != null) {
        entries["Cidr"] = input.Cidr;
    }
    if (input.ReservationType != null) {
        entries["ReservationType"] = input.ReservationType;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateSubnetRequest = (input, context) => {
    const entries = {};
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.AvailabilityZone != null) {
        entries["AvailabilityZone"] = input.AvailabilityZone;
    }
    if (input.AvailabilityZoneId != null) {
        entries["AvailabilityZoneId"] = input.AvailabilityZoneId;
    }
    if (input.CidrBlock != null) {
        entries["CidrBlock"] = input.CidrBlock;
    }
    if (input.Ipv6CidrBlock != null) {
        entries["Ipv6CidrBlock"] = input.Ipv6CidrBlock;
    }
    if (input.OutpostArn != null) {
        entries["OutpostArn"] = input.OutpostArn;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Ipv6Native != null) {
        entries["Ipv6Native"] = input.Ipv6Native;
    }
    return entries;
};
const serializeAws_ec2CreateTagsRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.Resources != null) {
        const memberEntries = serializeAws_ec2ResourceIdList(input.Resources, context);
        if (input.Resources?.length === 0) {
            entries.ResourceId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ResourceId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Tags != null) {
        const memberEntries = serializeAws_ec2TagList(input.Tags, context);
        if (input.Tags?.length === 0) {
            entries.Tag = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tag.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateTrafficMirrorFilterRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateTrafficMirrorFilterRuleRequest = (input, context) => {
    const entries = {};
    if (input.TrafficMirrorFilterId != null) {
        entries["TrafficMirrorFilterId"] = input.TrafficMirrorFilterId;
    }
    if (input.TrafficDirection != null) {
        entries["TrafficDirection"] = input.TrafficDirection;
    }
    if (input.RuleNumber != null) {
        entries["RuleNumber"] = input.RuleNumber;
    }
    if (input.RuleAction != null) {
        entries["RuleAction"] = input.RuleAction;
    }
    if (input.DestinationPortRange != null) {
        const memberEntries = serializeAws_ec2TrafficMirrorPortRangeRequest(input.DestinationPortRange, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DestinationPortRange.${key}`;
            entries[loc] = value;
        });
    }
    if (input.SourcePortRange != null) {
        const memberEntries = serializeAws_ec2TrafficMirrorPortRangeRequest(input.SourcePortRange, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SourcePortRange.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Protocol != null) {
        entries["Protocol"] = input.Protocol;
    }
    if (input.DestinationCidrBlock != null) {
        entries["DestinationCidrBlock"] = input.DestinationCidrBlock;
    }
    if (input.SourceCidrBlock != null) {
        entries["SourceCidrBlock"] = input.SourceCidrBlock;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateTrafficMirrorSessionRequest = (input, context) => {
    const entries = {};
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.TrafficMirrorTargetId != null) {
        entries["TrafficMirrorTargetId"] = input.TrafficMirrorTargetId;
    }
    if (input.TrafficMirrorFilterId != null) {
        entries["TrafficMirrorFilterId"] = input.TrafficMirrorFilterId;
    }
    if (input.PacketLength != null) {
        entries["PacketLength"] = input.PacketLength;
    }
    if (input.SessionNumber != null) {
        entries["SessionNumber"] = input.SessionNumber;
    }
    if (input.VirtualNetworkId != null) {
        entries["VirtualNetworkId"] = input.VirtualNetworkId;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateTrafficMirrorTargetRequest = (input, context) => {
    const entries = {};
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.NetworkLoadBalancerArn != null) {
        entries["NetworkLoadBalancerArn"] = input.NetworkLoadBalancerArn;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.GatewayLoadBalancerEndpointId != null) {
        entries["GatewayLoadBalancerEndpointId"] = input.GatewayLoadBalancerEndpointId;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayConnectPeerRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.TransitGatewayAddress != null) {
        entries["TransitGatewayAddress"] = input.TransitGatewayAddress;
    }
    if (input.PeerAddress != null) {
        entries["PeerAddress"] = input.PeerAddress;
    }
    if (input.BgpOptions != null) {
        const memberEntries = serializeAws_ec2TransitGatewayConnectRequestBgpOptions(input.BgpOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `BgpOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.InsideCidrBlocks != null) {
        const memberEntries = serializeAws_ec2InsideCidrBlocksStringList(input.InsideCidrBlocks, context);
        if (input.InsideCidrBlocks?.length === 0) {
            entries.InsideCidrBlocks = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `InsideCidrBlocks.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayConnectRequest = (input, context) => {
    const entries = {};
    if (input.TransportTransitGatewayAttachmentId != null) {
        entries["TransportTransitGatewayAttachmentId"] = input.TransportTransitGatewayAttachmentId;
    }
    if (input.Options != null) {
        const memberEntries = serializeAws_ec2CreateTransitGatewayConnectRequestOptions(input.Options, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayConnectRequestOptions = (input, context) => {
    const entries = {};
    if (input.Protocol != null) {
        entries["Protocol"] = input.Protocol;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayMulticastDomainRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayId != null) {
        entries["TransitGatewayId"] = input.TransitGatewayId;
    }
    if (input.Options != null) {
        const memberEntries = serializeAws_ec2CreateTransitGatewayMulticastDomainRequestOptions(input.Options, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayMulticastDomainRequestOptions = (input, context) => {
    const entries = {};
    if (input.Igmpv2Support != null) {
        entries["Igmpv2Support"] = input.Igmpv2Support;
    }
    if (input.StaticSourcesSupport != null) {
        entries["StaticSourcesSupport"] = input.StaticSourcesSupport;
    }
    if (input.AutoAcceptSharedAssociations != null) {
        entries["AutoAcceptSharedAssociations"] = input.AutoAcceptSharedAssociations;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayPeeringAttachmentRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayId != null) {
        entries["TransitGatewayId"] = input.TransitGatewayId;
    }
    if (input.PeerTransitGatewayId != null) {
        entries["PeerTransitGatewayId"] = input.PeerTransitGatewayId;
    }
    if (input.PeerAccountId != null) {
        entries["PeerAccountId"] = input.PeerAccountId;
    }
    if (input.PeerRegion != null) {
        entries["PeerRegion"] = input.PeerRegion;
    }
    if (input.Options != null) {
        const memberEntries = serializeAws_ec2CreateTransitGatewayPeeringAttachmentRequestOptions(input.Options, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayPeeringAttachmentRequestOptions = (input, context) => {
    const entries = {};
    if (input.DynamicRouting != null) {
        entries["DynamicRouting"] = input.DynamicRouting;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayPolicyTableRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayId != null) {
        entries["TransitGatewayId"] = input.TransitGatewayId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecifications = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayPrefixListReferenceRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayRouteTableId != null) {
        entries["TransitGatewayRouteTableId"] = input.TransitGatewayRouteTableId;
    }
    if (input.PrefixListId != null) {
        entries["PrefixListId"] = input.PrefixListId;
    }
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.Blackhole != null) {
        entries["Blackhole"] = input.Blackhole;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.Options != null) {
        const memberEntries = serializeAws_ec2TransitGatewayRequestOptions(input.Options, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayRouteRequest = (input, context) => {
    const entries = {};
    if (input.DestinationCidrBlock != null) {
        entries["DestinationCidrBlock"] = input.DestinationCidrBlock;
    }
    if (input.TransitGatewayRouteTableId != null) {
        entries["TransitGatewayRouteTableId"] = input.TransitGatewayRouteTableId;
    }
    if (input.TransitGatewayAttachmentId != null) {
        entries["TransitGatewayAttachmentId"] = input.TransitGatewayAttachmentId;
    }
    if (input.Blackhole != null) {
        entries["Blackhole"] = input.Blackhole;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayRouteTableAnnouncementRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayRouteTableId != null) {
        entries["TransitGatewayRouteTableId"] = input.TransitGatewayRouteTableId;
    }
    if (input.PeeringAttachmentId != null) {
        entries["PeeringAttachmentId"] = input.PeeringAttachmentId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayRouteTableRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayId != null) {
        entries["TransitGatewayId"] = input.TransitGatewayId;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecifications = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayVpcAttachmentRequest = (input, context) => {
    const entries = {};
    if (input.TransitGatewayId != null) {
        entries["TransitGatewayId"] = input.TransitGatewayId;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.SubnetIds != null) {
        const memberEntries = serializeAws_ec2TransitGatewaySubnetIdList(input.SubnetIds, context);
        if (input.SubnetIds?.length === 0) {
            entries.SubnetIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Options != null) {
        const memberEntries = serializeAws_ec2CreateTransitGatewayVpcAttachmentRequestOptions(input.Options, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Options.${key}`;
            entries[loc] = value;
        });
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecifications = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecifications.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateTransitGatewayVpcAttachmentRequestOptions = (input, context) => {
    const entries = {};
    if (input.DnsSupport != null) {
        entries["DnsSupport"] = input.DnsSupport;
    }
    if (input.Ipv6Support != null) {
        entries["Ipv6Support"] = input.Ipv6Support;
    }
    if (input.ApplianceModeSupport != null) {
        entries["ApplianceModeSupport"] = input.ApplianceModeSupport;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessEndpointEniOptions = (input, context) => {
    const entries = {};
    if (input.NetworkInterfaceId != null) {
        entries["NetworkInterfaceId"] = input.NetworkInterfaceId;
    }
    if (input.Protocol != null) {
        entries["Protocol"] = input.Protocol;
    }
    if (input.Port != null) {
        entries["Port"] = input.Port;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessEndpointLoadBalancerOptions = (input, context) => {
    const entries = {};
    if (input.Protocol != null) {
        entries["Protocol"] = input.Protocol;
    }
    if (input.Port != null) {
        entries["Port"] = input.Port;
    }
    if (input.LoadBalancerArn != null) {
        entries["LoadBalancerArn"] = input.LoadBalancerArn;
    }
    if (input.SubnetIds != null) {
        const memberEntries = serializeAws_ec2CreateVerifiedAccessEndpointSubnetIdList(input.SubnetIds, context);
        if (input.SubnetIds?.length === 0) {
            entries.SubnetId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessEndpointRequest = (input, context) => {
    const entries = {};
    if (input.VerifiedAccessGroupId != null) {
        entries["VerifiedAccessGroupId"] = input.VerifiedAccessGroupId;
    }
    if (input.EndpointType != null) {
        entries["EndpointType"] = input.EndpointType;
    }
    if (input.AttachmentType != null) {
        entries["AttachmentType"] = input.AttachmentType;
    }
    if (input.DomainCertificateArn != null) {
        entries["DomainCertificateArn"] = input.DomainCertificateArn;
    }
    if (input.ApplicationDomain != null) {
        entries["ApplicationDomain"] = input.ApplicationDomain;
    }
    if (input.EndpointDomainPrefix != null) {
        entries["EndpointDomainPrefix"] = input.EndpointDomainPrefix;
    }
    if (input.SecurityGroupIds != null) {
        const memberEntries = serializeAws_ec2SecurityGroupIdList(input.SecurityGroupIds, context);
        if (input.SecurityGroupIds?.length === 0) {
            entries.SecurityGroupId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.LoadBalancerOptions != null) {
        const memberEntries = serializeAws_ec2CreateVerifiedAccessEndpointLoadBalancerOptions(input.LoadBalancerOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `LoadBalancerOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.NetworkInterfaceOptions != null) {
        const memberEntries = serializeAws_ec2CreateVerifiedAccessEndpointEniOptions(input.NetworkInterfaceOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `NetworkInterfaceOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.PolicyDocument != null) {
        entries["PolicyDocument"] = input.PolicyDocument;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessEndpointSubnetIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Item.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessGroupRequest = (input, context) => {
    const entries = {};
    if (input.VerifiedAccessInstanceId != null) {
        entries["VerifiedAccessInstanceId"] = input.VerifiedAccessInstanceId;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.PolicyDocument != null) {
        entries["PolicyDocument"] = input.PolicyDocument;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessInstanceRequest = (input, context) => {
    const entries = {};
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessTrustProviderDeviceOptions = (input, context) => {
    const entries = {};
    if (input.TenantId != null) {
        entries["TenantId"] = input.TenantId;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessTrustProviderOidcOptions = (input, context) => {
    const entries = {};
    if (input.Issuer != null) {
        entries["Issuer"] = input.Issuer;
    }
    if (input.AuthorizationEndpoint != null) {
        entries["AuthorizationEndpoint"] = input.AuthorizationEndpoint;
    }
    if (input.TokenEndpoint != null) {
        entries["TokenEndpoint"] = input.TokenEndpoint;
    }
    if (input.UserInfoEndpoint != null) {
        entries["UserInfoEndpoint"] = input.UserInfoEndpoint;
    }
    if (input.ClientId != null) {
        entries["ClientId"] = input.ClientId;
    }
    if (input.ClientSecret != null) {
        entries["ClientSecret"] = input.ClientSecret;
    }
    if (input.Scope != null) {
        entries["Scope"] = input.Scope;
    }
    return entries;
};
const serializeAws_ec2CreateVerifiedAccessTrustProviderRequest = (input, context) => {
    const entries = {};
    if (input.TrustProviderType != null) {
        entries["TrustProviderType"] = input.TrustProviderType;
    }
    if (input.UserTrustProviderType != null) {
        entries["UserTrustProviderType"] = input.UserTrustProviderType;
    }
    if (input.DeviceTrustProviderType != null) {
        entries["DeviceTrustProviderType"] = input.DeviceTrustProviderType;
    }
    if (input.OidcOptions != null) {
        const memberEntries = serializeAws_ec2CreateVerifiedAccessTrustProviderOidcOptions(input.OidcOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OidcOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.DeviceOptions != null) {
        const memberEntries = serializeAws_ec2CreateVerifiedAccessTrustProviderDeviceOptions(input.DeviceOptions, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DeviceOptions.${key}`;
            entries[loc] = value;
        });
    }
    if (input.PolicyReferenceName != null) {
        entries["PolicyReferenceName"] = input.PolicyReferenceName;
    }
    if (input.Description != null) {
        entries["Description"] = input.Description;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    return entries;
};
const serializeAws_ec2CreateVolumePermission = (input, context) => {
    const entries = {};
    if (input.Group != null) {
        entries["Group"] = input.Group;
    }
    if (input.UserId != null) {
        entries["UserId"] = input.UserId;
    }
    return entries;
};
const serializeAws_ec2CreateVolumePermissionList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = serializeAws_ec2CreateVolumePermission(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Item.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const serializeAws_ec2CreateVolumePermissionModifications = (input, context) => {
    const entries = {};
    if (input.Add != null) {
        const memberEntries = serializeAws_ec2CreateVolumePermissionList(input.Add, context);
        if (input.Add?.length === 0) {
            entries.Add = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Add.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.Remove != null) {
        const memberEntries = serializeAws_ec2CreateVolumePermissionList(input.Remove, context);
        if (input.Remove?.length === 0) {
            entries.Remove = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Remove.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const serializeAws_ec2CreateVolumeRequest = (input, context) => {
    const entries = {};
    if (input.AvailabilityZone != null) {
        entries["AvailabilityZone"] = input.AvailabilityZone;
    }
    if (input.Encrypted != null) {
        entries["Encrypted"] = input.Encrypted;
    }
    if (input.Iops != null) {
        entries["Iops"] = input.Iops;
    }
    if (input.KmsKeyId != null) {
        entries["KmsKeyId"] = input.KmsKeyId;
    }
    if (input.OutpostArn != null) {
        entries["OutpostArn"] = input.OutpostArn;
    }
    if (input.Size != null) {
        entries["Size"] = input.Size;
    }
    if (input.SnapshotId != null) {
        entries["SnapshotId"] = input.SnapshotId;
    }
    if (input.VolumeType != null) {
        entries["VolumeType"] = input.VolumeType;
    }
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.TagSpecifications != null) {
        const memberEntries = serializeAws_ec2TagSpecificationList(input.TagSpecifications, context);
        if (input.TagSpecifications?.length === 0) {
            entries.TagSpecification = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagSpecification.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.MultiAttachEnabled != null) {
        entries["MultiAttachEnabled"] = input.MultiAttachEnabled;
    }
    if (input.Throughput != null) {
        entries["Throughput"] = input.Throughput;
    }
    if (input.ClientToken === undefined) {
        input.ClientToken = generateIdempotencyToken();
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateVpcEndpointConnectionNotificationRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.ServiceId != null) {
        entries["ServiceId"] = input.ServiceId;
    }
    if (input.VpcEndpointId != null) {
        entries["VpcEndpointId"] = input.VpcEndpointId;
    }
    if (input.ConnectionNotificationArn != null) {
        entries["ConnectionNotificationArn"] = input.ConnectionNotificationArn;
    }
    if (input.ConnectionEvents != null) {
        const memberEntries = serializeAws_ec2ValueStringList(input.ConnectionEvents, context);
        if (input.ConnectionEvents?.length === 0) {
            entries.ConnectionEvents = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConnectionEvents.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.ClientToken != null) {
        entries["ClientToken"] = input.ClientToken;
    }
    return entries;
};
const serializeAws_ec2CreateVpcEndpointRequest = (input, context) => {
    const entries = {};
    if (input.DryRun != null) {
        entries["DryRun"] = input.DryRun;
    }
    if (input.VpcEndpointType != null) {
        entries["VpcEndpointType"] = input.VpcEndpointType;
    }
    if (input.VpcId != null) {
        entries["VpcId"] = input.VpcId;
    }
    if (input.ServiceName != null) {
        entries["ServiceName"] = input.ServiceName;
    }
    if (input.PolicyDocument != null) {
        entries["PolicyDocument"] = input.PolicyDocument;
    }
    if (input.RouteTableIds != null) {
        const memberEntries = serializeAws_ec2VpcEndpointRouteTableIdList(input.RouteTableIds, context);
        if (input.RouteTableIds?.length === 0) {
            entries.RouteTableId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RouteTableId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.SubnetIds != null) {
        const memberEntries = serializeAws_ec2VpcEndpointSubnetIdList(input.SubnetIds, context);
        if (input.SubnetIds?.length === 0) {
            entries.SubnetId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.SecurityGroupIds != null) {
        const memberEntries = serializeAws_ec2VpcEndpointSecurityGroupIdList(input.SecurityGroupIds, context);
        if (input.SecurityGroupIds?.length === 0) {
            entries.SecurityGroupId = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroupId.${key.substring(key.indexOf(".") + 1)}`;
            entries[loc] = value;
        });
    }
    if (input.IpAddressType 