import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeTransitGatewayRouteTablesRequestFilterSensitiveLog, DescribeTransitGatewayRouteTablesResultFilterSensitiveLog, } from "../models/models_4";
import { deserializeAws_ec2DescribeTransitGatewayRouteTablesCommand, serializeAws_ec2DescribeTransitGatewayRouteTablesCommand, } from "../protocols/Aws_ec2";
export class DescribeTransitGatewayRouteTablesCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeTransitGatewayRouteTablesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeTransitGatewayRouteTablesCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeTransitGatewayRouteTablesRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeTransitGatewayRouteTablesResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeTransitGatewayRouteTablesCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeTransitGatewayRouteTablesCommand(output, context);
    }
}
