import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribePublicIpv4PoolsRequestFilterSensitiveLog, DescribePublicIpv4PoolsResultFilterSensitiveLog, } from "../models/models_4";
import { deserializeAws_ec2DescribePublicIpv4PoolsCommand, serializeAws_ec2DescribePublicIpv4PoolsCommand, } from "../protocols/Aws_ec2";
export class DescribePublicIpv4PoolsCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribePublicIpv4PoolsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribePublicIpv4PoolsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribePublicIpv4PoolsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribePublicIpv4PoolsResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribePublicIpv4PoolsCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribePublicIpv4PoolsCommand(output, context);
    }
}
