import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeLaunchTemplateVersionsRequestFilterSensitiveLog, DescribeLaunchTemplateVersionsResultFilterSensitiveLog, } from "../models/models_4";
import { deserializeAws_ec2DescribeLaunchTemplateVersionsCommand, serializeAws_ec2DescribeLaunchTemplateVersionsCommand, } from "../protocols/Aws_ec2";
export class DescribeLaunchTemplateVersionsCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeLaunchTemplateVersionsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeLaunchTemplateVersionsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeLaunchTemplateVersionsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeLaunchTemplateVersionsResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeLaunchTemplateVersionsCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeLaunchTemplateVersionsCommand(output, context);
    }
}
