import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeIpv6PoolsRequestFilterSensitiveLog, DescribeIpv6PoolsResultFilterSensitiveLog, } from "../models/models_4";
import { deserializeAws_ec2DescribeIpv6PoolsCommand, serializeAws_ec2DescribeIpv6PoolsCommand, } from "../protocols/Aws_ec2";
export class DescribeIpv6PoolsCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeIpv6PoolsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeIpv6PoolsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeIpv6PoolsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeIpv6PoolsResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeIpv6PoolsCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeIpv6PoolsCommand(output, context);
    }
}
