import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeImportImageTasksRequestFilterSensitiveLog, DescribeImportImageTasksResultFilterSensitiveLog, } from "../models/models_3";
import { deserializeAws_ec2DescribeImportImageTasksCommand, serializeAws_ec2DescribeImportImageTasksCommand, } from "../protocols/Aws_ec2";
export class DescribeImportImageTasksCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeImportImageTasksCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeImportImageTasksCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeImportImageTasksRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeImportImageTasksResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeImportImageTasksCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeImportImageTasksCommand(output, context);
    }
}
