import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeAvailabilityZonesRequestFilterSensitiveLog, DescribeAvailabilityZonesResultFilterSensitiveLog, } from "../models/models_3";
import { deserializeAws_ec2DescribeAvailabilityZonesCommand, serializeAws_ec2DescribeAvailabilityZonesCommand, } from "../protocols/Aws_ec2";
export class DescribeAvailabilityZonesCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeAvailabilityZonesCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeAvailabilityZonesCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeAvailabilityZonesRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeAvailabilityZonesResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DescribeAvailabilityZonesCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DescribeAvailabilityZonesCommand(output, context);
    }
}
