import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DeletePublicIpv4PoolRequestFilterSensitiveLog, DeletePublicIpv4PoolResultFilterSensitiveLog, } from "../models/models_2";
import { deserializeAws_ec2DeletePublicIpv4PoolCommand, serializeAws_ec2DeletePublicIpv4PoolCommand, } from "../protocols/Aws_ec2";
export class DeletePublicIpv4PoolCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DeletePublicIpv4PoolCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DeletePublicIpv4PoolCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DeletePublicIpv4PoolRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DeletePublicIpv4PoolResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2DeletePublicIpv4PoolCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2DeletePublicIpv4PoolCommand(output, context);
    }
}
