import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateTransitGatewayPeeringAttachmentRequestFilterSensitiveLog, CreateTransitGatewayPeeringAttachmentResultFilterSensitiveLog, } from "../models/models_2";
import { deserializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand, serializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand, } from "../protocols/Aws_ec2";
export class CreateTransitGatewayPeeringAttachmentCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, CreateTransitGatewayPeeringAttachmentCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "CreateTransitGatewayPeeringAttachmentCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: CreateTransitGatewayPeeringAttachmentRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CreateTransitGatewayPeeringAttachmentResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2CreateTransitGatewayPeeringAttachmentCommand(output, context);
    }
}
