import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { CreateReservedInstancesListingRequestFilterSensitiveLog, CreateReservedInstancesListingResultFilterSensitiveLog, } from "../models/models_1";
import { deserializeAws_ec2CreateReservedInstancesListingCommand, serializeAws_ec2CreateReservedInstancesListingCommand, } from "../protocols/Aws_ec2";
export class CreateReservedInstancesListingCommand extends $Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, CreateReservedInstancesListingCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "CreateReservedInstancesListingCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: CreateReservedInstancesListingRequestFilterSensitiveLog,
            outputFilterSensitiveLog: CreateReservedInstancesListingResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_ec2CreateReservedInstancesListingCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_ec2CreateReservedInstancesListingCommand(output, context);
    }
}
