"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DescribeNetworkInterfacePermissionsCommand = void 0;
const middleware_endpoint_1 = require("@aws-sdk/middleware-endpoint");
const middleware_serde_1 = require("@aws-sdk/middleware-serde");
const smithy_client_1 = require("@aws-sdk/smithy-client");
const models_4_1 = require("../models/models_4");
const Aws_ec2_1 = require("../protocols/Aws_ec2");
class DescribeNetworkInterfacePermissionsCommand extends smithy_client_1.Command {
    constructor(input) {
        super();
        this.input = input;
    }
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use((0, middleware_serde_1.getSerdePlugin)(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use((0, middleware_endpoint_1.getEndpointPlugin)(configuration, DescribeNetworkInterfacePermissionsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "EC2Client";
        const commandName = "DescribeNetworkInterfacePermissionsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: models_4_1.DescribeNetworkInterfacePermissionsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: models_4_1.DescribeNetworkInterfacePermissionsResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return (0, Aws_ec2_1.serializeAws_ec2DescribeNetworkInterfacePermissionsCommand)(input, context);
    }
    deserialize(output, context) {
        return (0, Aws_ec2_1.deserializeAws_ec2DescribeNetworkInterfacePermissionsCommand)(output, context);
    }
}
exports.DescribeNetworkInterfacePermissionsCommand = DescribeNetworkInterfacePermissionsCommand;
