import { Stack, aws_ec2 as ec2 } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface IStackProps {
    environment: string;
    solutionName: string;
    costcenter: string;
    /**
     * vpc cidr
     * @default '172.16.0.0/16'
     */
    cidr?: string;
    /**vpc name
     * @default solutionName
    */
    name: string;
}
export declare class VTVpc extends Construct {
    /** API construct */
    readonly vpc: ec2.Vpc;
    constructor(parent: Stack, id: string, props: IStackProps);
}
