"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
//import path from 'path';
//import { RemovalPolicy, Stack, Tags, CfnOutput, Fn } from 'aws-cdk-lib';
const aws_cdk_lib_1 = require("aws-cdk-lib");
const index_1 = require("../index");
// import * as iam from 'aws-cdk-lib/aws-iam';
const aws_region = 'us-east-2';
const solution = 'VPCConstructIntegTest';
const environment = 'dev';
const costcenter = 'tnc';
class IntegTesting {
    constructor() {
        const env = {
            account: process.env.CDK_DEFAULT_ACCOUNT,
            region: aws_region || process.env.CDK_DEFAULT_REGION,
        };
        const app = new aws_cdk_lib_1.App();
        const stack = new aws_cdk_lib_1.Stack(app, 'VPCIntegrationTestStack', {
            env,
            tags: {
                solution,
                environment,
                costcenter,
            },
        });
        new index_1.VTVpc(stack, 'VTVpcConstruct', {
            solutionName: 'UnitestVPC',
            costcenter: 'tnc',
            environment: 'test',
            name: 'testvpc',
        });
        this.stack = [stack];
        aws_cdk_lib_1.Tags.of(stack).add('solution', solution);
        aws_cdk_lib_1.Tags.of(stack).add('environment', environment);
        aws_cdk_lib_1.Tags.of(stack).add('costcenter', costcenter);
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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