
from __future__ import print_function

import boto3
import botocore
import json

import urllib3
import json

SUCCESS = "SUCCESS"
FAILED = "FAILED"

http = urllib3.PoolManager()


ib_client = boto3.client('imagebuilder')

def handler(event, context):
    print("Received event: " + json.dumps(event, indent=2))
    
    request_type = event['RequestType']
    props = event['ResourceProperties']

    recipe_name = props['RecipeName']

    if request_type == 'Create' or request_type == 'Update':
    
        if request_type == 'Update':
            physicalResourceId = event["PhysicalResourceId"]
        else:
            physicalResourceId = None
            
        try:
            found_recipe = False
            next_token = None
            
            while not found_recipe:
                if next_token:
                    response = ib_client.list_image_recipes(
                        owner='Self',
                        filters=[
                            {
                                'name': 'name',
                                'values': [
                                    recipe_name,
                                ]
                            },
                        ],
                        maxResults=25, # for some reason, boto does the filtering client-side.
                        nextToken=next_token
                    )
                else:
                    response = ib_client.list_image_recipes(
                        owner='Self',
                        filters=[
                            {
                                'name': 'name',
                                'values': [
                                    recipe_name,
                                ]
                            },
                        ],
                        maxResults=25 # for some reason, boto does the filtering client-side.
                    )
                
                if 'imageRecipeSummaryList' in response and len(response['imageRecipeSummaryList']) > 0:
                    found_recipe = True
                    recipe_arn = response['imageRecipeSummaryList'][0]['arn']
                    
                    print("Image Recipe ARN: " + recipe_arn)
                    
                    version = recipe_arn.split("/")[-1]
                    next_version = bump(version)
                    
                    return create_response({ 'ImageRecipeArn': response['imageRecipeSummaryList'][0]['arn'], 'Version': version, 'NextVersion': next_version }, physicalResourceId)
                else:
                    if response.get('nextToken'):
                        next_token = response['nextToken']
                    else:
                        return create_response({ 'NextVersion': '1.0.0' }, physicalResourceId)
            
        except botocore.exceptions.ClientError as err:
            raise err
    elif request_type == 'Delete': return create_response({}, event["PhysicalResourceId"])

    raise Exception("Invalid request type: %s" % request_type)

def bump(version):
    split_version = version.split('.')
    return f'{split_version[0]}.{split_version[1]}.{int(split_version[2]) + 1}'

def create_response(responseData, physicalResourceId=None):

    return {
        'PhysicalResourceId' : physicalResourceId,
        'Data' : responseData
    }

