# Generated by Django 3.0 on 2020-07-29 12:47

import uuid

import appchance
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="RedlinkDevice",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        help_text="Unique device identifier",
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name="Device ID",
                    ),
                ),
                ("registration_id", models.TextField()),
                ("session_key", models.CharField(blank=True, db_index=True, max_length=40)),
                ("name", models.CharField(max_length=255, null=True, verbose_name="Name")),
                ("active", models.BooleanField(default=True)),
                ("type", models.CharField(choices=[("ios", "ios"), ("android", "android")], max_length=10)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="devices",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"abstract": False,},
            bases=(appchance.redlink.models.RedlinkClientMixin, models.Model),
        ),
        migrations.CreateModel(
            name="NotificationSettings",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("marketing", models.BooleanField(default=True)),
                ("transactional", models.BooleanField(default=True)),
                (
                    "device",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="appchance.redlink..RedlinkDevice"),
                ),
            ],
        ),
    ]
