import pygame
import pygame.gfxdraw
import mun_official
from mun_official.math.bezier import CubicBezier, QuadraticBezier
import random
import math
import os
pygame.init()

screen = pygame.display.set_mode((800, 600))
main_dir = os.path.split(os.path.abspath(__file__))[0]
file = os.path.join(main_dir, 'images', 'image1.png')

surf = pygame.image.load(file).convert_alpha()
path1 = CubicBezier([(0, 0), (56, 500), (300, 20), (800, 600)])
path1.set_filter('t', mun_official.filter.linear, 0.02)
path2 = QuadraticBezier([(0, 0), (0, 600), (800, 600)])
path2.set_filter('t', mun_official.filter.linear, 0.02)
path = path1
a = mun_official.Mun_official(surf, 0, 0)
a.set_filter('x', mun_official.filter.spring)
a.set_filter('y', mun_official.filter.spring)
a.set_renderer('w_ratio', mun_official.renderer.wratio_smooth_renderer)
a.set_renderer('h_ratio', mun_official.renderer.hratio_smooth_renderer)
a.w_ratio = 0.5
a.h_ratio = 0.5

playing = True
counter = 0

while playing:
    mx, my = pygame.mouse.get_pos()
    for e in pygame.event.get():
        if e.type == pygame.QUIT:
            playing = False
        elif e.type == pygame.MOUSEBUTTONDOWN:
            if counter % 2:
                path.t = 0
            else:
                path.t = 1
            counter += 1
        elif e.type == pygame.KEYDOWN:
            if e.key == pygame.K_r:
                if path == path1:
                    path = path2
                else:
                    path = path1

    screen.fill((255,255,255))
    pygame.gfxdraw.bezier(screen, path.path, len(path.path), (255, 0 , 0))
    a.x, a.y = path.get_pos()
    path.update()
    a.update()
    a.render(screen)
    pygame.display.flip()
    pygame.time.wait(10)

pygame.quit()