"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroup = exports.DnsBlockResponse = exports.FirewallRuleAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const firewall_rule_group_association_1 = require("./firewall-rule-group-association");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * A Firewall Rule
 */
class FirewallRuleAction {
    /**
     * Permit the request to go through
     */
    static allow() {
        return { action: 'ALLOW' };
    }
    /**
     * Permit the request to go through but send an alert to the logs
     */
    static alert() {
        return { action: 'ALERT' };
    }
    /**
     * Disallow the request
     *
     * @param [response=DnsBlockResponse.noData()] The way that you want DNS Firewall to block the request
     */
    static block(response) {
        jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_DnsBlockResponse(response);
        return {
            action: 'BLOCK',
            blockResponse: response !== null && response !== void 0 ? response : DnsBlockResponse.noData(),
        };
    }
}
exports.FirewallRuleAction = FirewallRuleAction;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleAction[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleAction", version: "1.146.0" };
/**
 * The way that you want DNS Firewall to block the request
 */
class DnsBlockResponse {
    /**
     * Respond indicating that the query was successful, but no
     * response is available for it.
     */
    static noData() {
        return { blockResponse: 'NODATA' };
    }
    /**
     * Respond indicating that the domain name that's in the query
     * doesn't exist.
     */
    static nxDomain() {
        return { blockResponse: 'NXDOMAIN' };
    }
    /**
     * Provides a custom override response to the query
     *
     * @param domain The custom DNS record to send back in response to the query
     * @param [ttl=0] The recommended amount of time for the DNS resolver or
     *   web browser to cache the provided override record
     */
    static override(domain, ttl) {
        return {
            blockResponse: 'OVERRIDE',
            blockOverrideDnsType: 'CNAME',
            blockOverrideDomain: domain,
            blockOverrideTtl: ttl !== null && ttl !== void 0 ? ttl : core_1.Duration.seconds(0),
        };
    }
}
exports.DnsBlockResponse = DnsBlockResponse;
_b = JSII_RTTI_SYMBOL_1;
DnsBlockResponse[_b] = { fqn: "@aws-cdk/aws-route53resolver.DnsBlockResponse", version: "1.146.0" };
/**
 * A Firewall Rule Group
 */
class FirewallRuleGroup extends core_1.Resource {
    constructor(scope, id, props = {}) {
        var _d;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupProps(props);
        this.rules = (_d = props.rules) !== null && _d !== void 0 ? _d : [];
        const ruleGroup = new route53resolver_generated_1.CfnFirewallRuleGroup(this, 'Resource', {
            name: props.name,
            firewallRules: core_1.Lazy.any({ produce: () => this.rules.map(renderRule) }),
        });
        this.firewallRuleGroupId = ruleGroup.attrId;
        this.firewallRuleGroupArn = ruleGroup.attrArn;
        this.firewallRuleGroupCreationTime = ruleGroup.attrCreationTime;
        this.firewallRuleGroupCreatorRequestId = ruleGroup.attrCreatorRequestId;
        this.firewallRuleGroupModificationTime = ruleGroup.attrModificationTime;
        this.firewallRuleGroupOwnerId = ruleGroup.attrOwnerId;
        this.firewallRuleGroupRuleCount = ruleGroup.attrRuleCount;
        this.firewallRuleGroupShareStatus = ruleGroup.attrShareStatus;
        this.firewallRuleGroupStatus = ruleGroup.attrStatus;
        this.firewallRuleGroupStatusMessage = ruleGroup.attrStatusMessage;
    }
    /**
     * Import an existing Firewall Rule Group
     */
    static fromFirewallRuleGroupId(scope, id, firewallRuleGroupId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.firewallRuleGroupId = firewallRuleGroupId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds a rule to this group
     */
    addRule(rule) {
        jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRule(rule);
        this.rules.push(rule);
        return this;
    }
    /**
     * Associates this Firewall Rule Group with a VPC
     */
    associate(id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupAssociationOptions(props);
        return new firewall_rule_group_association_1.FirewallRuleGroupAssociation(this, id, {
            ...props,
            firewallRuleGroup: this,
        });
    }
}
exports.FirewallRuleGroup = FirewallRuleGroup;
_c = JSII_RTTI_SYMBOL_1;
FirewallRuleGroup[_c] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroup", version: "1.146.0" };
function renderRule(rule) {
    var _d, _e, _f, _g, _h;
    return {
        action: rule.action.action,
        firewallDomainListId: rule.firewallDomainList.firewallDomainListId,
        priority: rule.priority,
        blockOverrideDnsType: (_d = rule.action.blockResponse) === null || _d === void 0 ? void 0 : _d.blockOverrideDnsType,
        blockOverrideDomain: (_e = rule.action.blockResponse) === null || _e === void 0 ? void 0 : _e.blockOverrideDomain,
        blockOverrideTtl: (_g = (_f = rule.action.blockResponse) === null || _f === void 0 ? void 0 : _f.blockOverrideTtl) === null || _g === void 0 ? void 0 : _g.toSeconds(),
        blockResponse: (_h = rule.action.blockResponse) === null || _h === void 0 ? void 0 : _h.blockResponse,
    };
}
//# sourceMappingURL=data:application/json;base64,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