# coding: utf-8

"""
    EXACT - API

    API to interact with the EXACT Server  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest

from exact_sync.v1.api_client import ApiClient as client

from exact_sync.v1.api.images_api import ImagesApi  # noqa: E501
from exact_sync.v1.api.teams_api import TeamsApi
from exact_sync.v1.api.image_sets_api import ImageSetsApi
from exact_sync.v1.api.image_registration_api import ImageRegistrationApi

from exact_sync.v1.rest import ApiException
from exact_sync.v1.models import ImageSet, Image, Team, ImageRegistration

import os
from pathlib import Path

class TestImageRegistration(unittest.TestCase):
    """ImageRegistration unit test stubs"""

    def setUp(self):
        self.images_api = ImagesApi()  # noqa: E501
        self.team_api = TeamsApi()
        self.image_sets_api = ImageSetsApi()
        self.image_registration_api = ImageRegistrationApi()

         # create dummy team and image_sets
        teams = self.team_api.list_teams(name="test_images")
        if teams.count == 0:
            team = Team(name="test_images")
            team = self.team_api.create_team(body=team) 
        else:
            team = teams.results[0]
        self.team = team

        image_sets = self.image_sets_api.list_image_sets(name="test_images")
        if image_sets.count == 0:
            image_set = ImageSet(name="test_images", team=team.id)
            image_set = self.image_sets_api.create_image_set(body=image_set)
        else:
            image_set = image_sets.results[0]
        self.image_set = image_set 


        source_images = self.images_api.list_images(name="A_CCMCT_22108_1.svs")
        if source_images.count == 0:
            file_path = "exact_sync/v1/test/images/A_CCMCT_22108_1.svs"
            image_type = 0
            image_set = self.image_set.id
            self.source_image = self.images_api.create_image(file_path=file_path, image_type=image_type, image_set=image_set).results[0]  
        else:
            self.source_image = source_images.results[0]

        target_images = self.images_api.list_images(name="N2_CCMCT_22108_1.ndpi")
        if target_images.count == 0:
            file_path = "exact_sync/v1/test/images/N2_CCMCT_22108_1.ndpi"
            image_type = 0
            image_set = self.image_set.id
            self.target_image = self.images_api.create_image(file_path=file_path, image_type=image_type, image_set=image_set).results[0]  
        else:
            self.target_image = target_images.results[0]  

    def tearDown(self):

        self.images_api.destroy_image(id=self.target_image.id)
        self.images_api.destroy_image(id=self.source_image.id)
        self.image_sets_api.destroy_image_set(id=self.image_set.id)
        self.team_api.destroy_team(id=self.team.id)

    def test_create_image_registration(self):
        """Test case for create_image_registration

        """
        transformation_matrix = {"00":1, "01":0, "02":0}
        file_path = "exact_sync/v1/test/images/Eosinophile.png"

        registation = ImageRegistration(source_image=self.source_image.id, 
                                target_image=self.target_image.id, 
                                transformation_matrix=transformation_matrix,
                                registration_error=100, runtime=15)

        registation = self.image_registration_api.create_image_registration(body=registation)

        retrieved_image_registration = self.image_registration_api.retrieve_image_registration(id=registation.id)
        retrieved_image_registrations = self.image_registration_api.list_image_registrations(source_image=self.source_image.id)
        assert len(retrieved_image_registrations.results) > 0

        updated_registration = self.image_registration_api.partial_update_image_registration(id=retrieved_image_registration.id, file=file_path)

        assert registation.id > 0
        self.image_registration_api.destroy_image_registration(id=registation.id)

        pass

    def test_register_image(self):
        """Test case for register_image 

        """
        registration = self.image_registration_api.register_image(source_image=self.source_image.id, target_image=self.target_image.id)
        inverse_registration = self.image_registration_api.create_inverse_registration(id=registration.id)

        assert registration.source_image == inverse_registration.target_image
        assert registration.target_image == inverse_registration.source_image
        
 
        vector = {"x1":10, "x2":20, "y1":10, "y2":20}
        new_vector, _ = image_registration_api.convert_coodinates(registration.id, vector=vector)

        target_path = "temp1.pickle"
        status, target_path = self.image_registration_api.download_registration_file(file=registration.file, target_path=target_path)
        
        assert Path(target_path).exists() == True

        if Path(target_path).exists:
            os.remove(target_path)
        pass


if __name__ == '__main__':
    unittest.main()
