# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SimpleSearchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query': 'str',
        'owner': 'list[str]',
        'category': 'list[str]',
        'include_community_results': 'bool'
    }

    attribute_map = {
        'query': 'query',
        'owner': 'owner',
        'category': 'category',
        'include_community_results': 'includeCommunityResults'
    }

    def __init__(self, query=None, owner=None, category=None, include_community_results=False):
        """
        SimpleSearchRequest - a model defined in Swagger
        """

        self._query = None
        self._owner = None
        self._category = None
        self._include_community_results = None

        self.query = query
        if owner is not None:
          self.owner = owner
        if category is not None:
          self.category = category
        if include_community_results is not None:
          self.include_community_results = include_community_results

    @property
    def query(self):
        """
        Gets the query of this SimpleSearchRequest.

        :return: The query of this SimpleSearchRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this SimpleSearchRequest.

        :param query: The query of this SimpleSearchRequest.
        :type: str
        """
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")

        self._query = query

    @property
    def owner(self):
        """
        Gets the owner of this SimpleSearchRequest.
        Filter by owners. Owners are identified by their IDs.

        :return: The owner of this SimpleSearchRequest.
        :rtype: list[str]
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this SimpleSearchRequest.
        Filter by owners. Owners are identified by their IDs.

        :param owner: The owner of this SimpleSearchRequest.
        :type: list[str]
        """

        self._owner = owner

    @property
    def category(self):
        """
        Gets the category of this SimpleSearchRequest.
        Filter by categories.

        :return: The category of this SimpleSearchRequest.
        :rtype: list[str]
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this SimpleSearchRequest.
        Filter by categories.

        :param category: The category of this SimpleSearchRequest.
        :type: list[str]
        """
        allowed_values = ["catalogAnalysis", "catalogBusinessTerm", "catalogDataset", "catalogDataType", "catalogTable", "collection", "comment", "dataset", "datatable", "file", "insight", "integration", "project", "query"]
        if not set(category).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `category` [{0}], must be a subset of [{1}]"
                .format(", ".join(map(str, set(category)-set(allowed_values))),
                        ", ".join(map(str, allowed_values)))
            )

        self._category = category

    @property
    def include_community_results(self):
        """
        Gets the include_community_results of this SimpleSearchRequest.

        :return: The include_community_results of this SimpleSearchRequest.
        :rtype: bool
        """
        return self._include_community_results

    @include_community_results.setter
    def include_community_results(self, include_community_results):
        """
        Sets the include_community_results of this SimpleSearchRequest.

        :param include_community_results: The include_community_results of this SimpleSearchRequest.
        :type: bool
        """

        self._include_community_results = include_community_results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SimpleSearchRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
