# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class InsightBody(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'embed_url': 'str',
        'image_url': 'str',
        'markdown_body': 'str'
    }

    attribute_map = {
        'embed_url': 'embedUrl',
        'image_url': 'imageUrl',
        'markdown_body': 'markdownBody'
    }

    def __init__(self, embed_url=None, image_url=None, markdown_body=None):
        """
        InsightBody - a model defined in Swagger
        """

        self._embed_url = None
        self._image_url = None
        self._markdown_body = None

        if embed_url is not None:
          self.embed_url = embed_url
        if image_url is not None:
          self.image_url = image_url
        if markdown_body is not None:
          self.markdown_body = markdown_body

    @property
    def embed_url(self):
        """
        Gets the embed_url of this InsightBody.
        oEmbed URL.

        :return: The embed_url of this InsightBody.
        :rtype: str
        """
        return self._embed_url

    @embed_url.setter
    def embed_url(self, embed_url):
        """
        Sets the embed_url of this InsightBody.
        oEmbed URL.

        :param embed_url: The embed_url of this InsightBody.
        :type: str
        """

        self._embed_url = embed_url

    @property
    def image_url(self):
        """
        Gets the image_url of this InsightBody.
        Image URL

        :return: The image_url of this InsightBody.
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """
        Sets the image_url of this InsightBody.
        Image URL

        :param image_url: The image_url of this InsightBody.
        :type: str
        """

        self._image_url = image_url

    @property
    def markdown_body(self):
        """
        Gets the markdown_body of this InsightBody.
        Markdown (deprecated)

        :return: The markdown_body of this InsightBody.
        :rtype: str
        """
        return self._markdown_body

    @markdown_body.setter
    def markdown_body(self, markdown_body):
        """
        Sets the markdown_body of this InsightBody.
        Markdown (deprecated)

        :param markdown_body: The markdown_body of this InsightBody.
        :type: str
        """

        self._markdown_body = markdown_body

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, InsightBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
