# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CatalogHydrationDto(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'agentid': 'str',
        'catalogid': 'str',
        'created_by': 'AgentHydrationDto',
        'description': 'str',
        'sources': 'list[SourceId]',
        'title': 'str',
        'type': 'str',
        'updated': 'datetime'
    }

    attribute_map = {
        'agentid': 'agentid',
        'catalogid': 'catalogid',
        'created_by': 'createdBy',
        'description': 'description',
        'sources': 'sources',
        'title': 'title',
        'type': 'type',
        'updated': 'updated'
    }

    def __init__(self, agentid=None, catalogid=None, created_by=None, description=None, sources=None, title=None, type=None, updated=None):
        """
        CatalogHydrationDto - a model defined in Swagger
        """

        self._agentid = None
        self._catalogid = None
        self._created_by = None
        self._description = None
        self._sources = None
        self._title = None
        self._type = None
        self._updated = None

        if agentid is not None:
          self.agentid = agentid
        if catalogid is not None:
          self.catalogid = catalogid
        if created_by is not None:
          self.created_by = created_by
        if description is not None:
          self.description = description
        if sources is not None:
          self.sources = sources
        if title is not None:
          self.title = title
        if type is not None:
          self.type = type
        if updated is not None:
          self.updated = updated

    @property
    def agentid(self):
        """
        Gets the agentid of this CatalogHydrationDto.

        :return: The agentid of this CatalogHydrationDto.
        :rtype: str
        """
        return self._agentid

    @agentid.setter
    def agentid(self, agentid):
        """
        Sets the agentid of this CatalogHydrationDto.

        :param agentid: The agentid of this CatalogHydrationDto.
        :type: str
        """

        self._agentid = agentid

    @property
    def catalogid(self):
        """
        Gets the catalogid of this CatalogHydrationDto.

        :return: The catalogid of this CatalogHydrationDto.
        :rtype: str
        """
        return self._catalogid

    @catalogid.setter
    def catalogid(self, catalogid):
        """
        Sets the catalogid of this CatalogHydrationDto.

        :param catalogid: The catalogid of this CatalogHydrationDto.
        :type: str
        """

        self._catalogid = catalogid

    @property
    def created_by(self):
        """
        Gets the created_by of this CatalogHydrationDto.

        :return: The created_by of this CatalogHydrationDto.
        :rtype: AgentHydrationDto
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this CatalogHydrationDto.

        :param created_by: The created_by of this CatalogHydrationDto.
        :type: AgentHydrationDto
        """

        self._created_by = created_by

    @property
    def description(self):
        """
        Gets the description of this CatalogHydrationDto.

        :return: The description of this CatalogHydrationDto.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CatalogHydrationDto.

        :param description: The description of this CatalogHydrationDto.
        :type: str
        """

        self._description = description

    @property
    def sources(self):
        """
        Gets the sources of this CatalogHydrationDto.

        :return: The sources of this CatalogHydrationDto.
        :rtype: list[SourceId]
        """
        return self._sources

    @sources.setter
    def sources(self, sources):
        """
        Sets the sources of this CatalogHydrationDto.

        :param sources: The sources of this CatalogHydrationDto.
        :type: list[SourceId]
        """

        self._sources = sources

    @property
    def title(self):
        """
        Gets the title of this CatalogHydrationDto.

        :return: The title of this CatalogHydrationDto.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this CatalogHydrationDto.

        :param title: The title of this CatalogHydrationDto.
        :type: str
        """

        self._title = title

    @property
    def type(self):
        """
        Gets the type of this CatalogHydrationDto.

        :return: The type of this CatalogHydrationDto.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CatalogHydrationDto.

        :param type: The type of this CatalogHydrationDto.
        :type: str
        """

        self._type = type

    @property
    def updated(self):
        """
        Gets the updated of this CatalogHydrationDto.

        :return: The updated of this CatalogHydrationDto.
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this CatalogHydrationDto.

        :param updated: The updated of this CatalogHydrationDto.
        :type: datetime
        """

        self._updated = updated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CatalogHydrationDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
