import time
from typing import Any

from .matcher import MQTTMatcher as MQTTMatcher
from .properties import Properties as Properties
from .reasoncodes import ReasonCodes as ReasonCodes
from .subscribeoptions import SubscribeOptions as SubscribeOptions

ssl: Any
socks: Any
time_func = time.monotonic
time_func = time.time
HAVE_DNS: bool
EAGAIN: Any
BlockingIOError = IOError
MQTTv31: int
MQTTv311: int
MQTTv5: int
unicode = str
basestring = str
CONNECT: int
CONNACK: int
PUBLISH: int
PUBACK: int
PUBREC: int
PUBREL: int
PUBCOMP: int
SUBSCRIBE: int
SUBACK: int
UNSUBSCRIBE: int
UNSUBACK: int
PINGREQ: int
PINGRESP: int
DISCONNECT: int
AUTH: int
MQTT_LOG_INFO: int
MQTT_LOG_NOTICE: int
MQTT_LOG_WARNING: int
MQTT_LOG_ERR: int
MQTT_LOG_DEBUG: int
LOGGING_LEVEL: Any
CONNACK_ACCEPTED: int
CONNACK_REFUSED_PROTOCOL_VERSION: int
CONNACK_REFUSED_IDENTIFIER_REJECTED: int
CONNACK_REFUSED_SERVER_UNAVAILABLE: int
CONNACK_REFUSED_BAD_USERNAME_PASSWORD: int
CONNACK_REFUSED_NOT_AUTHORIZED: int
mqtt_cs_new: int
mqtt_cs_connected: int
mqtt_cs_disconnecting: int
mqtt_cs_connect_async: int
mqtt_ms_invalid: int
mqtt_ms_publish: int
mqtt_ms_wait_for_puback: int
mqtt_ms_wait_for_pubrec: int
mqtt_ms_resend_pubrel: int
mqtt_ms_wait_for_pubrel: int
mqtt_ms_resend_pubcomp: int
mqtt_ms_wait_for_pubcomp: int
mqtt_ms_send_pubrec: int
mqtt_ms_queued: int
MQTT_ERR_AGAIN: int
MQTT_ERR_SUCCESS: int
MQTT_ERR_NOMEM: int
MQTT_ERR_PROTOCOL: int
MQTT_ERR_INVAL: int
MQTT_ERR_NO_CONN: int
MQTT_ERR_CONN_REFUSED: int
MQTT_ERR_NOT_FOUND: int
MQTT_ERR_CONN_LOST: int
MQTT_ERR_TLS: int
MQTT_ERR_PAYLOAD_SIZE: int
MQTT_ERR_NOT_SUPPORTED: int
MQTT_ERR_AUTH: int
MQTT_ERR_ACL_DENIED: int
MQTT_ERR_UNKNOWN: int
MQTT_ERR_ERRNO: int
MQTT_ERR_QUEUE_SIZE: int
MQTT_ERR_KEEPALIVE: int
MQTT_CLIENT: int
MQTT_BRIDGE: int
MQTT_CLEAN_START_FIRST_ONLY: int
sockpair_data: bytes

class WebsocketConnectionError(ValueError): ...

def error_string(mqtt_errno): ...
def connack_string(connack_code): ...
def base62(num, base=..., padding: int = ...): ...
def topic_matches_sub(sub, topic): ...

class MQTTMessageInfo:
    mid: Any
    rc: int
    def __init__(self, mid) -> None: ...
    def __iter__(self): ...
    def __next__(self): ...
    def next(self): ...
    def __getitem__(self, index): ...
    def wait_for_publish(self, timeout: Any | None = ...): ...
    def is_published(self): ...

class MQTTMessage:
    timestamp: int
    state: Any
    dup: bool
    mid: Any
    payload: bytes
    qos: int
    retain: bool
    info: Any
    def __init__(self, mid: int = ..., topic: bytes = ...) -> None: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    @property
    def topic(self): ...
    @topic.setter
    def topic(self, value) -> None: ...

class Client:
    suppress_exceptions: bool
    def __init__(
        self,
        client_id: str = ...,
        clean_session: Any | None = ...,
        userdata: Any | None = ...,
        protocol=...,
        transport: str = ...,
        reconnect_on_failure: bool = ...,
    ) -> None: ...
    def __del__(self) -> None: ...
    def reinitialise(
        self,
        client_id: str = ...,
        clean_session: bool = ...,
        userdata: Any | None = ...,
    ) -> None: ...
    def ws_set_options(self, path: str = ..., headers: Any | None = ...) -> None: ...
    def tls_set_context(self, context: Any | None = ...) -> None: ...
    def tls_set(
        self,
        ca_certs: Any | None = ...,
        certfile: Any | None = ...,
        keyfile: Any | None = ...,
        cert_reqs: Any | None = ...,
        tls_version: Any | None = ...,
        ciphers: Any | None = ...,
        keyfile_password: Any | None = ...,
    ) -> None: ...
    def tls_insecure_set(self, value) -> None: ...
    def proxy_set(self, **proxy_args) -> None: ...
    def enable_logger(self, logger: Any | None = ...) -> None: ...
    def disable_logger(self) -> None: ...
    def connect(
        self,
        host,
        port: int = ...,
        keepalive: int = ...,
        bind_address: str = ...,
        bind_port: int = ...,
        clean_start=...,
        properties: Any | None = ...,
    ): ...
    def connect_srv(
        self,
        domain: Any | None = ...,
        keepalive: int = ...,
        bind_address: str = ...,
        clean_start=...,
        properties: Any | None = ...,
    ): ...
    def connect_async(
        self,
        host,
        port: int = ...,
        keepalive: int = ...,
        bind_address: str = ...,
        bind_port: int = ...,
        clean_start=...,
        properties: Any | None = ...,
    ) -> None: ...
    def reconnect_delay_set(
        self, min_delay: int = ..., max_delay: int = ...
    ) -> None: ...
    def reconnect(self): ...
    def loop(self, timeout: float = ..., max_packets: int = ...): ...
    def publish(
        self,
        topic,
        payload: Any | None = ...,
        qos: int = ...,
        retain: bool = ...,
        properties: Any | None = ...,
    ): ...
    def username_pw_set(self, username, password: Any | None = ...) -> None: ...
    def enable_bridge_mode(self) -> None: ...
    def is_connected(self): ...
    def disconnect(
        self, reasoncode: Any | None = ..., properties: Any | None = ...
    ): ...
    def subscribe(
        self,
        topic,
        qos: int = ...,
        options: Any | None = ...,
        properties: Any | None = ...,
    ): ...
    def unsubscribe(self, topic, properties: Any | None = ...): ...
    def loop_read(self, max_packets: int = ...): ...
    def loop_write(self, max_packets: int = ...): ...
    def want_write(self): ...
    def loop_misc(self): ...
    def max_inflight_messages_set(self, inflight) -> None: ...
    def max_queued_messages_set(self, queue_size): ...
    def message_retry_set(self, retry) -> None: ...
    def user_data_set(self, userdata) -> None: ...
    def will_set(
        self,
        topic,
        payload: Any | None = ...,
        qos: int = ...,
        retain: bool = ...,
        properties: Any | None = ...,
    ) -> None: ...
    def will_clear(self) -> None: ...
    def socket(self): ...
    def loop_forever(
        self,
        timeout: float = ...,
        max_packets: int = ...,
        retry_first_connection: bool = ...,
    ): ...
    def loop_start(self): ...
    def loop_stop(self, force: bool = ...): ...
    @property
    def on_log(self): ...
    @on_log.setter
    def on_log(self, func) -> None: ...
    def log_callback(self): ...
    @property
    def on_connect(self): ...
    @on_connect.setter
    def on_connect(self, func) -> None: ...
    def connect_callback(self): ...
    @property
    def on_connect_fail(self): ...
    @on_connect_fail.setter
    def on_connect_fail(self, func) -> None: ...
    def connect_fail_callback(self): ...
    @property
    def on_subscribe(self): ...
    @on_subscribe.setter
    def on_subscribe(self, func) -> None: ...
    def subscribe_callback(self): ...
    @property
    def on_message(self): ...
    @on_message.setter
    def on_message(self, func) -> None: ...
    def message_callback(self): ...
    @property
    def on_publish(self): ...
    @on_publish.setter
    def on_publish(self, func) -> None: ...
    def publish_callback(self): ...
    @property
    def on_unsubscribe(self): ...
    @on_unsubscribe.setter
    def on_unsubscribe(self, func) -> None: ...
    def unsubscribe_callback(self): ...
    @property
    def on_disconnect(self): ...
    @on_disconnect.setter
    def on_disconnect(self, func) -> None: ...
    def disconnect_callback(self): ...
    @property
    def on_socket_open(self): ...
    @on_socket_open.setter
    def on_socket_open(self, func) -> None: ...
    def socket_open_callback(self): ...
    @property
    def on_socket_close(self): ...
    @on_socket_close.setter
    def on_socket_close(self, func) -> None: ...
    def socket_close_callback(self): ...
    @property
    def on_socket_register_write(self): ...
    @on_socket_register_write.setter
    def on_socket_register_write(self, func) -> None: ...
    def socket_register_write_callback(self): ...
    @property
    def on_socket_unregister_write(self): ...
    @on_socket_unregister_write.setter
    def on_socket_unregister_write(self, func) -> None: ...
    def socket_unregister_write_callback(self): ...
    def message_callback_add(self, sub, callback) -> None: ...
    def topic_callback(self, sub): ...
    def message_callback_remove(self, sub) -> None: ...

class WebsocketWrapper:
    OPCODE_CONTINUATION: int
    OPCODE_TEXT: int
    OPCODE_BINARY: int
    OPCODE_CONNCLOSE: int
    OPCODE_PING: int
    OPCODE_PONG: int
    connected: bool
    def __init__(self, socket, host, port, is_ssl, path, extra_headers) -> None: ...
    def __del__(self) -> None: ...
    def recv(self, length): ...
    def read(self, length): ...
    def send(self, data): ...
    def write(self, data): ...
    def close(self) -> None: ...
    def fileno(self): ...
    def pending(self): ...
    def setblocking(self, flag) -> None: ...
