# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ProcedureSignature(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'hard_hash': 'str',
        'is_library': 'bool',
        'status': 'str',
        'coverage': 'float',
        'byte_counts': 'list[int]',
        'instr_counts': 'list[int]',
        'block_counts': 'list[int]',
        'occurrence_counts': 'int',
        'procedure_names': 'list[str]',
        'name_counts': 'int',
        'signature': 'list[list[str]]',
        'example_procedure': 'list[list[str]]'
    }

    attribute_map = {
        'hard_hash': 'hard_hash',
        'is_library': 'is_library',
        'status': 'status',
        'coverage': 'coverage',
        'byte_counts': 'byte_counts',
        'instr_counts': 'instr_counts',
        'block_counts': 'block_counts',
        'occurrence_counts': 'occurrence_counts',
        'procedure_names': 'procedure_names',
        'name_counts': 'name_counts',
        'signature': 'signature',
        'example_procedure': 'example_procedure'
    }

    def __init__(self, hard_hash=None, is_library=None, status=None, coverage=None, byte_counts=None, instr_counts=None, block_counts=None, occurrence_counts=None, procedure_names=None, name_counts=None, signature=None, example_procedure=None):  # noqa: E501
        """ProcedureSignature - a model defined in Swagger"""  # noqa: E501

        self._hard_hash = None
        self._is_library = None
        self._status = None
        self._coverage = None
        self._byte_counts = None
        self._instr_counts = None
        self._block_counts = None
        self._occurrence_counts = None
        self._procedure_names = None
        self._name_counts = None
        self._signature = None
        self._example_procedure = None
        self.discriminator = None

        if hard_hash is not None:
            self.hard_hash = hard_hash
        if is_library is not None:
            self.is_library = is_library
        if status is not None:
            self.status = status
        if coverage is not None:
            self.coverage = coverage
        if byte_counts is not None:
            self.byte_counts = byte_counts
        if instr_counts is not None:
            self.instr_counts = instr_counts
        if block_counts is not None:
            self.block_counts = block_counts
        if occurrence_counts is not None:
            self.occurrence_counts = occurrence_counts
        if procedure_names is not None:
            self.procedure_names = procedure_names
        if name_counts is not None:
            self.name_counts = name_counts
        if signature is not None:
            self.signature = signature
        if example_procedure is not None:
            self.example_procedure = example_procedure

    @property
    def hard_hash(self):
        """Gets the hard_hash of this ProcedureSignature.  # noqa: E501

        The proc hash for this procedure group.  # noqa: E501

        :return: The hard_hash of this ProcedureSignature.  # noqa: E501
        :rtype: str
        """
        return self._hard_hash

    @hard_hash.setter
    def hard_hash(self, hard_hash):
        """Sets the hard_hash of this ProcedureSignature.

        The proc hash for this procedure group.  # noqa: E501

        :param hard_hash: The hard_hash of this ProcedureSignature.  # noqa: E501
        :type: str
        """
        if hard_hash is not None and not re.search('[a-fA-F0-9]{32}', hard_hash):  # noqa: E501
            raise ValueError("Invalid value for `hard_hash`, must be a follow pattern or equal to `/[a-fA-F0-9]{32}/`")  # noqa: E501

        self._hard_hash = hard_hash

    @property
    def is_library(self):
        """Gets the is_library of this ProcedureSignature.  # noqa: E501

        Is one or more procedures in this group marked as a library function?  # noqa: E501

        :return: The is_library of this ProcedureSignature.  # noqa: E501
        :rtype: bool
        """
        return self._is_library

    @is_library.setter
    def is_library(self, is_library):
        """Sets the is_library of this ProcedureSignature.

        Is one or more procedures in this group marked as a library function?  # noqa: E501

        :param is_library: The is_library of this ProcedureSignature.  # noqa: E501
        :type: bool
        """

        self._is_library = is_library

    @property
    def status(self):
        """Gets the status of this ProcedureSignature.  # noqa: E501

        Indicates the current status of the signature. Must be one of the following -    empty - No procedure added to the group   clone - All the procedures in the group are clones   variant-{blocks,instr,bytes} - Procedures had a different number of {blocks,instr,bytes}   variant-alignment - Procedures have the same number of {blocks,instr,bytes}, but something else isn't lining up  # noqa: E501

        :return: The status of this ProcedureSignature.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ProcedureSignature.

        Indicates the current status of the signature. Must be one of the following -    empty - No procedure added to the group   clone - All the procedures in the group are clones   variant-{blocks,instr,bytes} - Procedures had a different number of {blocks,instr,bytes}   variant-alignment - Procedures have the same number of {blocks,instr,bytes}, but something else isn't lining up  # noqa: E501

        :param status: The status of this ProcedureSignature.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def coverage(self):
        """Gets the coverage of this ProcedureSignature.  # noqa: E501

        Percentage of given binaries this procedure is in. Will be between 0 and 1 inclusive.  # noqa: E501

        :return: The coverage of this ProcedureSignature.  # noqa: E501
        :rtype: float
        """
        return self._coverage

    @coverage.setter
    def coverage(self, coverage):
        """Sets the coverage of this ProcedureSignature.

        Percentage of given binaries this procedure is in. Will be between 0 and 1 inclusive.  # noqa: E501

        :param coverage: The coverage of this ProcedureSignature.  # noqa: E501
        :type: float
        """

        self._coverage = coverage

    @property
    def byte_counts(self):
        """Gets the byte_counts of this ProcedureSignature.  # noqa: E501


        :return: The byte_counts of this ProcedureSignature.  # noqa: E501
        :rtype: list[int]
        """
        return self._byte_counts

    @byte_counts.setter
    def byte_counts(self, byte_counts):
        """Sets the byte_counts of this ProcedureSignature.


        :param byte_counts: The byte_counts of this ProcedureSignature.  # noqa: E501
        :type: list[int]
        """

        self._byte_counts = byte_counts

    @property
    def instr_counts(self):
        """Gets the instr_counts of this ProcedureSignature.  # noqa: E501


        :return: The instr_counts of this ProcedureSignature.  # noqa: E501
        :rtype: list[int]
        """
        return self._instr_counts

    @instr_counts.setter
    def instr_counts(self, instr_counts):
        """Sets the instr_counts of this ProcedureSignature.


        :param instr_counts: The instr_counts of this ProcedureSignature.  # noqa: E501
        :type: list[int]
        """

        self._instr_counts = instr_counts

    @property
    def block_counts(self):
        """Gets the block_counts of this ProcedureSignature.  # noqa: E501


        :return: The block_counts of this ProcedureSignature.  # noqa: E501
        :rtype: list[int]
        """
        return self._block_counts

    @block_counts.setter
    def block_counts(self, block_counts):
        """Sets the block_counts of this ProcedureSignature.


        :param block_counts: The block_counts of this ProcedureSignature.  # noqa: E501
        :type: list[int]
        """

        self._block_counts = block_counts

    @property
    def occurrence_counts(self):
        """Gets the occurrence_counts of this ProcedureSignature.  # noqa: E501

        Number of ProcedureGenomics objects with the same hard_hash.  # noqa: E501

        :return: The occurrence_counts of this ProcedureSignature.  # noqa: E501
        :rtype: int
        """
        return self._occurrence_counts

    @occurrence_counts.setter
    def occurrence_counts(self, occurrence_counts):
        """Sets the occurrence_counts of this ProcedureSignature.

        Number of ProcedureGenomics objects with the same hard_hash.  # noqa: E501

        :param occurrence_counts: The occurrence_counts of this ProcedureSignature.  # noqa: E501
        :type: int
        """

        self._occurrence_counts = occurrence_counts

    @property
    def procedure_names(self):
        """Gets the procedure_names of this ProcedureSignature.  # noqa: E501


        :return: The procedure_names of this ProcedureSignature.  # noqa: E501
        :rtype: list[str]
        """
        return self._procedure_names

    @procedure_names.setter
    def procedure_names(self, procedure_names):
        """Sets the procedure_names of this ProcedureSignature.


        :param procedure_names: The procedure_names of this ProcedureSignature.  # noqa: E501
        :type: list[str]
        """

        self._procedure_names = procedure_names

    @property
    def name_counts(self):
        """Gets the name_counts of this ProcedureSignature.  # noqa: E501

        Number of unique procedures in this procedure group  # noqa: E501

        :return: The name_counts of this ProcedureSignature.  # noqa: E501
        :rtype: int
        """
        return self._name_counts

    @name_counts.setter
    def name_counts(self, name_counts):
        """Sets the name_counts of this ProcedureSignature.

        Number of unique procedures in this procedure group  # noqa: E501

        :param name_counts: The name_counts of this ProcedureSignature.  # noqa: E501
        :type: int
        """

        self._name_counts = name_counts

    @property
    def signature(self):
        """Gets the signature of this ProcedureSignature.  # noqa: E501


        :return: The signature of this ProcedureSignature.  # noqa: E501
        :rtype: list[list[str]]
        """
        return self._signature

    @signature.setter
    def signature(self, signature):
        """Sets the signature of this ProcedureSignature.


        :param signature: The signature of this ProcedureSignature.  # noqa: E501
        :type: list[list[str]]
        """

        self._signature = signature

    @property
    def example_procedure(self):
        """Gets the example_procedure of this ProcedureSignature.  # noqa: E501


        :return: The example_procedure of this ProcedureSignature.  # noqa: E501
        :rtype: list[list[str]]
        """
        return self._example_procedure

    @example_procedure.setter
    def example_procedure(self, example_procedure):
        """Sets the example_procedure of this ProcedureSignature.


        :param example_procedure: The example_procedure of this ProcedureSignature.  # noqa: E501
        :type: list[list[str]]
        """

        self._example_procedure = example_procedure

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProcedureSignature):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
