# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cythereal_magic.models.analysis_status import AnalysisStatus  # noqa: F401,E501


class FileStatus(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sha1': 'str',
        'status': 'str',
        'file_type': 'str',
        'first_upload': 'datetime',
        'analysis': 'list[AnalysisStatus]'
    }

    attribute_map = {
        'sha1': 'sha1',
        'status': 'status',
        'file_type': 'file_type',
        'first_upload': 'first_upload',
        'analysis': 'analysis'
    }

    def __init__(self, sha1=None, status=None, file_type=None, first_upload=None, analysis=None):  # noqa: E501
        """FileStatus - a model defined in Swagger"""  # noqa: E501

        self._sha1 = None
        self._status = None
        self._file_type = None
        self._first_upload = None
        self._analysis = None
        self.discriminator = None

        self.sha1 = sha1
        self.status = status
        if file_type is not None:
            self.file_type = file_type
        if first_upload is not None:
            self.first_upload = first_upload
        if analysis is not None:
            self.analysis = analysis

    @property
    def sha1(self):
        """Gets the sha1 of this FileStatus.  # noqa: E501

        A SHA1 cryptographic hash  # noqa: E501

        :return: The sha1 of this FileStatus.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this FileStatus.

        A SHA1 cryptographic hash  # noqa: E501

        :param sha1: The sha1 of this FileStatus.  # noqa: E501
        :type: str
        """
        if sha1 is None:
            raise ValueError("Invalid value for `sha1`, must not be `None`")  # noqa: E501
        if sha1 is not None and not re.search('[a-fA-F0-9]{40}', sha1):  # noqa: E501
            raise ValueError("Invalid value for `sha1`, must be a follow pattern or equal to `/[a-fA-F0-9]{40}/`")  # noqa: E501

        self._sha1 = sha1

    @property
    def status(self):
        """Gets the status of this FileStatus.  # noqa: E501

        One of: - **pending**: Processing has not started yet. - **in progress**: Processing has begun, but not all analysis are complete. - **success**: All analysis successfully completed. - **error**: At least one analysis returned an error. * **none**: File is not a file type that is analyzed.   # noqa: E501

        :return: The status of this FileStatus.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this FileStatus.

        One of: - **pending**: Processing has not started yet. - **in progress**: Processing has begun, but not all analysis are complete. - **success**: All analysis successfully completed. - **error**: At least one analysis returned an error. * **none**: File is not a file type that is analyzed.   # noqa: E501

        :param status: The status of this FileStatus.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["pending", "in progress", "success", "error", "none"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def file_type(self):
        """Gets the file_type of this FileStatus.  # noqa: E501

        The unix filetype of the file  # noqa: E501

        :return: The file_type of this FileStatus.  # noqa: E501
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """Sets the file_type of this FileStatus.

        The unix filetype of the file  # noqa: E501

        :param file_type: The file_type of this FileStatus.  # noqa: E501
        :type: str
        """

        self._file_type = file_type

    @property
    def first_upload(self):
        """Gets the first_upload of this FileStatus.  # noqa: E501

        The timestamp of the original upload.  # noqa: E501

        :return: The first_upload of this FileStatus.  # noqa: E501
        :rtype: datetime
        """
        return self._first_upload

    @first_upload.setter
    def first_upload(self, first_upload):
        """Sets the first_upload of this FileStatus.

        The timestamp of the original upload.  # noqa: E501

        :param first_upload: The first_upload of this FileStatus.  # noqa: E501
        :type: datetime
        """

        self._first_upload = first_upload

    @property
    def analysis(self):
        """Gets the analysis of this FileStatus.  # noqa: E501

        Status of each individual analysis. The exact contents of this list is not guaranteed and will change over time as we add or modify the analyses that we support.  Not every file will go through every analysis. For example, a zip file goes through archive extraction only.  The (potentially incomplete) list of analysis types: - **genomics**: Extracting the genomics from the binary. - **matches**: Finding the MAGIC matches of a binary. - **labels**: Assigning labels to the binary. - **campaigns**: Adding binaries to a campaign. - **unpacking**: Unpacking the binary and analyzing the unpacked binary. - **archive_extraction**: Extract files from an archive (e.g., unzip a zip file).   # noqa: E501

        :return: The analysis of this FileStatus.  # noqa: E501
        :rtype: list[AnalysisStatus]
        """
        return self._analysis

    @analysis.setter
    def analysis(self, analysis):
        """Sets the analysis of this FileStatus.

        Status of each individual analysis. The exact contents of this list is not guaranteed and will change over time as we add or modify the analyses that we support.  Not every file will go through every analysis. For example, a zip file goes through archive extraction only.  The (potentially incomplete) list of analysis types: - **genomics**: Extracting the genomics from the binary. - **matches**: Finding the MAGIC matches of a binary. - **labels**: Assigning labels to the binary. - **campaigns**: Adding binaries to a campaign. - **unpacking**: Unpacking the binary and analyzing the unpacked binary. - **archive_extraction**: Extract files from an archive (e.g., unzip a zip file).   # noqa: E501

        :param analysis: The analysis of this FileStatus.  # noqa: E501
        :type: list[AnalysisStatus]
        """

        self._analysis = analysis

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
