# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cythereal_magic.models.child_info import ChildInfo  # noqa: F401,E501


class FileInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sha1': 'str',
        'sha256': 'str',
        'sha512': 'str',
        'md5': 'str',
        'unix_filetype': 'str',
        'object_class': 'str',
        'filename': 'list[str]',
        'upload_date': 'datetime',
        'parents': 'list[str]',
        'children': 'list[ChildInfo]'
    }

    attribute_map = {
        'sha1': 'sha1',
        'sha256': 'sha256',
        'sha512': 'sha512',
        'md5': 'md5',
        'unix_filetype': 'unix_filetype',
        'object_class': 'object_class',
        'filename': 'filename',
        'upload_date': 'upload_date',
        'parents': 'parents',
        'children': 'children'
    }

    def __init__(self, sha1=None, sha256=None, sha512=None, md5=None, unix_filetype=None, object_class=None, filename=None, upload_date=None, parents=None, children=None):  # noqa: E501
        """FileInfo - a model defined in Swagger"""  # noqa: E501

        self._sha1 = None
        self._sha256 = None
        self._sha512 = None
        self._md5 = None
        self._unix_filetype = None
        self._object_class = None
        self._filename = None
        self._upload_date = None
        self._parents = None
        self._children = None
        self.discriminator = None

        self.sha1 = sha1
        if sha256 is not None:
            self.sha256 = sha256
        if sha512 is not None:
            self.sha512 = sha512
        if md5 is not None:
            self.md5 = md5
        if unix_filetype is not None:
            self.unix_filetype = unix_filetype
        if object_class is not None:
            self.object_class = object_class
        if filename is not None:
            self.filename = filename
        if upload_date is not None:
            self.upload_date = upload_date
        if parents is not None:
            self.parents = parents
        if children is not None:
            self.children = children

    @property
    def sha1(self):
        """Gets the sha1 of this FileInfo.  # noqa: E501

        A SHA1 cryptographic hash  # noqa: E501

        :return: The sha1 of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this FileInfo.

        A SHA1 cryptographic hash  # noqa: E501

        :param sha1: The sha1 of this FileInfo.  # noqa: E501
        :type: str
        """
        if sha1 is None:
            raise ValueError("Invalid value for `sha1`, must not be `None`")  # noqa: E501
        if sha1 is not None and not re.search('[a-fA-F0-9]{40}', sha1):  # noqa: E501
            raise ValueError("Invalid value for `sha1`, must be a follow pattern or equal to `/[a-fA-F0-9]{40}/`")  # noqa: E501

        self._sha1 = sha1

    @property
    def sha256(self):
        """Gets the sha256 of this FileInfo.  # noqa: E501

        A SHA256 cryptographic hash  # noqa: E501

        :return: The sha256 of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this FileInfo.

        A SHA256 cryptographic hash  # noqa: E501

        :param sha256: The sha256 of this FileInfo.  # noqa: E501
        :type: str
        """
        if sha256 is not None and not re.search('[a-fA-F0-9]{64}', sha256):  # noqa: E501
            raise ValueError("Invalid value for `sha256`, must be a follow pattern or equal to `/[a-fA-F0-9]{64}/`")  # noqa: E501

        self._sha256 = sha256

    @property
    def sha512(self):
        """Gets the sha512 of this FileInfo.  # noqa: E501

        A SHA512 cryptographic hash  # noqa: E501

        :return: The sha512 of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._sha512

    @sha512.setter
    def sha512(self, sha512):
        """Sets the sha512 of this FileInfo.

        A SHA512 cryptographic hash  # noqa: E501

        :param sha512: The sha512 of this FileInfo.  # noqa: E501
        :type: str
        """
        if sha512 is not None and not re.search('[a-fA-F0-9]{128}', sha512):  # noqa: E501
            raise ValueError("Invalid value for `sha512`, must be a follow pattern or equal to `/[a-fA-F0-9]{128}/`")  # noqa: E501

        self._sha512 = sha512

    @property
    def md5(self):
        """Gets the md5 of this FileInfo.  # noqa: E501

        An MD5 cryptographic hash  # noqa: E501

        :return: The md5 of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this FileInfo.

        An MD5 cryptographic hash  # noqa: E501

        :param md5: The md5 of this FileInfo.  # noqa: E501
        :type: str
        """
        if md5 is not None and not re.search('[a-fA-F0-9]{32}', md5):  # noqa: E501
            raise ValueError("Invalid value for `md5`, must be a follow pattern or equal to `/[a-fA-F0-9]{32}/`")  # noqa: E501

        self._md5 = md5

    @property
    def unix_filetype(self):
        """Gets the unix_filetype of this FileInfo.  # noqa: E501

        Output of the unix `file` command for the file.  # noqa: E501

        :return: The unix_filetype of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._unix_filetype

    @unix_filetype.setter
    def unix_filetype(self, unix_filetype):
        """Sets the unix_filetype of this FileInfo.

        Output of the unix `file` command for the file.  # noqa: E501

        :param unix_filetype: The unix_filetype of this FileInfo.  # noqa: E501
        :type: str
        """

        self._unix_filetype = unix_filetype

    @property
    def object_class(self):
        """Gets the object_class of this FileInfo.  # noqa: E501

        An internal indicator of the type of object this file is.  # noqa: E501

        :return: The object_class of this FileInfo.  # noqa: E501
        :rtype: str
        """
        return self._object_class

    @object_class.setter
    def object_class(self, object_class):
        """Sets the object_class of this FileInfo.

        An internal indicator of the type of object this file is.  # noqa: E501

        :param object_class: The object_class of this FileInfo.  # noqa: E501
        :type: str
        """

        self._object_class = object_class

    @property
    def filename(self):
        """Gets the filename of this FileInfo.  # noqa: E501

        The original file names associated with the file.  # noqa: E501

        :return: The filename of this FileInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this FileInfo.

        The original file names associated with the file.  # noqa: E501

        :param filename: The filename of this FileInfo.  # noqa: E501
        :type: list[str]
        """

        self._filename = filename

    @property
    def upload_date(self):
        """Gets the upload_date of this FileInfo.  # noqa: E501

        The timestamp of the original upload  # noqa: E501

        :return: The upload_date of this FileInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._upload_date

    @upload_date.setter
    def upload_date(self, upload_date):
        """Sets the upload_date of this FileInfo.

        The timestamp of the original upload  # noqa: E501

        :param upload_date: The upload_date of this FileInfo.  # noqa: E501
        :type: datetime
        """

        self._upload_date = upload_date

    @property
    def parents(self):
        """Gets the parents of this FileInfo.  # noqa: E501

        The SHA1 of the file(s) that this file was generated from.  Can be empty if this file has no children.  # noqa: E501

        :return: The parents of this FileInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._parents

    @parents.setter
    def parents(self, parents):
        """Sets the parents of this FileInfo.

        The SHA1 of the file(s) that this file was generated from.  Can be empty if this file has no children.  # noqa: E501

        :param parents: The parents of this FileInfo.  # noqa: E501
        :type: list[str]
        """

        self._parents = parents

    @property
    def children(self):
        """Gets the children of this FileInfo.  # noqa: E501

        The list of files that were created from this file.  # noqa: E501

        :return: The children of this FileInfo.  # noqa: E501
        :rtype: list[ChildInfo]
        """
        return self._children

    @children.setter
    def children(self, children):
        """Sets the children of this FileInfo.

        The list of files that were created from this file.  # noqa: E501

        :param children: The children of this FileInfo.  # noqa: E501
        :type: list[ChildInfo]
        """

        self._children = children

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
