# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class BlockGenomics(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'start_ea': 'str',
        'end_ea': 'str',
        'bytes': 'list[str]',
        'code': 'list[str]',
        'gen_code': 'list[str]',
        'semantics': 'list[str]',
        'gen_semantics': 'list[str]'
    }

    attribute_map = {
        'start_ea': 'startEA',
        'end_ea': 'endEA',
        'bytes': 'bytes',
        'code': 'code',
        'gen_code': 'gen_code',
        'semantics': 'semantics',
        'gen_semantics': 'gen_semantics'
    }

    def __init__(self, start_ea=None, end_ea=None, bytes=None, code=None, gen_code=None, semantics=None, gen_semantics=None):  # noqa: E501
        """BlockGenomics - a model defined in Swagger"""  # noqa: E501

        self._start_ea = None
        self._end_ea = None
        self._bytes = None
        self._code = None
        self._gen_code = None
        self._semantics = None
        self._gen_semantics = None
        self.discriminator = None

        if start_ea is not None:
            self.start_ea = start_ea
        if end_ea is not None:
            self.end_ea = end_ea
        if bytes is not None:
            self.bytes = bytes
        if code is not None:
            self.code = code
        if gen_code is not None:
            self.gen_code = gen_code
        if semantics is not None:
            self.semantics = semantics
        if gen_semantics is not None:
            self.gen_semantics = gen_semantics

    @property
    def start_ea(self):
        """Gets the start_ea of this BlockGenomics.  # noqa: E501

        A memory address (usually an RVA).  # noqa: E501

        :return: The start_ea of this BlockGenomics.  # noqa: E501
        :rtype: str
        """
        return self._start_ea

    @start_ea.setter
    def start_ea(self, start_ea):
        """Sets the start_ea of this BlockGenomics.

        A memory address (usually an RVA).  # noqa: E501

        :param start_ea: The start_ea of this BlockGenomics.  # noqa: E501
        :type: str
        """
        if start_ea is not None and not re.search('0x[a-fA-F0-9]+', start_ea):  # noqa: E501
            raise ValueError("Invalid value for `start_ea`, must be a follow pattern or equal to `/0x[a-fA-F0-9]+/`")  # noqa: E501

        self._start_ea = start_ea

    @property
    def end_ea(self):
        """Gets the end_ea of this BlockGenomics.  # noqa: E501

        A memory address (usually an RVA).  # noqa: E501

        :return: The end_ea of this BlockGenomics.  # noqa: E501
        :rtype: str
        """
        return self._end_ea

    @end_ea.setter
    def end_ea(self, end_ea):
        """Sets the end_ea of this BlockGenomics.

        A memory address (usually an RVA).  # noqa: E501

        :param end_ea: The end_ea of this BlockGenomics.  # noqa: E501
        :type: str
        """
        if end_ea is not None and not re.search('0x[a-fA-F0-9]+', end_ea):  # noqa: E501
            raise ValueError("Invalid value for `end_ea`, must be a follow pattern or equal to `/0x[a-fA-F0-9]+/`")  # noqa: E501

        self._end_ea = end_ea

    @property
    def bytes(self):
        """Gets the bytes of this BlockGenomics.  # noqa: E501

        The raw bytes of the block.  Each item in the array contains the bytes for a single instruction.  The array is sorted by startEA (RVA) of the instructions.   # noqa: E501

        :return: The bytes of this BlockGenomics.  # noqa: E501
        :rtype: list[str]
        """
        return self._bytes

    @bytes.setter
    def bytes(self, bytes):
        """Sets the bytes of this BlockGenomics.

        The raw bytes of the block.  Each item in the array contains the bytes for a single instruction.  The array is sorted by startEA (RVA) of the instructions.   # noqa: E501

        :param bytes: The bytes of this BlockGenomics.  # noqa: E501
        :type: list[str]
        """

        self._bytes = bytes

    @property
    def code(self):
        """Gets the code of this BlockGenomics.  # noqa: E501

        The list of disassembly instructions in this block. Disassembly is formatted into functions.  # noqa: E501

        :return: The code of this BlockGenomics.  # noqa: E501
        :rtype: list[str]
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this BlockGenomics.

        The list of disassembly instructions in this block. Disassembly is formatted into functions.  # noqa: E501

        :param code: The code of this BlockGenomics.  # noqa: E501
        :type: list[str]
        """

        self._code = code

    @property
    def gen_code(self):
        """Gets the gen_code of this BlockGenomics.  # noqa: E501

        The list of generalized disassembly.  This is the same as `code`, but with the operands in code abstracted to variables instead of register names.  # noqa: E501

        :return: The gen_code of this BlockGenomics.  # noqa: E501
        :rtype: list[str]
        """
        return self._gen_code

    @gen_code.setter
    def gen_code(self, gen_code):
        """Sets the gen_code of this BlockGenomics.

        The list of generalized disassembly.  This is the same as `code`, but with the operands in code abstracted to variables instead of register names.  # noqa: E501

        :param gen_code: The gen_code of this BlockGenomics.  # noqa: E501
        :type: list[str]
        """

        self._gen_code = gen_code

    @property
    def semantics(self):
        """Gets the semantics of this BlockGenomics.  # noqa: E501

        The semantics of the instructions in `code`. This array contains the effect that executing the  represented block will have on registers and memory locations.  # noqa: E501

        :return: The semantics of this BlockGenomics.  # noqa: E501
        :rtype: list[str]
        """
        return self._semantics

    @semantics.setter
    def semantics(self, semantics):
        """Sets the semantics of this BlockGenomics.

        The semantics of the instructions in `code`. This array contains the effect that executing the  represented block will have on registers and memory locations.  # noqa: E501

        :param semantics: The semantics of this BlockGenomics.  # noqa: E501
        :type: list[str]
        """

        self._semantics = semantics

    @property
    def gen_semantics(self):
        """Gets the gen_semantics of this BlockGenomics.  # noqa: E501

        Generalized semantics.  his is the same as `semantics` but with registers and memory locations abstracted to variables.  # noqa: E501

        :return: The gen_semantics of this BlockGenomics.  # noqa: E501
        :rtype: list[str]
        """
        return self._gen_semantics

    @gen_semantics.setter
    def gen_semantics(self, gen_semantics):
        """Sets the gen_semantics of this BlockGenomics.

        Generalized semantics.  his is the same as `semantics` but with registers and memory locations abstracted to variables.  # noqa: E501

        :param gen_semantics: The gen_semantics of this BlockGenomics.  # noqa: E501
        :type: list[str]
        """

        self._gen_semantics = gen_semantics

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlockGenomics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
