# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cythereal_magic.models.procedure_genomics import ProcedureGenomics  # noqa: F401,E501


class BinaryGenomics(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'md5': 'str',
        'sha1': 'str',
        'sha256': 'str',
        'sha512': 'str',
        'image_base': 'str',
        'procedure_count': 'int',
        'code_count': 'int',
        'semantics_count': 'int',
        'procedures': 'list[ProcedureGenomics]'
    }

    attribute_map = {
        'md5': 'md5',
        'sha1': 'sha1',
        'sha256': 'sha256',
        'sha512': 'sha512',
        'image_base': 'image_base',
        'procedure_count': 'procedure_count',
        'code_count': 'code_count',
        'semantics_count': 'semantics_count',
        'procedures': 'procedures'
    }

    def __init__(self, md5=None, sha1=None, sha256=None, sha512=None, image_base=None, procedure_count=None, code_count=None, semantics_count=None, procedures=None):  # noqa: E501
        """BinaryGenomics - a model defined in Swagger"""  # noqa: E501

        self._md5 = None
        self._sha1 = None
        self._sha256 = None
        self._sha512 = None
        self._image_base = None
        self._procedure_count = None
        self._code_count = None
        self._semantics_count = None
        self._procedures = None
        self.discriminator = None

        if md5 is not None:
            self.md5 = md5
        if sha1 is not None:
            self.sha1 = sha1
        if sha256 is not None:
            self.sha256 = sha256
        if sha512 is not None:
            self.sha512 = sha512
        if image_base is not None:
            self.image_base = image_base
        if procedure_count is not None:
            self.procedure_count = procedure_count
        if code_count is not None:
            self.code_count = code_count
        if semantics_count is not None:
            self.semantics_count = semantics_count
        if procedures is not None:
            self.procedures = procedures

    @property
    def md5(self):
        """Gets the md5 of this BinaryGenomics.  # noqa: E501

        An MD5 cryptographic hash  # noqa: E501

        :return: The md5 of this BinaryGenomics.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this BinaryGenomics.

        An MD5 cryptographic hash  # noqa: E501

        :param md5: The md5 of this BinaryGenomics.  # noqa: E501
        :type: str
        """
        if md5 is not None and not re.search('[a-fA-F0-9]{32}', md5):  # noqa: E501
            raise ValueError("Invalid value for `md5`, must be a follow pattern or equal to `/[a-fA-F0-9]{32}/`")  # noqa: E501

        self._md5 = md5

    @property
    def sha1(self):
        """Gets the sha1 of this BinaryGenomics.  # noqa: E501

        A SHA1 cryptographic hash  # noqa: E501

        :return: The sha1 of this BinaryGenomics.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this BinaryGenomics.

        A SHA1 cryptographic hash  # noqa: E501

        :param sha1: The sha1 of this BinaryGenomics.  # noqa: E501
        :type: str
        """
        if sha1 is not None and not re.search('[a-fA-F0-9]{40}', sha1):  # noqa: E501
            raise ValueError("Invalid value for `sha1`, must be a follow pattern or equal to `/[a-fA-F0-9]{40}/`")  # noqa: E501

        self._sha1 = sha1

    @property
    def sha256(self):
        """Gets the sha256 of this BinaryGenomics.  # noqa: E501

        A SHA256 cryptographic hash  # noqa: E501

        :return: The sha256 of this BinaryGenomics.  # noqa: E501
        :rtype: str
        """
        return self._sha256

    @sha256.setter
    def sha256(self, sha256):
        """Sets the sha256 of this BinaryGenomics.

        A SHA256 cryptographic hash  # noqa: E501

        :param sha256: The sha256 of this BinaryGenomics.  # noqa: E501
        :type: str
        """
        if sha256 is not None and not re.search('[a-fA-F0-9]{64}', sha256):  # noqa: E501
            raise ValueError("Invalid value for `sha256`, must be a follow pattern or equal to `/[a-fA-F0-9]{64}/`")  # noqa: E501

        self._sha256 = sha256

    @property
    def sha512(self):
        """Gets the sha512 of this BinaryGenomics.  # noqa: E501

        A SHA512 cryptographic hash  # noqa: E501

        :return: The sha512 of this BinaryGenomics.  # noqa: E501
        :rtype: str
        """
        return self._sha512

    @sha512.setter
    def sha512(self, sha512):
        """Sets the sha512 of this BinaryGenomics.

        A SHA512 cryptographic hash  # noqa: E501

        :param sha512: The sha512 of this BinaryGenomics.  # noqa: E501
        :type: str
        """
        if sha512 is not None and not re.search('[a-fA-F0-9]{128}', sha512):  # noqa: E501
            raise ValueError("Invalid value for `sha512`, must be a follow pattern or equal to `/[a-fA-F0-9]{128}/`")  # noqa: E501

        self._sha512 = sha512

    @property
    def image_base(self):
        """Gets the image_base of this BinaryGenomics.  # noqa: E501

        A memory address (usually an RVA).  # noqa: E501

        :return: The image_base of this BinaryGenomics.  # noqa: E501
        :rtype: str
        """
        return self._image_base

    @image_base.setter
    def image_base(self, image_base):
        """Sets the image_base of this BinaryGenomics.

        A memory address (usually an RVA).  # noqa: E501

        :param image_base: The image_base of this BinaryGenomics.  # noqa: E501
        :type: str
        """
        if image_base is not None and not re.search('0x[a-fA-F0-9]+', image_base):  # noqa: E501
            raise ValueError("Invalid value for `image_base`, must be a follow pattern or equal to `/0x[a-fA-F0-9]+/`")  # noqa: E501

        self._image_base = image_base

    @property
    def procedure_count(self):
        """Gets the procedure_count of this BinaryGenomics.  # noqa: E501

        Number of procedures in the binary.  # noqa: E501

        :return: The procedure_count of this BinaryGenomics.  # noqa: E501
        :rtype: int
        """
        return self._procedure_count

    @procedure_count.setter
    def procedure_count(self, procedure_count):
        """Sets the procedure_count of this BinaryGenomics.

        Number of procedures in the binary.  # noqa: E501

        :param procedure_count: The procedure_count of this BinaryGenomics.  # noqa: E501
        :type: int
        """

        self._procedure_count = procedure_count

    @property
    def code_count(self):
        """Gets the code_count of this BinaryGenomics.  # noqa: E501

        Total number of disassembly instructions in all procedures of the binary.  # noqa: E501

        :return: The code_count of this BinaryGenomics.  # noqa: E501
        :rtype: int
        """
        return self._code_count

    @code_count.setter
    def code_count(self, code_count):
        """Sets the code_count of this BinaryGenomics.

        Total number of disassembly instructions in all procedures of the binary.  # noqa: E501

        :param code_count: The code_count of this BinaryGenomics.  # noqa: E501
        :type: int
        """

        self._code_count = code_count

    @property
    def semantics_count(self):
        """Gets the semantics_count of this BinaryGenomics.  # noqa: E501

        Total number of semantics instructions in all procedures of the binary.  # noqa: E501

        :return: The semantics_count of this BinaryGenomics.  # noqa: E501
        :rtype: int
        """
        return self._semantics_count

    @semantics_count.setter
    def semantics_count(self, semantics_count):
        """Sets the semantics_count of this BinaryGenomics.

        Total number of semantics instructions in all procedures of the binary.  # noqa: E501

        :param semantics_count: The semantics_count of this BinaryGenomics.  # noqa: E501
        :type: int
        """

        self._semantics_count = semantics_count

    @property
    def procedures(self):
        """Gets the procedures of this BinaryGenomics.  # noqa: E501

        List of procedures in the binary. Each procedure is represented by its genomic features.  # noqa: E501

        :return: The procedures of this BinaryGenomics.  # noqa: E501
        :rtype: list[ProcedureGenomics]
        """
        return self._procedures

    @procedures.setter
    def procedures(self, procedures):
        """Sets the procedures of this BinaryGenomics.

        List of procedures in the binary. Each procedure is represented by its genomic features.  # noqa: E501

        :param procedures: The procedures of this BinaryGenomics.  # noqa: E501
        :type: list[ProcedureGenomics]
        """

        self._procedures = procedures

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BinaryGenomics):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
