# Language Reference & Library Mappings

## Complete Language Coverage

This unified skill covers 25+ programming languages with their latest versions and patterns.

### Scripting & Dynamic Languages

#### Python 3.13
- Latest: 3.13.9 (October 2025)
- Key Features: JIT compiler (PEP 744), GIL-free mode (PEP 703)
- Ecosystem: FastAPI 0.115, Django 5.2 LTS, Pydantic v2.9, SQLAlchemy 2.0
- Best For: Data science, ML/AI, web APIs, automation

#### JavaScript ES2025
- Latest: ES2025 (ECMAScript 2025)
- Runtime: Node.js 22.11.0 LTS
- Ecosystem: npm 11.x, Express 4.21+, Vitest 2.x
- Best For: Server-side applications, scripting, tooling

#### TypeScript 5.9
- Latest: 5.9.3 (August 2025)
- Features: Deferred module evaluation, decorators
- Ecosystem: React 19, Next.js 16, tRPC 11, Zod 3.23
- Best For: Enterprise applications, type-safe full-stack

#### PHP 8.4
- Latest: 8.4 (November 2024)
- Features: Property hooks, asymmetric visibility
- Ecosystem: Laravel 11, Symfony 7, Composer 2.7
- Best For: Web development, CMS, enterprise applications

#### Ruby 3.3
- Latest: 3.3.0 (December 2024)
- Features: Performance improvements, Prism parser
- Ecosystem: Rails 7.2, Sinatra 4, Bundler 2.5
- Best For: Web development, scripting, DevOps

### Systems & Performance Languages

#### Go 1.23
- Latest: 1.23.4 (August 2024)
- Features: Range over integers, PGO 2.0, improved toolchain
- Ecosystem: Fiber v3, Echo 4.13, GORM 1.25, sqlc 1.26
- Best For: Microservices, CLI tools, systems programming

#### Rust 1.91
- Latest: 1.91.1 (November 2025)
- Features: Async traits, const generics improvements
- Ecosystem: Tokio 1.48, Axum 0.8, Serde 1.0, SQLx 0.8
- Best For: Systems programming, performance-critical apps

#### C++23
- Latest: C++23 (ISO/IEC 14882:2024)
- Features: Deducing this, explicit object parameter, ranges v2
- Ecosystem: CMake 3.30, Conan 2.0, vcpkg 2024
- Best For: High-performance systems, game development

#### C17
- Latest: C17 (ISO/IEC 9899:2018)
- Features: New keywords, improved Unicode support
- Ecosystem: GCC 14, Clang 18, Make, CMake
- Best For: Embedded systems, low-level programming

### Enterprise & JVM Languages

#### Java 21 LTS
- Latest: 21.0.3 (LTS, support until 2031)
- Features: Virtual threads, pattern matching for switch, record patterns
- Ecosystem: Spring Boot 3.3, Hibernate 7, Maven 3.9, Gradle 8.5
- Best For: Enterprise applications, microservices, big data

#### Kotlin 2.0
- Latest: 2.0.20 (November 2025)
- Features: K2 compiler, context receivers, data objects
- Ecosystem: Ktor 3, Compose Multiplatform, Spring Boot 3
- Best For: Android development, server-side, multiplatform

#### Scala 3.4
- Latest: 3.4.0 (November 2025)
- Features: Export clauses, vararg splices, improved type inference
- Ecosystem: Akka 2.9, Play 3.1, sbt 1.10
- Best For: Functional programming, big data, concurrent systems

### Mobile & Platform Languages

#### Swift 6.0
- Latest: 6.0 (November 2025)
- Features: Typed throws, custom actor executors, embedded Swift
- Ecosystem: SwiftUI 6, Vapor 4, SwiftPM 6
- Best For: iOS development, server-side Swift, systems

#### C# (.NET 8)
- Latest: C# 12 (.NET 8 LTS)
- Features: Primary constructors, collection expressions, lambda defaults
- Ecosystem: ASP.NET Core 8, Entity Framework 8, MAUI 8
- Best For: Enterprise applications, game development, cross-platform

#### Dart 3.5
- Latest: 3.5.4 (November 2025)
- Features: Patterns, records, macros (experimental)
- Ecosystem: Flutter 3.24, Angel 3, Dart 3 async
- Best For: Cross-platform mobile apps, web development

### Data & Domain Languages

#### R 4.4
- Latest: 4.4.1 (October 2025)
- Features: Pipe operator `|>`, improved performance
- Ecosystem: Tidyverse 2.0, Shiny 1.8, data.table 1.16
- Best For: Statistical computing, data visualization, research

#### SQL:2023
- Latest: SQL:2023 standard
- Features: JSON functions, property graphs, pattern matching
- Ecosystem: PostgreSQL 17, MySQL 9.0, MongoDB 8.0
- Best For: Database queries across all RDBMS

#### Elixir 1.17
- Latest: 1.17.3 (November 2025)
- Features: Graceful upgrades, improved error handling
- Ecosystem: Phoenix 1.7, Ecto 3.12, LiveView 1.1
- Best For: Functional programming, concurrent systems

## Context7 Library Mappings

### Python Libraries
```
/tiangolo/fastapi - Modern async web framework
/django/django - Full-stack web framework
/pydantic/pydantic - Data validation using type annotations
/sqlalchemy/sqlalchemy - Python SQL toolkit and ORM
/pytest-dev/pytest - Testing framework
/palletsprojects/flask - Micro web framework
/numpy/numpy - Numerical computing
/pandas-dev/pandas - Data analysis library
/scikit-learn/scikit-learn- Machine learning library
/tensorflow/tensorflow - Machine learning platform
```

### JavaScript/TypeScript Libraries
```
/facebook/react - UI library for building user interfaces
/vercel/next.js - React framework with server-side rendering
/microsoft/TypeScript - Typed superset of JavaScript
/nodejs/node - JavaScript runtime
/expressjs/express - Fast, unopinionated web framework
/trpc/trpc - End-to-end type-safe APIs
/colinhacks/zod - TypeScript-first schema validation
/vitest-dev/vitest - Next generation testing framework
/sveltejs/svelte - Cybernetically enhanced web apps
/vuejs/vue - Progressive JavaScript framework
```

### Go Libraries
```
/golang/go - Modern systems programming language
/gin-gonic/gin - High-performance HTTP web framework
/labstack/echo - High performance, minimalist web framework
/go-gorm/gorm - The fantastic ORM library for Golang
/stretchr/testify - Testing toolkit for Go
/golang/mock - GoMock is a mocking framework for Go
/grpc/grpc-go - Go language implementation of gRPC
/protocolbuffers/protobuf - Protocol Buffers
```

### Rust Libraries
```
/rust-lang/rust - Systems programming language
/tokio-rs/tokio - Asynchronous runtime for Rust
/tokio-rs/axum - Ergonomic and modular web framework
/serde-rs/serde - Serialization and deserialization framework
/rust-lang/rust-clippy - A collection of lints to catch common mistakes
/burntSushi/ripgrep - Line-oriented search tool
/rust-lang/cargo - Package manager for Rust
```

### Java Libraries
```
/spring-projects/spring-boot - Java-based framework for enterprise applications
/hibernate/hibernate-orm - Hibernate's core Object/Relational Mapping
/junit-team/junit5 - Programmer-friendly testing framework
/mockito/mockito - Mocking framework for unit tests
/gradle/gradle - Build automation tool
/maven-apache/maven - Build automation and dependency management
```

### Ruby Libraries
```
/ruby/ruby - Ruby programming language
/rails/rails - Ruby on Rails web framework
/rack/rack - Ruby Webserver Interface
/rspec/rspec-core - RSpec testing framework
/sinatra/sinatra - DSL for creating web applications
/fluent/fluentd - Fluentd logging tool
```

### PHP Libraries
```
/php/php-src - PHP programming language
/laravel/framework - PHP web application framework
/symfony/symfony - PHP framework for web applications
/composer/composer - Dependency manager for PHP
/phpunit/phpunit - Testing framework for PHP
```

### Other Languages
```
/elm/compiler - Elm programming language compiler
/elixir-lang/elixir - Elixir programming language
/phoenixframework/phoenix - Phoenix web framework
/nim-lang/nim - Nim programming language
/ziglang/zig - Zig programming language
```

## Language-Specific Patterns

### Error Handling Patterns

| Language | Error Type | Handling Pattern | Example |
|----------|------------|------------------|---------|
| Python | Exception | try/except | `try: result = risky()` |
| Go | Multiple return | `result, err` | `result, err := risky()` |
| Rust | Result/Option | `match` or `?` | `result = risky()?` |
| Java | Checked Exception | try/catch/finally | `try { risky() } catch (e) {}` |
| TypeScript | Throw/Catch | try/catch | `try { await risky() }` |
| JavaScript | Error | try/catch | `try { risky() } catch (e) {}` |

### Async Programming

| Language | Async Model | Syntax | Runtime |
|----------|-------------|--------|---------|
| Python | Coroutine | `async/await` | asyncio |
| JavaScript | Promise | `async/await` | Event loop |
| TypeScript | Promise | `async/await` | Node.js |
| Go | Goroutine | `go func()` | Go runtime |
| Rust | Future | `async/await` | Tokio |
| Java | Virtual Thread | `Thread.startVirtualThread()` | JVM |
| C# | Task | `async/await` | .NET |
| Swift | Actor | `async/await` | Swift runtime |

### Package Management

| Language | Package Manager | Config File | Lock File |
|----------|----------------|-------------|-----------|
| Python | pip/poetry | requirements.txt/poetry.toml | requirements.txt/poetry.lock |
| Node.js | npm/yarn | package.json | package-lock.json/yarn.lock |
| Go | go modules | go.mod | go.sum |
| Rust | cargo | Cargo.toml | Cargo.lock |
| Java | Maven/Gradle | pom.xml/build.gradle | dependency resolution |
| Ruby | gem/bundler | Gemfile | Gemfile.lock |
| PHP | composer | composer.json | composer.lock |
| C++ | vcpkg/conan | vcpkg.json/conanfile.py | vcpkg-manifest.lock |

### Testing Frameworks

| Language | Unit Test | Integration Test | E2E Test | Benchmark |
|----------|-----------|------------------|----------|-----------|
| Python | pytest | pytest + fixtures | Playwright | pytest-benchmark |
| TypeScript | Vitest | Vitest | Playwright | benchmark.js |
| JavaScript | Jest | Jest | Cypress | benchmark.js |
| Go | testing | testify + httptest | - | testing.B |
| Rust | cargo test | cargo test --test integration | - | criterion |
| Java | JUnit | Spring Boot Test | Selenium | JMH |
| C# | xUnit | xUnit + TestServer | Playwright | BenchmarkDotNet |
| Ruby | RSpec | Capybara | Capybara | benchmark-ips |

### Performance Characteristics

| Language | Startup Time | Memory Usage | Throughput | Latency |
|----------|---------------|--------------|------------|---------|
| Go | Fast | Low | High | Low |
| Rust | Medium | Very Low | Very High | Very Low |
| Java | Slow | High | High | Medium |
| Python | Medium | Medium | Medium | Medium |
| Node.js | Fast | Medium | High | Low |
| C# | Slow | High | High | Medium |
| C++ | Fast | Very Low | Very High | Very Low |

## Development Environment Setup

### IDE/Editor Support

| Language | VS Code | IntelliJ | Vim | Emacs |
|----------|---------|----------|-----|-------|
| Python | Python extension | PyCharm | python-mode | elpy |
| TypeScript | TypeScript extension | WebStorm | typescript-vim | tide |
| Go | Go extension | GoLand | vim-go | go-mode |
| Rust | Rust analyzer | RustRover | rust.vim | rustic |
| Java | Extension Pack for Java | IntelliJ IDEA | vim-java | eclim |
| C# | C# Dev Kit | Rider | omnisharp-vim | csharp-mode |

### Linter & Formatter

| Language | Linter | Formatter | Configuration |
|----------|--------|-----------|---------------|
| Python | pylint/ruff | black/isort | pyproject.toml |
| TypeScript | ESLint | Prettier | eslint.config.js/.prettierrc |
| Go | golint/gofmt | gofmt | .gofmt |
| Rust | clippy | rustfmt | rustfmt.toml |
| Java | checkstyle | google-java-format | google-java-format.xml |
| C# | StyleCop | dotnet-format | .editorconfig |

## Deployment Targets

### Cloud Platforms

| Language | AWS | Google Cloud | Azure | Heroku | Vercel |
|----------|-----|-------------|-------|--------|--------|
| Python | Lambda, ECS | Cloud Run | Functions | Dyno | Serverless |
| Go | Lambda, ECS | Cloud Run | Functions | Dyno | Serverless |
| Rust | Lambda, ECS | Cloud Run | Functions | - | Serverless |
| Java | Lambda, ECS | Cloud Run | Functions | Dyno | - |
| TypeScript | Lambda, ECS | Cloud Run | Functions | Dyno | Edge |
| C# | Lambda, ECS | Cloud Run | Functions | Dyno | - |

### Container Patterns

| Language | Base Image | Build Tool | Runtime | Image Size |
|----------|-------------|------------|---------|------------|
| Python | python:3.13-slim | pip | uvicorn/gunicorn | 100-200MB |
| Go | golang:1.23-alpine | go build | binary | 10-20MB |
| Rust | rust:1.91-alpine | cargo build | binary | 10-20MB |
| Java | eclipse-temurin:21 | maven/gradle | java -jar | 200-400MB |
| Node.js | node:22-alpine | npm | node | 100-200MB |
| C# | mcr.microsoft.com/dotnet/aspnet:8.0 | dotnet build | dotnet | 100-200MB |

---

Last Updated: 2025-11-25
Version: 1.0.0
