# moai-lang-unified

## Overview

This unified programming language skill consolidates 25+ individual `moai-lang-*` skills into a single, comprehensive skill that maintains all the expertise and functionality while providing cross-language capabilities.

## Replaced Skills

This unified skill replaces the following 25 individual language skills:

### Scripting & Dynamic Languages
- `moai-lang-python` - Python 3.13 with FastAPI, Django, async patterns
- `moai-lang-javascript` - JavaScript ES2025 with Node.js, Express
- `moai-lang-typescript` - TypeScript 5.9 with React, Next.js, type safety
- `moai-lang-php` - PHP 8.4 with Laravel, Symfony
- `moai-lang-ruby` - Ruby 3.3 with Rails, Sinatra
- `moai-lang-shell` - Shell/Bash scripting and DevOps

### Systems & Performance Languages
- `moai-lang-go` - Go 1.23 with concurrency, Fiber
- `moai-lang-rust` - Rust 1.91 with memory safety, Tokio
- `moai-lang-cpp` - C++23 with performance optimization
- `moai-lang-c` - C17 with low-level programming

### Enterprise & JVM Languages
- `moai-lang-java` - Java 21 LTS with Spring Boot
- `moai-lang-kotlin` - Kotlin 2.0 with coroutines
- `moai-lang-scala` - Scala 3.4 with functional programming
- `moai-lang-jvm` - JVM ecosystem patterns

### Mobile & Platform Languages
- `moai-lang-swift` - Swift 6.0 for iOS and server-side
- `moai-lang-csharp` - C# 12 with .NET 8
- `moai-lang-dart` - Dart 3.5 with Flutter

### Data & Domain Languages
- `moai-lang-r` - R 4.4 for statistical computing
- `moai-lang-sql` - SQL:2023 across all RDBMS
- `moai-lang-elixir` - Elixir 1.17 with Phoenix

### Specialized Languages
- `moai-lang-html-css` - HTML5 and CSS3 for web development
- `moai-lang-mobile` - Cross-platform mobile development
- `moai-lang-systems` - Systems programming patterns

## Key Advantages

### 1. Unified Experience
- Single skill for all programming language expertise
- Consistent documentation and examples across languages
- Cross-language comparisons and migration guides

### 2. Enhanced Functionality
- Cross-language integration patterns
- Polyglot system design guidance
- Language selection recommendations

### 3. Improved Performance
- Automatic language detection and context switching
- Reduced skill loading overhead
- Optimized Context7 integration

### 4. Maintenance Efficiency
- Single point of maintenance for language expertise
- Consistent updates across all languages
- Simplified dependency management

## Usage

### Automatic Detection
The skill automatically detects the programming language context based on:
- File extensions (`.py`, `.ts`, `.go`, `.rs`, `.java`, etc.)
- Language-specific keywords and patterns
- Framework and library mentions

### Manual Invocation
```bash
# Get Python expertise
Skill("moai-lang-unified") # with .py files

# Get Go expertise 
Skill("moai-lang-unified") # with .go files

# Cross-language comparison
Skill("moai-lang-unified") # with multiple languages
```

### Progressive Disclosure
- Quick Reference: Immediate language patterns and examples
- Implementation Guide: In-depth language-specific guidance
- Cross-Language: Comparisons, integration, and migration patterns

## File Structure

```
moai-lang-unified/
 SKILL.md # Main skill file (242 lines, under 500 limit)
 reference.md # Comprehensive language reference and mappings
 examples.md # Multi-language code examples and patterns
 README.md # This file
```

## Migration Guide

### For Users
1. Replace `Skill("moai-lang-python")` with `Skill("moai-lang-unified")`
2. The unified skill will automatically detect the language context
3. All previous functionality is preserved and enhanced

### For Developers
- Individual language skills can be safely removed
- This unified skill provides equivalent or superior functionality
- Context7 integration is enhanced with comprehensive library mappings

## Validation

- SKILL.md complies with 500-line limit (242 lines)
- All 25+ languages covered with latest versions
- Context7 integration with comprehensive library mappings
- Cross-language patterns and comparisons
- Production-ready code examples
- Progressive disclosure architecture
- Official Claude Code standards compliance

## Future Updates

This unified skill will be maintained as the single source of truth for programming language expertise in the MoAI-ADK ecosystem. All language updates and new language support will be added here rather than creating separate skills.

---

Last Updated: 2025-11-25 
Status: Production Ready (Enterprise v1.0.0) 
Maintainer: MoAI-ADK Team
