# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.eval_service_handlers_get_table_response import EvalServiceHandlersGetTableResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.table_config_input_schema_item import TableConfigInputSchemaItem
from ..types.eval_service_handlers_create_table_response import EvalServiceHandlersCreateTableResponse
from ..types.eval_service_handlers_update_table_response import EvalServiceHandlersUpdateTableResponse
from ..types.eval_service_handlers_delete_table_response import EvalServiceHandlersDeleteTableResponse
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TablesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, collection_id: str, table_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EvalServiceHandlersGetTableResponse:
        """
        Parameters
        ----------
        collection_id : str

        table_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersGetTableResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.tables.get(
            collection_id="collection_id",
            table_id="table_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables/{jsonable_encoder(table_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersGetTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersGetTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        collection_id: str,
        *,
        table_display_name: typing.Optional[str] = OMIT,
        table_img_url: typing.Optional[str] = OMIT,
        table_description: typing.Optional[str] = OMIT,
        schema: typing.Optional[typing.Sequence[TableConfigInputSchemaItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvalServiceHandlersCreateTableResponse:
        """
        Parameters
        ----------
        collection_id : str

        table_display_name : typing.Optional[str]

        table_img_url : typing.Optional[str]

        table_description : typing.Optional[str]

        schema : typing.Optional[typing.Sequence[TableConfigInputSchemaItem]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersCreateTableResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.tables.create(
            collection_id="collection_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables",
            method="POST",
            json={
                "table_display_name": table_display_name,
                "table_img_url": table_img_url,
                "table_description": table_description,
                "schema": schema,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersCreateTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersCreateTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        collection_id: str,
        table_id: str,
        *,
        table_display_name: typing.Optional[str] = OMIT,
        table_img_url: typing.Optional[str] = OMIT,
        table_description: typing.Optional[str] = OMIT,
        schema: typing.Optional[typing.Sequence[TableConfigInputSchemaItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvalServiceHandlersUpdateTableResponse:
        """
        Parameters
        ----------
        collection_id : str

        table_id : str

        table_display_name : typing.Optional[str]

        table_img_url : typing.Optional[str]

        table_description : typing.Optional[str]

        schema : typing.Optional[typing.Sequence[TableConfigInputSchemaItem]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersUpdateTableResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.tables.update(
            collection_id="collection_id",
            table_id="table_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables/{jsonable_encoder(table_id)}",
            method="PUT",
            json={
                "table_display_name": table_display_name,
                "table_img_url": table_img_url,
                "table_description": table_description,
                "schema": schema,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersUpdateTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersUpdateTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self, collection_id: str, table_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EvalServiceHandlersDeleteTableResponse:
        """
        Delete a table given a table_id.

        Parameters
        ----------
        collection_id : str

        table_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersDeleteTableResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.tables.delete(
            collection_id="collection_id",
            table_id="table_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables/{jsonable_encoder(table_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersDeleteTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersDeleteTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncTablesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, collection_id: str, table_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EvalServiceHandlersGetTableResponse:
        """
        Parameters
        ----------
        collection_id : str

        table_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersGetTableResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tables.get(
                collection_id="collection_id",
                table_id="table_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables/{jsonable_encoder(table_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersGetTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersGetTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        collection_id: str,
        *,
        table_display_name: typing.Optional[str] = OMIT,
        table_img_url: typing.Optional[str] = OMIT,
        table_description: typing.Optional[str] = OMIT,
        schema: typing.Optional[typing.Sequence[TableConfigInputSchemaItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvalServiceHandlersCreateTableResponse:
        """
        Parameters
        ----------
        collection_id : str

        table_display_name : typing.Optional[str]

        table_img_url : typing.Optional[str]

        table_description : typing.Optional[str]

        schema : typing.Optional[typing.Sequence[TableConfigInputSchemaItem]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersCreateTableResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tables.create(
                collection_id="collection_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables",
            method="POST",
            json={
                "table_display_name": table_display_name,
                "table_img_url": table_img_url,
                "table_description": table_description,
                "schema": schema,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersCreateTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersCreateTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        collection_id: str,
        table_id: str,
        *,
        table_display_name: typing.Optional[str] = OMIT,
        table_img_url: typing.Optional[str] = OMIT,
        table_description: typing.Optional[str] = OMIT,
        schema: typing.Optional[typing.Sequence[TableConfigInputSchemaItem]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvalServiceHandlersUpdateTableResponse:
        """
        Parameters
        ----------
        collection_id : str

        table_id : str

        table_display_name : typing.Optional[str]

        table_img_url : typing.Optional[str]

        table_description : typing.Optional[str]

        schema : typing.Optional[typing.Sequence[TableConfigInputSchemaItem]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersUpdateTableResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tables.update(
                collection_id="collection_id",
                table_id="table_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables/{jsonable_encoder(table_id)}",
            method="PUT",
            json={
                "table_display_name": table_display_name,
                "table_img_url": table_img_url,
                "table_description": table_description,
                "schema": schema,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersUpdateTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersUpdateTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, collection_id: str, table_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EvalServiceHandlersDeleteTableResponse:
        """
        Delete a table given a table_id.

        Parameters
        ----------
        collection_id : str

        table_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvalServiceHandlersDeleteTableResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tables.delete(
                collection_id="collection_id",
                table_id="table_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/collections/{jsonable_encoder(collection_id)}/tables/{jsonable_encoder(table_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EvalServiceHandlersDeleteTableResponse,
                    construct_type(
                        type_=EvalServiceHandlersDeleteTableResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
