# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.apps_service_handlers_list_copilots_response import AppsServiceHandlersListCopilotsResponse
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..types.copilot_config_mode import CopilotConfigMode
from ..types.copilot_config_fab_value import CopilotConfigFabValue
from ..types.apps_service_handlers_create_copilot_response import AppsServiceHandlersCreateCopilotResponse
from ..types.apps_service_handlers_get_copilot_response import AppsServiceHandlersGetCopilotResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..types.apps_service_handlers_update_copilot_response import AppsServiceHandlersUpdateCopilotResponse
from ..types.apps_service_handlers_delete_copilot_response import AppsServiceHandlersDeleteCopilotResponse
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CopilotsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        sort: typing.Optional[str] = None,
        direction: typing.Optional[str] = None,
        start_at: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        query: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppsServiceHandlersListCopilotsResponse:
        """
        List all copilots in the organization

        Parameters
        ----------
        sort : typing.Optional[str]
            Field to sort by

        direction : typing.Optional[str]
            Sort in ascending or descending order

        start_at : typing.Optional[str]
            created_at to start at

        limit : typing.Optional[int]
            Limit of records to return

        query : typing.Optional[str]
            Search query

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersListCopilotsResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.copilots.list()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/copilots",
            method="GET",
            params={
                "sort": sort,
                "direction": direction,
                "start_at": start_at,
                "limit": limit,
                "query": query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersListCopilotsResponse,
                    construct_type(
                        type_=AppsServiceHandlersListCopilotsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create(
        self,
        *,
        workflow_id: typing.Optional[str] = OMIT,
        img_url: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        mode: typing.Optional[CopilotConfigMode] = OMIT,
        colors: typing.Optional[typing.Dict[str, str]] = OMIT,
        fab: typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]] = OMIT,
        message_placeholder: typing.Optional[str] = OMIT,
        initial_activity: typing.Optional[typing.Sequence[typing.Optional[typing.Any]]] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppsServiceHandlersCreateCopilotResponse:
        """
        Parameters
        ----------
        workflow_id : typing.Optional[str]

        img_url : typing.Optional[str]

        display_name : typing.Optional[str]

        mode : typing.Optional[CopilotConfigMode]

        colors : typing.Optional[typing.Dict[str, str]]

        fab : typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]]

        message_placeholder : typing.Optional[str]

        initial_activity : typing.Optional[typing.Sequence[typing.Optional[typing.Any]]]

        allowed_origins : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersCreateCopilotResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.copilots.create()
        """
        _response = self._client_wrapper.httpx_client.request(
            "v2/copilots",
            method="POST",
            json={
                "workflow_id": workflow_id,
                "img_url": img_url,
                "display_name": display_name,
                "mode": mode,
                "colors": colors,
                "fab": fab,
                "message_placeholder": message_placeholder,
                "initial_activity": initial_activity,
                "allowed_origins": allowed_origins,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersCreateCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersCreateCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get(
        self, copilot_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AppsServiceHandlersGetCopilotResponse:
        """
        Fetch app configuration by ID.

        Parameters
        ----------
        copilot_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersGetCopilotResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.copilots.get(
            copilot_id="copilot_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/copilots/{jsonable_encoder(copilot_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersGetCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersGetCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update(
        self,
        copilot_id: str,
        *,
        workflow_id: typing.Optional[str] = OMIT,
        img_url: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        mode: typing.Optional[CopilotConfigMode] = OMIT,
        colors: typing.Optional[typing.Dict[str, str]] = OMIT,
        fab: typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]] = OMIT,
        message_placeholder: typing.Optional[str] = OMIT,
        initial_activity: typing.Optional[typing.Sequence[typing.Optional[typing.Any]]] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppsServiceHandlersUpdateCopilotResponse:
        """
        Parameters
        ----------
        copilot_id : str

        workflow_id : typing.Optional[str]

        img_url : typing.Optional[str]

        display_name : typing.Optional[str]

        mode : typing.Optional[CopilotConfigMode]

        colors : typing.Optional[typing.Dict[str, str]]

        fab : typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]]

        message_placeholder : typing.Optional[str]

        initial_activity : typing.Optional[typing.Sequence[typing.Optional[typing.Any]]]

        allowed_origins : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersUpdateCopilotResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.copilots.update(
            copilot_id="copilot_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/copilots/{jsonable_encoder(copilot_id)}",
            method="PUT",
            json={
                "workflow_id": workflow_id,
                "img_url": img_url,
                "display_name": display_name,
                "mode": mode,
                "colors": colors,
                "fab": fab,
                "message_placeholder": message_placeholder,
                "initial_activity": initial_activity,
                "allowed_origins": allowed_origins,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersUpdateCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersUpdateCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete(
        self, copilot_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AppsServiceHandlersDeleteCopilotResponse:
        """
        Parameters
        ----------
        copilot_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersDeleteCopilotResponse
            Successful Response

        Examples
        --------
        from scoutos import Scout

        client = Scout(
            api_key="YOUR_API_KEY",
        )
        client.copilots.delete(
            copilot_id="copilot_id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/copilots/{jsonable_encoder(copilot_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersDeleteCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersDeleteCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCopilotsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        sort: typing.Optional[str] = None,
        direction: typing.Optional[str] = None,
        start_at: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        query: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppsServiceHandlersListCopilotsResponse:
        """
        List all copilots in the organization

        Parameters
        ----------
        sort : typing.Optional[str]
            Field to sort by

        direction : typing.Optional[str]
            Sort in ascending or descending order

        start_at : typing.Optional[str]
            created_at to start at

        limit : typing.Optional[int]
            Limit of records to return

        query : typing.Optional[str]
            Search query

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersListCopilotsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.copilots.list()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/copilots",
            method="GET",
            params={
                "sort": sort,
                "direction": direction,
                "start_at": start_at,
                "limit": limit,
                "query": query,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersListCopilotsResponse,
                    construct_type(
                        type_=AppsServiceHandlersListCopilotsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create(
        self,
        *,
        workflow_id: typing.Optional[str] = OMIT,
        img_url: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        mode: typing.Optional[CopilotConfigMode] = OMIT,
        colors: typing.Optional[typing.Dict[str, str]] = OMIT,
        fab: typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]] = OMIT,
        message_placeholder: typing.Optional[str] = OMIT,
        initial_activity: typing.Optional[typing.Sequence[typing.Optional[typing.Any]]] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppsServiceHandlersCreateCopilotResponse:
        """
        Parameters
        ----------
        workflow_id : typing.Optional[str]

        img_url : typing.Optional[str]

        display_name : typing.Optional[str]

        mode : typing.Optional[CopilotConfigMode]

        colors : typing.Optional[typing.Dict[str, str]]

        fab : typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]]

        message_placeholder : typing.Optional[str]

        initial_activity : typing.Optional[typing.Sequence[typing.Optional[typing.Any]]]

        allowed_origins : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersCreateCopilotResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.copilots.create()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v2/copilots",
            method="POST",
            json={
                "workflow_id": workflow_id,
                "img_url": img_url,
                "display_name": display_name,
                "mode": mode,
                "colors": colors,
                "fab": fab,
                "message_placeholder": message_placeholder,
                "initial_activity": initial_activity,
                "allowed_origins": allowed_origins,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersCreateCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersCreateCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get(
        self, copilot_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AppsServiceHandlersGetCopilotResponse:
        """
        Fetch app configuration by ID.

        Parameters
        ----------
        copilot_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersGetCopilotResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.copilots.get(
                copilot_id="copilot_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/copilots/{jsonable_encoder(copilot_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersGetCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersGetCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update(
        self,
        copilot_id: str,
        *,
        workflow_id: typing.Optional[str] = OMIT,
        img_url: typing.Optional[str] = OMIT,
        display_name: typing.Optional[str] = OMIT,
        mode: typing.Optional[CopilotConfigMode] = OMIT,
        colors: typing.Optional[typing.Dict[str, str]] = OMIT,
        fab: typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]] = OMIT,
        message_placeholder: typing.Optional[str] = OMIT,
        initial_activity: typing.Optional[typing.Sequence[typing.Optional[typing.Any]]] = OMIT,
        allowed_origins: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AppsServiceHandlersUpdateCopilotResponse:
        """
        Parameters
        ----------
        copilot_id : str

        workflow_id : typing.Optional[str]

        img_url : typing.Optional[str]

        display_name : typing.Optional[str]

        mode : typing.Optional[CopilotConfigMode]

        colors : typing.Optional[typing.Dict[str, str]]

        fab : typing.Optional[typing.Dict[str, typing.Optional[CopilotConfigFabValue]]]

        message_placeholder : typing.Optional[str]

        initial_activity : typing.Optional[typing.Sequence[typing.Optional[typing.Any]]]

        allowed_origins : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersUpdateCopilotResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.copilots.update(
                copilot_id="copilot_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/copilots/{jsonable_encoder(copilot_id)}",
            method="PUT",
            json={
                "workflow_id": workflow_id,
                "img_url": img_url,
                "display_name": display_name,
                "mode": mode,
                "colors": colors,
                "fab": fab,
                "message_placeholder": message_placeholder,
                "initial_activity": initial_activity,
                "allowed_origins": allowed_origins,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersUpdateCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersUpdateCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete(
        self, copilot_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AppsServiceHandlersDeleteCopilotResponse:
        """
        Parameters
        ----------
        copilot_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AppsServiceHandlersDeleteCopilotResponse
            Successful Response

        Examples
        --------
        import asyncio

        from scoutos import AsyncScout

        client = AsyncScout(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.copilots.delete(
                copilot_id="copilot_id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/copilots/{jsonable_encoder(copilot_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    AppsServiceHandlersDeleteCopilotResponse,
                    construct_type(
                        type_=AppsServiceHandlersDeleteCopilotResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
