# Generated by Django 4.1.7 on 2023-02-17 16:48

import common_objects.fields
import common_objects.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('common_objects', '0003_alter_commoncategory_name'),
        ('task_schedule', '0003_alter_taskschedule_options_taskcallback_description_and_more'),
    ]

    operations = [
        migrations.AlterField(
            model_name='task',
            name='tags',
            field=models.ManyToManyField(blank=True, db_constraint=False, to='common_objects.commontag', verbose_name='标签'),
        ),
        migrations.CreateModel(
            name='TaskScheduleCallback',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100, verbose_name='回调')),
                ('description', models.TextField(blank=True, null=True, verbose_name='描述')),
                ('trigger_event', common_objects.fields.CharField(choices=[('S', '成功'), ('F', '失败'), ('D', '完成')], default='D', max_length=1, verbose_name='触发事件')),
                ('status', common_objects.fields.CharField(choices=[('E', '启用'), ('D', '禁用')], default='E', max_length=1, verbose_name='状态')),
                ('config', common_objects.models.ConfigField(blank=True, default=common_objects.models.get_default_config('TaskCallback'), null=True, verbose_name='参数')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('user', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='用户')),
            ],
            options={
                'verbose_name': '任务回调',
                'verbose_name_plural': '任务回调',
                'db_table': 'task_schedule_callback',
                'unique_together': {('name', 'user')},
            },
        ),
        migrations.AlterField(
            model_name='taskschedule',
            name='callback',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.CASCADE, to='task_schedule.taskschedulecallback', verbose_name='回调'),
        ),
        migrations.DeleteModel(
            name='TaskCallback',
        ),
    ]
