# Generated by Django 4.1.7 on 2023-02-15 09:15

import common_objects.fields
import common_objects.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('common_objects', '0002_alter_commoncategory_parent'),
    ]

    operations = [
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100, verbose_name='任务名')),
                ('description', models.TextField(blank=True, null=True, verbose_name='描述')),
                ('config', common_objects.models.ConfigField(blank=True, default=common_objects.models.get_default_config('Task'), null=True, verbose_name='参数')),
                ('status', common_objects.fields.CharField(choices=[('E', '启用'), ('D', '禁用')], default='E', max_length=1, verbose_name='状态')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('category', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.DO_NOTHING, to='common_objects.commoncategory', verbose_name='类别')),
                ('parent', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='task_schedule.task', verbose_name='父任务')),
                ('tags', models.ManyToManyField(db_constraint=False, to='common_objects.commontag', verbose_name='标签')),
                ('user', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='用户')),
            ],
            options={
                'verbose_name': '任务',
                'verbose_name_plural': '任务',
                'db_table': 'taskhub',
                'unique_together': {('name', 'user', 'parent')},
            },
        ),
        migrations.CreateModel(
            name='TaskCallback',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=100, verbose_name='回调')),
                ('status', common_objects.fields.CharField(choices=[('E', '启用'), ('D', '禁用')], default='E', max_length=1, verbose_name='状态')),
                ('config', common_objects.models.ConfigField(blank=True, default=common_objects.models.get_default_config('TaskCallback'), null=True, verbose_name='参数')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('user', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='用户')),
            ],
            options={
                'verbose_name': '任务回调',
                'verbose_name_plural': '任务回调',
                'db_table': 'task_callback',
                'unique_together': {('name', 'user')},
            },
        ),
        migrations.CreateModel(
            name='TaskSchedule',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('type', common_objects.fields.CharField(choices=[('C', 'Crontab'), ('O', '一次性'), ('S', '连续性')], default='S', max_length=1, verbose_name='计划类型')),
                ('crontab', models.CharField(max_length=50, verbose_name='定时')),
                ('priority', models.IntegerField(default=0, verbose_name='优先级')),
                ('next_schedule_time', models.DateTimeField(blank=True, null=True, verbose_name='下次运行时间')),
                ('period', models.IntegerField(default=60, verbose_name='周期(秒)')),
                ('status', common_objects.fields.CharField(choices=[('O', '开启'), ('C', '关闭'), ('D', '已完成'), ('T', '测试')], default='O', max_length=1, verbose_name='状态')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='创建时间')),
                ('update_time', models.DateTimeField(auto_now=True, verbose_name='更新时间')),
                ('callback', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='task_schedule.taskcallback', verbose_name='回调')),
                ('task', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='task_schedule.task', verbose_name='任务')),
                ('user', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='用户')),
            ],
            options={
                'verbose_name': '任务计划',
                'verbose_name_plural': '任务计划',
                'db_table': 'task_schedule',
            },
        ),
        migrations.CreateModel(
            name='TaskScheduleLog',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('status', common_objects.fields.CharField(max_length=1, verbose_name='运行状态')),
                ('result', common_objects.models.ConfigField(blank=True, null=True, verbose_name='结果')),
                ('schedule_time', models.DateTimeField(verbose_name='计划时间')),
                ('create_time', models.DateTimeField(default=django.utils.timezone.now, verbose_name='创建时间')),
                ('schedule', models.ForeignKey(db_constraint=False, on_delete=django.db.models.deletion.CASCADE, to='task_schedule.taskschedule', verbose_name='任务计划')),
            ],
            options={
                'verbose_name': '任务计划日志',
                'verbose_name_plural': '任务计划日志',
                'db_table': 'task_schedule_log',
            },
        ),
    ]
