import pytest
from pyraceview.messages import MsgPitLaneExtended
from pyraceview.models import Flag


raw = (
    b'\xab\xcd\x00\x00\x00\x1fbd?f\x04\x01"\x01g\x00g'
    b"\x00\r\x0e\x03a\x00\xc5\x00\xed\x00k\x00\xa3\x00"
    b"\xf2\x00\xba\x01\x04\x00\x01\xab\xcd\x14\xa4\x01"
    b"\xcdW&\x04fA\xc4\x01\x00(\x00\xe4\x11\x04\xcf\xf1"
    b"\x03\xd1\\\x02\x06\xeb\x00c\x81\x010c\x00H\x1a\x04"
    b"\x03[\x01\r\xb1\x03\x8f\xd5\x0c\xf02\x06\x06p\xc0"
    b"\x11\x90\xff\xb0P\xfcD\xe6\x08\x05\xe5@\xdf1\x020I"
    b"\x06\x8cj\x0c\x06\xa1\xc0\r\xf1\x01\x90Z\xfdE\x84"
    b"\x10\xff\x0f@\xd5q\x05o\xeb\x03\x91n\x12\x06`\x00"
    b"\xbd\xf1\x01\xf0w\x05\xeb \x14\x06\xea@T\xf1\x010f"
    b"\xff'\xb0\x16\x04\x11\x01\n\x81\x02P\r\x06\x0fr"
    b"\x18\x01G@\xf9q\x05/\xed\x04q\x88\x1a\xfb\xa3\xc0"
    b"\x8f\xa1\x05o\xe3\x06q\xc2\x1c\x06\xbc\x80\x8e1"
    b"\x010\x87\x03)F\x1e\xfb\xdc\xff/\x01\x04p\r\x00\x85"
    b'\x02"\x06\xd1\xc05\xb1\x01\x10r\xfef\xc2$\x01\xd1\xc0'
    b"\xfc\xa1\x04\x8f\xed\x04p\xde&\x02c\x00\xff\x11\x03o"
    b"\xe1\x04q\x06(\x06\x94\x80\xab\xc1\x02P\x9b\x05\xaa|*"
    b"\xfa\xe8\x80~\x01\x07/\xbb\x0e\xd2b,\xfc?\xc0\x9eQ"
    b"\x05o\xe9\x04\xb1\xae0\xfa\xa0@r\xe1\x06\xaf\x83\x10"
    b"\xd2\xca6\xfb`\x00\x85\x11\x04\xef\xd3\x07\xd28@\xfc"
    b"\xf3\x80\xaaq\x05O\xf1\x041vD\xfc\x95@\xab\xa1\x05\xef"
    b"\xf1\x041\x8eH\xff\x9d@\xddA\x05\x0f\xed\x03\xb1dJ\x00"
    b"\x83\xc0\xea\xc1\x05\x0f\xef\x041vL\xfb\xfb\x00\x97A"
    b"\x05/\xe7\x04\xb2\nR\x06\xbc\x80!\xc1\x01Pb\xfd\xa6lT"
    b"\x06\xd0\x00h\xe1\x000`\xff\xe8TV\xffU\xc0\xd9\xc1\x05O"
    b"\xeb\x03\xb1\x92^\xfe\xbd\x80\xca\xb1\x04\xef\xf5\x03q``"
    b"\x06\xbb\xc0\x9d1\x02\xb0\x97\x05\n\x06f\xff\xfe\xc0\xe8"
    b"\xb1\x05o\xf3\x03\xd1rh\xfdA\x80\xb41\x05\xcf\xeb\x03\xf1"
    b"\x82j\xfe_@\xc61\x05O\xe9\x03\xb1J\x9a\xfd\xd8\xc0\xb9A"
    b"\x05/\xef\x03\xd1n\xb0\xfac\x00g\x81\x05\xef5\x13ST\xbe"
    b"\x06\xe4\x80yA\x01Pa\x01\xa8\xc6"
)


@pytest.fixture
def pit_stop():
    return MsgPitLaneExtended(raw).pit_stop


def test_race_lap(pit_stop):
    assert pit_stop.race_lap == 103


def test_lap(pit_stop):
    assert pit_stop.lap == 103


def test_flag(pit_stop):
    assert pit_stop.flag == Flag.YELLOW


def test_flags(pit_stop):
    assert pit_stop.flags == 0


def test_rank_in(pit_stop):
    assert pit_stop.rank_in == 13


def test_rank_out(pit_stop):
    assert pit_stop.rank_out == 14


def test_to_stop(pit_stop):
    assert pit_stop.to_stop == 9.7


def test_to_left_jack_up(pit_stop):
    assert pit_stop.to_left_jack_up == 19.7


def test_to_left_jack_dn(pit_stop):
    assert pit_stop.to_left_jack_dn == 23.7


def test_to_right_jack_up(pit_stop):
    assert pit_stop.to_right_jack_up == 10.7


def test_to_right_jack_dn(pit_stop):
    assert pit_stop.to_right_jack_dn == 16.3


def test_to_restart(pit_stop):
    assert pit_stop.to_restart == 24.2


def test_to_exit(pit_stop):
    assert pit_stop.to_exit == 44.2


def test_tires(pit_stop):
    assert pit_stop.tires == 4


def test_pit_group(pit_stop):
    assert pit_stop.pit_group == 1


def test_tires_is_estimate(pit_stop):
    assert pit_stop.tires_is_estimate == False


def test_abnormal_stop(pit_stop):
    assert pit_stop.abnormal_stop == False
