from typing import Any, Dict, List, Optional, Union

import httpx

from ...client import AuthenticatedClient
from ...models.get_chunks_response_200_item import GetChunksResponse_200Item
from ...types import UNSET, Response, Unset


def _get_kwargs(
    *,
    client: AuthenticatedClient,
    chunks_in: List[str],
    fields: List[str],
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> Dict[str, Any]:
    url = "{}/api/v1/files/chunks/".format(client.base_url)

    headers: Dict[str, Any] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    json_chunks_in = chunks_in

    json_fields = fields

    params: Dict[str, Any] = {
        "chunks_in": json_chunks_in,
        "fields": json_fields,
        "limit": limit,
        "offset": offset,
    }
    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    return {
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "params": params,
    }


def _parse_response(*, response: httpx.Response) -> Optional[Union[List[GetChunksResponse_200Item], None, None]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = GetChunksResponse_200Item.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200
    if response.status_code == 401:
        response_401 = None

        return response_401
    if response.status_code == 422:
        response_422 = None

        return response_422
    return None


def _build_response(*, response: httpx.Response) -> Response[Union[List[GetChunksResponse_200Item], None, None]]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
    chunks_in: List[str],
    fields: List[str],
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> Response[Union[List[GetChunksResponse_200Item], None, None]]:
    kwargs = _get_kwargs(
        client=client,
        chunks_in=chunks_in,
        fields=fields,
        limit=limit,
        offset=offset,
    )

    response = httpx.get(
        **kwargs,
    )

    return _build_response(response=response)


def sync(
    *,
    client: AuthenticatedClient,
    chunks_in: List[str],
    fields: List[str],
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> Optional[Union[List[GetChunksResponse_200Item], None, None]]:
    """ Get the chunks entities from a given list of chunk ids. """

    return sync_detailed(
        client=client,
        chunks_in=chunks_in,
        fields=fields,
        limit=limit,
        offset=offset,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
    chunks_in: List[str],
    fields: List[str],
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> Response[Union[List[GetChunksResponse_200Item], None, None]]:
    kwargs = _get_kwargs(
        client=client,
        chunks_in=chunks_in,
        fields=fields,
        limit=limit,
        offset=offset,
    )

    async with httpx.AsyncClient() as _client:
        response = await _client.get(**kwargs)

    return _build_response(response=response)


async def asyncio(
    *,
    client: AuthenticatedClient,
    chunks_in: List[str],
    fields: List[str],
    limit: Union[Unset, int] = 100,
    offset: Union[Unset, int] = 0,
) -> Optional[Union[List[GetChunksResponse_200Item], None, None]]:
    """ Get the chunks entities from a given list of chunk ids. """

    return (
        await asyncio_detailed(
            client=client,
            chunks_in=chunks_in,
            fields=fields,
            limit=limit,
            offset=offset,
        )
    ).parsed
